/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.locks.Lock;
import org.junit.platform.engine.support.hierarchical.ResourceLock;

class SingleLock
implements ResourceLock {
    private final Lock lock;

    SingleLock(Lock lock) {
        this.lock = lock;
    }

    Lock getLock() {
        return this.lock;
    }

    @Override
    public ResourceLock acquire() throws InterruptedException {
        ForkJoinPool.managedBlock(new SingleLockManagedBlocker());
        return this;
    }

    @Override
    public void release() {
        this.lock.unlock();
    }

    private class SingleLockManagedBlocker
    implements ForkJoinPool.ManagedBlocker {
        private boolean acquired;

        private SingleLockManagedBlocker() {
        }

        @Override
        public boolean block() throws InterruptedException {
            SingleLock.this.lock.lockInterruptibly();
            this.acquired = true;
            return true;
        }

        @Override
        public boolean isReleasable() {
            return this.acquired || SingleLock.this.lock.tryLock();
        }
    }
}

