/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.render.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.render.afp.tools.BinaryUtils;

public class IncludePageOverlay
extends AbstractNamedAFPObject {
    private int _xCoor = 0;
    private int _yCoor = 0;
    private int _orientation = 0;

    public IncludePageOverlay(String overlayName, int x, int y, int orientation) {
        super(overlayName);
        this._xCoor = x;
        this._yCoor = y;
        this.setOrientation(orientation);
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 90 && orientation != 180 && orientation != 270) {
            throw new IllegalArgumentException("The orientation must be one of the values 0, 90, 180, 270");
        }
        this._orientation = orientation;
    }

    public void writeDataStream(OutputStream os) throws IOException {
        byte[] data = new byte[25];
        data[0] = 90;
        byte[] rl1 = BinaryUtils.convert(24, 2);
        data[1] = rl1[0];
        data[2] = rl1[1];
        data[3] = -45;
        data[4] = -81;
        data[5] = -40;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this._nameBytes.length; ++i) {
            data[9 + i] = this._nameBytes[i];
        }
        byte[] r2 = BinaryUtils.convert(this._xCoor, 3);
        data[17] = r2[0];
        data[18] = r2[1];
        data[19] = r2[2];
        byte[] r3 = BinaryUtils.convert(this._yCoor, 3);
        data[20] = r3[0];
        data[21] = r3[1];
        data[22] = r3[2];
        switch (this._orientation) {
            case 90: {
                data[23] = 45;
                data[24] = 0;
                break;
            }
            case 180: {
                data[23] = 90;
                data[24] = 0;
                break;
            }
            case 270: {
                data[23] = -121;
                data[24] = 0;
                break;
            }
            default: {
                data[23] = 0;
                data[24] = 0;
            }
        }
        os.write(data);
    }
}

