/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.dates;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import tr.prefs.dates.DatesOptionsPanelController;
import tr.prefs.dates.DatesPrefs;

final class DatesOptionsPanel
extends JPanel {
    private final DatesOptionsPanelController controller;
    private static Vector<ComboItem> days;
    private static Vector<ComboItem> orders;
    private JComboBox dayCombo;
    private JLabel dayLabel;
    private JComboBox orderCombo;
    private JLabel orderLabel;

    DatesOptionsPanel(DatesOptionsPanelController controller) {
        this.controller = controller;
        this.initForm();
    }

    private void initForm() {
        this.initComponents();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        this.dayLabel = new JLabel(this.getMsg("Dates.FirstDayOfWeek"));
        this.dayCombo = new JComboBox();
        this.dayCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatesOptionsPanel.this.controller.changed();
            }
        });
        this.orderLabel = new JLabel(this.getMsg("Dates.Order"));
        this.orderCombo = new JComboBox();
        this.orderCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatesOptionsPanel.this.controller.changed();
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]2[]0", "0[]2[]0"));
        panel.add((Component)this.dayLabel, "align left");
        panel.add((Component)this.dayCombo, "align left, wrap");
        panel.add((Component)this.orderLabel, "align right");
        panel.add((Component)this.orderCombo, "align left, wrap");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    private String getMsg(String key) {
        return NbBundle.getMessage(DatesOptionsPanel.class, (String)key);
    }

    void load() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doLoad();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DatesOptionsPanel.this.doLoad();
                }
            });
        }
    }

    private void doLoad() {
        this.initDayItems();
        this.dayCombo.setModel(new DefaultComboBoxModel<ComboItem>(days));
        this.dayCombo.setMaximumRowCount(days.size());
        this.dayCombo.setSelectedItem(this.getDayItem(DatesPrefs.getFirstDayOfWeek()));
        this.initOrderItems();
        this.orderCombo.setModel(new DefaultComboBoxModel<ComboItem>(orders));
        this.orderCombo.setMaximumRowCount(orders.size());
        this.orderCombo.setSelectedItem(this.getOrderItem(DatesPrefs.getDateOrder()));
    }

    private void initDayItems() {
        days = new Vector();
        days.add(new ComboItem(NbBundle.getMessage(this.getClass(), (String)"Sunday"), 1));
        days.add(new ComboItem(NbBundle.getMessage(this.getClass(), (String)"Monday"), 2));
    }

    private void initOrderItems() {
        orders = new Vector();
        orders.add(new ComboItem(NbBundle.getMessage(this.getClass(), (String)"MMDDYY"), 0));
        orders.add(new ComboItem(NbBundle.getMessage(this.getClass(), (String)"DDMMYY"), 1));
    }

    void store() {
        ComboItem orderItem;
        ComboItem dayItem = (ComboItem)this.dayCombo.getSelectedItem();
        if (dayItem != null) {
            DatesPrefs.setFirstDayOfWeek(dayItem.value);
        }
        if ((orderItem = (ComboItem)this.orderCombo.getSelectedItem()) != null) {
            DatesPrefs.setDateOrder(orderItem.value);
        }
    }

    boolean valid() {
        return true;
    }

    private ComboItem getDayItem(int value) {
        for (ComboItem item : days) {
            if (item.value != value) continue;
            return item;
        }
        return days.get(0);
    }

    private ComboItem getOrderItem(int value) {
        for (ComboItem item : orders) {
            if (item.value != value) continue;
            return item;
        }
        return orders.get(0);
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(0, 0));
        this.setLayout(new BorderLayout());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComboItem
    implements Comparable<ComboItem> {
        public final String label;
        public final int value;

        public ComboItem(String label, int value) {
            this.label = label;
            this.value = value;
        }

        public String toString() {
            return this.label;
        }

        @Override
        public int compareTo(ComboItem item) {
            return item.label.compareToIgnoreCase(this.label);
        }
    }
}

