/*
 * Decompiled with CFR 0.152.
 */
package org.projectlibre.export;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import com.projectlibre1.job.Job;
import com.projectlibre1.job.JobQueue;
import com.projectlibre1.job.JobRunnable;
import com.projectlibre1.print.ExtendedPageFormat;
import com.projectlibre1.print.GraphPageable;
import com.projectlibre1.print.ViewPrintable;
import com.projectlibre1.session.SessionFactory;
import java.awt.Component;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class PDFExport {
    private static JFileChooser chooser = null;

    public static void export(final GraphPageable graphPageable, Component component) throws IOException {
        final File file = PDFExport.chooseFile(graphPageable.getRenderer().getProject().getName(), component);
        JobQueue jobQueue = SessionFactory.getInstance().getJobQueue();
        Job job = new Job(jobQueue, "PDF Export", "Exporting PDF...", true, component);
        job.addRunnable(new JobRunnable("PDF Export", 1.0f){

            @Override
            public Object run() throws Exception {
                Document document = new Document();
                PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file));
                graphPageable.update();
                int n = graphPageable.getNumberOfPages();
                if (n > 0) {
                    ViewPrintable viewPrintable = graphPageable.getSafePrintable();
                    ExtendedPageFormat extendedPageFormat = graphPageable.getSafePageFormat();
                    double d = extendedPageFormat.getWidth();
                    double d2 = extendedPageFormat.getHeight();
                    float f = 0.1f;
                    float f2 = 0.0f;
                    float f3 = (1.0f - f - f2) / (float)n;
                    for (int i = 0; i < n; ++i) {
                        this.setProgress(f + (float)i * f3);
                        document.setPageSize(new Rectangle((float)d, (float)d2));
                        if (i == 0) {
                            document.open();
                        } else {
                            document.newPage();
                        }
                        Graphics2D graphics2D = pdfWriter.getDirectContent().createGraphics((float)d, (float)d2);
                        viewPrintable.print(graphics2D, i);
                        graphics2D.dispose();
                    }
                    document.close();
                }
                this.setProgress(1.0f);
                return null;
            }
        });
        jobQueue.schedule(job);
    }

    private static File chooseFile(String string, Component component) {
        if (chooser == null) {
            chooser = new JFileChooser();
            chooser.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
            chooser.setDialogType(1);
            chooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".pdf");
                }

                @Override
                public String getDescription() {
                    return "PDF (*.pdf)";
                }
            });
        }
        if (string.length() == 0) {
            string = "project";
        }
        chooser.setSelectedFile(new File(string + ".pdf"));
        if (chooser.showDialog(component, null) == 0) {
            File file = chooser.getSelectedFile();
            if (!file.getName().endsWith(".pdf")) {
                file = new File(file.getName() + ".pdf");
            }
            return file;
        }
        return null;
    }
}

