/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.preference;

import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;

public class ConfigurationFile {
    private static final String[] OPENPROJ_CONF_DIRS = new String[]{".projectlibre", "ProjectLibre"};
    private static File confFile;
    private static final String OPENPROJ_CONF_FILE = "projectlibre.conf";
    private static Properties confProps;
    private static Locale locale;
    private static final String OPENPROJ_RUN_CONF_FILE = "run.conf";
    private static Properties runProps;

    public static File getConfDir() {
        String string;
        if (confFile == null && (string = System.getProperty("user.home")) != null) {
            for (int i = 0; i < OPENPROJ_CONF_DIRS.length; ++i) {
                File file = new File(string + File.separator + OPENPROJ_CONF_DIRS[i]);
                if (!file.isDirectory()) continue;
                System.out.println("Conf file " + file.getPath() + " found");
                confFile = file;
                return file;
            }
        }
        return confFile;
    }

    public static String getProperty(String string) {
        Object object;
        if ("locale".equals(string) && !"default".equals(object = Preferences.userNodeForPackage(ConfigurationFile.class).get("locale", "default"))) {
            return object;
        }
        if (confProps == null) {
            object = ConfigurationFile.getConfDir();
            if (object == null) {
                return null;
            }
            File file = new File((File)object, OPENPROJ_CONF_FILE);
            if (!file.exists()) {
                return null;
            }
            confProps = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                confProps.load(fileInputStream);
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return confProps.getProperty(string);
    }

    public static Locale getLocale() {
        if (locale == null) {
            String string = ConfigurationFile.getProperty("locale");
            locale = string == null ? Locale.getDefault() : ConfigurationFile.getLocale(string);
        }
        return locale;
    }

    public static Locale getLocale(String string) {
        Locale locale = Locale.getDefault();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_-");
        if (!stringTokenizer.hasMoreTokens()) {
            ConfigurationFile.locale = locale;
        } else {
            string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                ConfigurationFile.locale = new Locale(string2, locale.getCountry());
            } else {
                string3 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    ConfigurationFile.locale = new Locale(string2, string3);
                } else {
                    string4 = stringTokenizer.nextToken();
                    ConfigurationFile.locale = new Locale(string2, string3, string4);
                }
            }
        }
        return ConfigurationFile.locale;
    }

    public static String[] getLocaleCodes(String string) {
        Locale locale = Locale.getDefault();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_-");
        if (!stringTokenizer.hasMoreTokens()) {
            ConfigurationFile.locale = locale;
        } else {
            string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                ConfigurationFile.locale = new Locale(string2, locale.getCountry());
            } else {
                string3 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    ConfigurationFile.locale = new Locale(string2, string3);
                } else {
                    string4 = stringTokenizer.nextToken();
                }
            }
        }
        return new String[]{string2, string3, string4};
    }

    public static String getRunProperty(String string) {
        if (runProps == null) {
            File file = ConfigurationFile.getConfDir();
            if (file == null) {
                return null;
            }
            File file2 = new File(file, OPENPROJ_RUN_CONF_FILE);
            if (!file2.exists()) {
                return null;
            }
            runProps = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                runProps.load(fileInputStream);
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return runProps.getProperty(string);
    }

    public static File getGeneratedDirectory(String string) {
        File file = new File(string, "import");
        return file.isDirectory() ? file : null;
    }

    public static File getExportDirectory(String string) {
        File file = new File(string, "export");
        return file.isDirectory() ? file : null;
    }

    public static ResourceBundle getDirectoryBundle(String string) {
        URL[] uRLArray;
        File file = null;
        Preferences preferences = Preferences.userNodeForPackage(ConfigurationFile.class);
        if (preferences.getBoolean("useExternalLocales", false) && !(file = new File((String)(uRLArray = preferences.get("externalLocalesDirectory", "")), "import")).isDirectory()) {
            return null;
        }
        try {
            uRLArray = new URL[]{file.toURI().toURL()};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault(), uRLClassLoader);
            return resourceBundle;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    static {
        locale = null;
    }
}

