/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.spreadsheet.editor;

import com.projectlibre1.datatype.CanSupplyRateUnit;
import com.projectlibre1.datatype.RateFormat;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projectlibre1.pm.graphic.spreadsheet.editor.SimpleEditor;
import com.projectlibre1.pm.graphic.spreadsheet.renderer.RateRenderer;
import java.awt.Component;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTable;
import javax.swing.JTextField;

public class RateEditor
extends SimpleEditor {
    private static NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    String timeUnit = null;
    boolean money = false;
    boolean percent = false;
    boolean temporal = true;

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        SpreadSheetModel spreadSheetModel = (SpreadSheetModel)jTable.getModel();
        Object object2 = spreadSheetModel.getObjectInRow(n);
        boolean bl2 = true;
        if (object2 instanceof CanSupplyRateUnit) {
            boolean bl3 = bl2 = ((CanSupplyRateUnit)object2).getTimeUnitLabel() == null;
        }
        if (!bl2) {
            this.percent = false;
            this.temporal = false;
        }
        JTextField jTextField = (JTextField)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        jTextField.setText(RateRenderer.getFormat(jTable, n, n2).format(object));
        return jTextField;
    }

    public RateEditor(String string, boolean bl, boolean bl2, boolean bl3) {
        this.money = bl;
        this.percent = bl2;
        this.temporal = bl3;
        this.timeUnit = string;
    }

    @Override
    public Object getCellEditorValue() {
        try {
            return RateFormat.getInstance(this.timeUnit, this.money, this.percent, this.temporal).parseObject(this.component.getText());
        }
        catch (ParseException parseException) {
            try {
                return NUMBER_FORMAT.parseObject(this.component.getText());
            }
            catch (ParseException parseException2) {
                return null;
            }
        }
    }
}

