/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.projectlibre1.dialog.AbstractDialog;
import com.projectlibre1.dialog.util.FieldComponentMap;
import com.projectlibre1.document.Document;
import com.projectlibre1.document.ObjectEvent;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.pm.graphic.frames.DocumentSelectedEvent;
import com.projectlibre1.pm.graphic.spreadsheet.selection.event.SelectionNodeEvent;
import com.projectlibre1.pm.graphic.spreadsheet.selection.event.SelectionNodeListener;
import com.projectlibre1.pm.resource.Resource;
import com.projectlibre1.pm.scheduling.Schedule;
import com.projectlibre1.pm.scheduling.ScheduleEvent;
import com.projectlibre1.pm.scheduling.ScheduleEventListener;
import com.projectlibre1.pm.task.BelongsToDocument;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.pm.task.Task;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.DataUtils;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoableEditSupport;
import org.apache.commons.lang.StringUtils;

public abstract class FieldDialog
extends AbstractDialog
implements ObjectEvent.Listener,
ScheduleEventListener,
SelectionNodeListener,
DocumentSelectedEvent.Listener {
    private boolean multipleObjects;
    private Class objectClass;
    private UndoableEditSupport undoableEditSupport;
    protected ArrayList maps = new ArrayList();
    protected Object object;
    protected ArrayList collection = new ArrayList();
    private JComponent dirtyComponent;
    protected JComponent mainComponent = null;

    protected FieldDialog(Frame frame, String string, boolean bl, boolean bl2) {
        super(frame, string, bl);
        this.multipleObjects = bl2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FieldDialog.this.updateAll();
            }
        });
    }

    protected FieldComponentMap createMap() {
        FieldComponentMap fieldComponentMap = this.multipleObjects ? new FieldComponentMap(this.collection) : new FieldComponentMap(this.object);
        this.maps.add(fieldComponentMap);
        return fieldComponentMap;
    }

    protected Object getObject() {
        return this.object;
    }

    protected Collection getCollection() {
        return this.collection;
    }

    protected Object getFirstObject() {
        if (this.collection == null) {
            return this.object;
        }
        Iterator iterator = this.collection.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    protected void onCancel() {
        this.updateAll();
    }

    public void setType(boolean bl) {
        this.objectClass = bl ? Task.class : Resource.class;
        this.setTitle(bl ? Messages.getString("FieldDialog.TaskInformation") : Messages.getString("FieldDialog.ResourceInformation"));
    }

    public void setObjectClass(Class clazz) {
        this.objectClass = clazz;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    @Override
    public void objectChanged(ObjectEvent objectEvent) {
        if (!this.isVisible()) {
            return;
        }
        if (this.multipleObjects && this.collection.contains(objectEvent.getObject())) {
            this.updateAll();
        } else if (objectEvent.getObject() == this.getObject()) {
            this.updateAll();
        }
    }

    @Override
    public void scheduleChanged(ScheduleEvent scheduleEvent) {
        if (!this.isVisible()) {
            return;
        }
        if (this.multipleObjects) {
            this.updateAll();
        } else if (this.getObject() != null && ((Schedule)this.getObject()).isJustModified()) {
            this.updateAll();
        }
    }

    @Override
    public void documentSelected(DocumentSelectedEvent documentSelectedEvent) {
        System.out.println(Messages.getString("FieldDialog.document") + documentSelectedEvent.getCurrent());
    }

    @Override
    public void selectionChanged(SelectionNodeEvent selectionNodeEvent) {
        if (!this.isVisible()) {
            return;
        }
        if (this.multipleObjects) {
            this.setCollection(selectionNodeEvent.getNodes());
        } else {
            Node node = selectionNodeEvent.getCurrentNode();
            if (node == null) {
                return;
            }
            Object object = node.getImpl();
            object = DataUtils.extractObjectOfClass(object, this.objectClass);
            this.setObject(object);
            this.updateAll();
        }
    }

    public void setCollection(Collection collection) {
        DataUtils.extractObjectsOfClassFromNodeList(this.collection, collection, this.objectClass);
    }

    public void setObject(Object object) {
        Document document;
        if (object == this.object) {
            return;
        }
        if (this.object != null && this.object instanceof BelongsToDocument) {
            document = ((BelongsToDocument)this.object).getDocument();
            document.removeObjectListener(this);
            if (document instanceof Project) {
                ((Project)document).removeScheduleListener(this);
            }
        }
        this.object = object;
        if (object != null && object instanceof BelongsToDocument) {
            document = ((BelongsToDocument)this.object).getDocument();
            document.addObjectListener(this);
            if (document instanceof Project) {
                ((Project)document).addScheduleListener(this);
            }
        }
    }

    @Override
    protected void activateListeners() {
    }

    @Override
    protected void desactivateListeners() {
        this.setObject(null);
    }

    @Override
    public JComponent createContentPanel() {
        return null;
    }

    protected void updateAll() {
        this.setVisibleAndEnabledState();
        for (FieldComponentMap fieldComponentMap : this.maps) {
            fieldComponentMap.setObject(this.object);
            fieldComponentMap.updateAll();
        }
    }

    protected void setVisibleAndEnabledState() {
        boolean bl;
        boolean bl2 = bl = this.object != null;
        if (this.mainComponent != null) {
            this.mainComponent.setEnabled(bl);
        }
    }

    public void setDirtyComponent(JComponent jComponent) {
        this.dirtyComponent = jComponent;
    }

    @Override
    public void onOk() {
        InputVerifier inputVerifier;
        if (this.dirtyComponent != null && !(inputVerifier = this.dirtyComponent.getInputVerifier()).shouldYieldFocus(this.dirtyComponent)) {
            return;
        }
        super.onOk();
    }

    protected JComponent createFieldsPanel(FieldComponentMap fieldComponentMap, Collection collection) {
        if (collection == null || collection.size() == 0) {
            return null;
        }
        FormLayout formLayout = new FormLayout("p, 3dlu, fill:160dlu:grow", StringUtils.chomp(StringUtils.repeat("p,3dlu,", collection.size())));
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        fieldComponentMap.append(defaultFormBuilder, collection);
        return defaultFormBuilder.getPanel();
    }
}

