/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.gimmicks;

import de.escape.quincunx.gimmicks.ImageCanvas;
import de.escape.quincunx.gimmicks.InsetPanel;
import de.escape.quincunx.gimmicks.LowerArea;
import de.escape.quincunx.gimmicks.MultiLineLabel;
import de.escape.quincunx.gimmicks.OkAdapter;
import de.escape.quincunx.gimmicks.OkListener;
import de.escape.quincunx.gimmicks.Utility;
import de.escape.quincunx.i18n.I18n;
import de.escape.quincunx.i18n.RButton;
import de.escape.quincunx.i18n.RPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class InfoBox
extends Dialog
implements OkListener {
    static Image defaultImage;
    private ImageCanvas imageCanvas;

    private void doInit(Component compo, String info, Image image) {
        Frame parent = Utility.getFrame(compo);
        MultiLineLabel ml = new MultiLineLabel(info);
        if (image == null) {
            if (defaultImage == null) {
                defaultImage = Utility.loadImage("info.gif");
            }
            image = defaultImage;
        }
        this.imageCanvas = new ImageCanvas(image, false);
        InsetPanel show = new InsetPanel((LayoutManager)new BorderLayout(), 10);
        show.add((Component)new ImageCanvas(image), "West");
        show.add(ml);
        this.setLayout(new BorderLayout());
        this.add(show);
        RPanel panel = new RPanel(new FlowLayout(1));
        RButton ok = new RButton("Ok");
        panel.add(ok);
        this.add((Component)new LowerArea(panel), "South");
        ok.addActionListener(new OkAdapter(this));
        this.setModal(true);
        this.pack();
        Rectangle pBounds = parent.getBounds();
        if (pBounds.width == 0 || pBounds.height == 0) {
            Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
            pBounds = new Rectangle(0, 0, screensize.width, screensize.height);
        }
        Dimension size = this.getSize();
        ((Component)this).setLocation(pBounds.x + (pBounds.width - size.width) / 2, pBounds.y + (pBounds.height - size.height) / 2);
        this.show();
    }

    public InfoBox(Component compo, String info) {
        super(Utility.getFrame(compo), I18n.getString("Info"));
        this.doInit(compo, info, null);
    }

    public InfoBox(Component compo, String info, Image image) {
        super(Utility.getFrame(compo), I18n.getString("Info"));
        this.doInit(compo, info, image);
    }

    public InfoBox(Component compo, String title, String info) {
        super(Utility.getFrame(compo), title);
        this.doInit(compo, info, null);
    }

    public InfoBox(Component compo, String title, String info, Image image) {
        super(Utility.getFrame(compo), title);
        this.doInit(compo, info, image);
    }

    public void setImage(Image img) {
        this.imageCanvas.setImage(img);
        this.repaint();
    }

    public void okPressed() {
        this.dispose();
    }
}

