/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DxfEntity;
import de.escape.quincunx.gimmicks.Counter;
import java.util.Enumeration;
import java.util.Hashtable;

public final class DxfEntityCounter {
    private static Class entityClass = new DxfEntity().getClass();
    private Hashtable class2name = new Hashtable(23);
    private Hashtable counts = new Hashtable(23);

    private static String getDxfEntityName(Class cl) {
        if (cl == entityClass) {
            return null;
        }
        String className = cl.getName();
        int index = className.lastIndexOf(".Dxf");
        if (index == -1) {
            return null;
        }
        return className.substring(index + 4);
    }

    public void add(DxfEntity ent) {
        Class<?> cl = ent.getClass();
        String name = (String)this.class2name.get(cl);
        if (name == null) {
            name = DxfEntityCounter.getDxfEntityName(cl);
            if (name == null) {
                return;
            }
            this.class2name.put(cl, name);
        }
        this.add(name);
    }

    public void add(String name) {
        Counter cnt = (Counter)this.counts.get(name);
        if (cnt == null) {
            cnt = new Counter(1);
            this.counts.put(name, cnt);
        } else {
            cnt.add1();
        }
    }

    public int getCount(DxfEntity ent) {
        Class<?> cl = ent.getClass();
        String name = (String)this.class2name.get(cl);
        if (name == null) {
            name = DxfEntityCounter.getDxfEntityName(cl);
        }
        return this.getCount(name);
    }

    public int getCount(String name) {
        if (name == null) {
            return 0;
        }
        Counter cnt = (Counter)this.counts.get(name);
        return cnt == null ? 0 : cnt.getValue();
    }

    public Enumeration getEntityNames() {
        return this.counts.keys();
    }
}

