/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.DrawAble;
import de.escape.quincunx.dxf.DrawLines;
import de.escape.quincunx.dxf.DrawLinesWithWidth;
import de.escape.quincunx.dxf.DrawPolygon;
import de.escape.quincunx.dxf.DrawSet;
import de.escape.quincunx.dxf.DrawText;
import de.escape.quincunx.dxf.DxfFont;
import de.escape.quincunx.dxf.DxfFontFromStream;
import de.escape.quincunx.dxf.DxfViewer;
import de.escape.quincunx.dxf.FontFinder;
import de.escape.quincunx.dxf.reader.Dxf3DFACE;
import de.escape.quincunx.dxf.reader.DxfARC;
import de.escape.quincunx.dxf.reader.DxfATTDEF;
import de.escape.quincunx.dxf.reader.DxfATTRIB;
import de.escape.quincunx.dxf.reader.DxfBLOCK;
import de.escape.quincunx.dxf.reader.DxfCIRCLE;
import de.escape.quincunx.dxf.reader.DxfConverter;
import de.escape.quincunx.dxf.reader.DxfDIMENSION;
import de.escape.quincunx.dxf.reader.DxfEntity;
import de.escape.quincunx.dxf.reader.DxfEntitySet;
import de.escape.quincunx.dxf.reader.DxfException;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.dxf.reader.DxfINSERT;
import de.escape.quincunx.dxf.reader.DxfLINE;
import de.escape.quincunx.dxf.reader.DxfPOINT;
import de.escape.quincunx.dxf.reader.DxfPOLYLINE;
import de.escape.quincunx.dxf.reader.DxfReporter;
import de.escape.quincunx.dxf.reader.DxfSOLID;
import de.escape.quincunx.dxf.reader.DxfTEXT;
import de.escape.quincunx.dxf.reader.DxfTRACE;
import de.escape.quincunx.dxf.reader.DxfVERTEX;
import de.escape.quincunx.gimmicks.Utility;
import de.escape.quincunx.trafo.Matrix4D;
import de.escape.quincunx.trafo.Point3D;
import de.escape.quincunx.trafo.Vector3D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class DrawableConverter
implements DxfConverter,
FontFinder {
    protected static final boolean DISCARD_PAPER_ENTITIES = true;
    protected static final boolean STRIP_FONT_8 = true;
    protected static final int CIRCLE_SEGMENTS = 36;
    protected Hashtable blockHash = new Hashtable(89);
    protected Hashtable fontHash = new Hashtable(89);
    protected DrawSet complete;
    private static String fontFileHead = "fonts/Dxf";
    private static String fontFileExt = ".dvft";
    private static boolean txtTested;
    private static DxfFont txtFont;

    public DrawableConverter() {
        if (!txtTested) {
            try {
                txtFont = this.getFont("TXT", null);
            }
            catch (DxfException dxfException) {}
            txtTested = true;
        }
    }

    public void convert(DxfFile dxf) {
        DxfEntitySet entities = dxf.getEntities().getEntitySet();
        if (entities != null) {
            int nrEntities = entities.getNrOfEntities();
            this.complete = new DrawSet(nrEntities);
            int nr = 0;
            Enumeration e = entities.getEntities();
            while (e.hasMoreElements()) {
                DxfEntity ent = (DxfEntity)e.nextElement();
                if (DxfViewer.debugLevel > 10) {
                    System.out.println("Converting " + ent);
                }
                dxf.showProgress(nr, nrEntities);
                ent.convert(this, dxf, (Object)this.complete);
                ++nr;
            }
            dxf.showProgress(1.0f);
        }
    }

    public void convert(Dxf3DFACE face, DxfFile dxf, Object collector) {
        if (face.getTile()) {
            return;
        }
        Point3D[] corner = face.getCorners();
        int maxp = 3;
        while (maxp >= 1) {
            if (corner[maxp].x != corner[maxp - 1].x || corner[maxp].y != corner[maxp - 1].y || corner[maxp].z != corner[maxp - 1].z) break;
            --maxp;
        }
        DrawPolygon poly = new DrawPolygon(maxp + 1);
        int i = 0;
        while (i <= maxp) {
            poly.addPoint(corner[i]);
            ++i;
        }
        poly.calcNormal();
        DrawableConverter.setEntityInfo(poly, face);
        ((DrawSet)collector).addDrawable(DrawableConverter.finalConv(poly, face, false));
    }

    public void convert(DxfARC arc, DxfFile dxf, Object collector) {
        DrawLines line;
        if (arc.getTile()) {
            return;
        }
        float radius = arc.getRadius();
        float startAngle = arc.getStartAngle();
        float endAngle = arc.getEndAngle();
        Point3D center = arc.getCenter();
        if (radius > 0.0f) {
            while (endAngle <= startAngle) {
                endAngle += (float)Math.PI * 2;
            }
            while (endAngle - startAngle > (float)Math.PI * 2) {
                endAngle -= (float)Math.PI * 2;
            }
            int nrSegments = (int)Math.ceil((double)((endAngle - startAngle) * 36.0f) / 2.0 / Math.PI);
            if (nrSegments < 2) {
                nrSegments = 2;
            }
            line = new DrawLines(nrSegments + 1);
            float delta = (endAngle - startAngle) / (float)nrSegments;
            if (delta == 0.0f) {
                nrSegments = 36;
                delta = (float)(Math.PI * 2 / (double)nrSegments);
            }
            float angle = startAngle;
            int i = 0;
            while (i < nrSegments + 1) {
                line.addPoint(center.x + (float)((double)radius * Math.cos(angle)), center.y + (float)((double)radius * Math.sin(angle)), center.z);
                ++i;
                angle += delta;
            }
        } else {
            line = new DrawLines(1);
            line.addPoint(center);
        }
        DrawableConverter.setEntityInfo(line, arc);
        ((DrawSet)collector).addDrawable(DrawableConverter.finalConv(line, arc));
    }

    public void convert(DxfBLOCK block, DxfFile dxf, Object collector) {
        DrawSet converted = (DrawSet)this.blockHash.get(block.getBlockName());
        if (converted == null) {
            Point3D refPoint = block.getReferencePoint();
            Matrix4D tmat = new Matrix4D(1.0f, 0.0f, 0.0f, -refPoint.x, 0.0f, 1.0f, 0.0f, -refPoint.y, 0.0f, 0.0f, 1.0f, -refPoint.z, 0.0f, 0.0f, 0.0f, 1.0f);
            converted = new DrawSet(tmat, 1);
            block.getEntities().convert(this, dxf, converted);
            DxfEntitySet attdefs = block.getAttdefSet();
            if (attdefs != null) {
                Enumeration e = attdefs.getEntities();
                while (e.hasMoreElements()) {
                    DxfATTDEF attdef = (DxfATTDEF)e.nextElement();
                    if ((attdef.getAttributeFlags() & 2) == 0) continue;
                    attdef.convert(this, dxf, (Object)converted);
                }
            }
            DrawableConverter.setEntityInfo(converted, block);
            this.blockHash.put(block.getBlockName(), converted);
        }
        ((DrawSet)collector).addDrawable(converted);
    }

    public void convert(DxfCIRCLE circle, DxfFile dxf, Object collector) {
        DrawLines line;
        if (circle.getTile()) {
            return;
        }
        float radius = circle.getRadius();
        Point3D center = circle.getCenter();
        if (radius > 0.0f) {
            line = new DrawLines(36);
            float delta = 0.17453292f;
            float angle = 0.0f;
            int i = 0;
            while (i < 36) {
                line.addPoint(center.x + (float)((double)radius * Math.cos(angle)), center.y + (float)((double)radius * Math.sin(angle)), center.z);
                ++i;
                angle += delta;
            }
            line.close();
        } else {
            line = new DrawLines(1);
            line.addPoint(center);
        }
        DrawableConverter.setEntityInfo(line, circle);
        ((DrawSet)collector).addDrawable(DrawableConverter.finalConv(line, circle));
    }

    public void convert(DxfDIMENSION dim, DxfFile dxf, Object collector) {
        if (dim.getTile()) {
            return;
        }
        DxfBLOCK block = dxf.getBlock(dim.getBlockName());
        if (block != null) {
            Point3D insert = dim.getInsertPoint();
            Matrix4D trafo = new Matrix4D(1.0f, 0.0f, 0.0f, insert.x, 0.0f, 1.0f, 0.0f, insert.y, 0.0f, 0.0f, 1.0f, insert.z, 0.0f, 0.0f, 0.0f, 1.0f);
            Matrix4D aaa = dim.calcArbitMat();
            if (aaa != null) {
                trafo.multLeftBy(aaa);
            }
            DrawSet set = new DrawSet(trafo, 1);
            ((DxfEntity)block).convert(this, dxf, (Object)set);
            DrawableConverter.setEntityInfo(set, dim);
            ((DrawSet)collector).addDrawable(set);
        }
    }

    public void convert(DxfINSERT insert, DxfFile dxf, Object collector) {
        if (insert.getTile()) {
            return;
        }
        DxfBLOCK block = dxf.getBlock(insert.getBlockName());
        if (block != null) {
            Matrix4D scaleMat = new Matrix4D(insert.getScaleX(), 0.0f, 0.0f, 0.0f, 0.0f, insert.getScaleY(), 0.0f, 0.0f, 0.0f, 0.0f, insert.getScaleZ(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
            Matrix4D rotationMat = new Matrix4D();
            rotationMat.zrot(insert.getRotation());
            Matrix4D aaaMat = insert.calcArbitMat();
            if (aaaMat == null) {
                aaaMat = new Matrix4D();
            }
            Matrix4D translationMat = new Matrix4D();
            translationMat.translate(new Vector3D(insert.getInsertPoint()));
            if (insert.getRows() > 1 || insert.getColumns() > 1) {
                DxfEntitySet attributes = insert.getAttributes();
                boolean withAttributes = insert.attributesFollowing() && attributes != null;
                DrawSet multi = new DrawSet(null, insert.getRows() * insert.getColumns() * (withAttributes ? 2 : 1));
                int row = insert.getRows() - 1;
                while (row >= 0) {
                    int col = insert.getColumns() - 1;
                    while (col >= 0) {
                        Vector3D translation = new Vector3D((float)col * insert.getColumnDistance(), (float)row * insert.getRowDistance(), 0.0f);
                        Matrix4D multiTransMat = new Matrix4D();
                        multiTransMat.translate(translation);
                        Matrix4D trafo = aaaMat.mult(translationMat.mult(rotationMat.mult(multiTransMat.mult(scaleMat))));
                        DrawSet set = new DrawSet(trafo, 1);
                        ((DxfEntity)block).convert(this, dxf, (Object)set);
                        DrawableConverter.setEntityInfo(set, insert);
                        multi.addDrawable(set);
                        if (withAttributes) {
                            Vector3D attTranslation = aaaMat.mult(rotationMat.mult(translation));
                            Matrix4D attTransMat = new Matrix4D();
                            attTransMat.translate(attTranslation);
                            DrawSet attSet = new DrawSet(attTransMat, 1);
                            this.convert(attributes, dxf, (Object)attSet);
                            multi.addDrawable(attSet);
                        }
                        --col;
                    }
                    --row;
                }
                ((DrawSet)collector).addDrawable(multi);
            } else {
                DxfEntitySet attributes;
                Matrix4D trafo = aaaMat.mult(translationMat.mult(rotationMat.mult(scaleMat)));
                DrawSet set = new DrawSet(trafo, 1);
                ((DxfEntity)block).convert(this, dxf, (Object)set);
                DrawableConverter.setEntityInfo(set, insert);
                ((DrawSet)collector).addDrawable(set);
                if (insert.attributesFollowing() && (attributes = insert.getAttributes()) != null) {
                    this.convert(attributes, dxf, collector);
                }
            }
        }
    }

    public void convert(DxfLINE line, DxfFile dxf, Object collector) {
        if (line.getTile()) {
            return;
        }
        DrawLines dline = new DrawLines(2);
        dline.addPoint(line.getStartPoint());
        dline.addPoint(line.getEndPoint());
        DrawableConverter.setEntityInfo(dline, line);
        ((DrawSet)collector).addDrawable(DrawableConverter.finalConv(dline, line, false));
    }

    public void convert(DxfPOINT point, DxfFile dxf, Object collector) {
        if (point.getTile()) {
            return;
        }
        DrawLines line = new DrawLines(1);
        line.addPoint(point.getPosition());
        DrawableConverter.setEntityInfo(line, point);
        ((DrawSet)collector).addDrawable(DrawableConverter.finalConv(line, point, false));
    }

    private static DrawAble convertPolyMesh(DxfPOLYLINE poly) {
        int k;
        int nrKnots = poly.getNrCtrlU() <= 0 ? 16 : poly.getNrCtrlU();
        int nrK = 0;
        Point3D[] knot = new Point3D[nrKnots];
        int nrFaces = poly.getNrCtrlV() <= 0 ? 4 : poly.getNrCtrlV();
        int nrF = 0;
        Object[] vertex = new int[4 * nrFaces];
        int nrV = 0;
        boolean lastWasInvisible = true;
        DxfEntitySet vertices = poly.getVertices();
        Enumeration e = vertices.getEntities();
        block0: while (e.hasMoreElements()) {
            Object[] tmp;
            DxfVERTEX v = (DxfVERTEX)e.nextElement();
            if ((v.getType() & 0x40) != 0) {
                if (nrK == nrKnots) {
                    tmp = new Point3D[2 * nrKnots];
                    System.arraycopy(knot, 0, tmp, 0, nrKnots);
                    nrKnots *= 2;
                    knot = tmp;
                }
                knot[nrK++] = v.getPosition();
                continue;
            }
            if (nrF++ == nrFaces) {
                tmp = new int[8 * nrFaces];
                System.arraycopy(vertex, 0, tmp, 0, nrV);
                nrFaces *= 2;
                vertex = tmp;
            }
            lastWasInvisible = true;
            int[] index = v.getReferences();
            k = 0;
            while (k < 4) {
                vertex[nrV++] = index[k];
                if (index[k] > 0) {
                    if (lastWasInvisible) {
                        lastWasInvisible = false;
                    }
                } else if (index[k] < 0) {
                    lastWasInvisible = true;
                } else {
                    nrV += 4 - k - 1;
                    continue block0;
                }
                ++k;
            }
        }
        if (nrK != nrKnots) {
            nrKnots = nrK;
        }
        if (nrF != nrFaces) {
            nrFaces = nrF;
        }
        DrawSet set = nrFaces > 0 ? new DrawSet(nrFaces) : null;
        DrawLines line = new DrawLines(1);
        nrF = 0;
        nrV = 0;
        while (nrF < nrFaces) {
            lastWasInvisible = true;
            k = 0;
            while (k < 4) {
                if (vertex[nrV + k] < -nrKnots || vertex[nrV + k] > nrKnots) break;
                if (vertex[nrV + k] > 0) {
                    if (lastWasInvisible) {
                        line = new DrawLines(4 - k + 1);
                        lastWasInvisible = false;
                    }
                    line.addPoint(knot[vertex[nrV + k] - 1]);
                } else if (vertex[nrV + k] < 0 && !lastWasInvisible) {
                    lastWasInvisible = true;
                    line.addPoint(knot[-vertex[nrV + k] - 1]);
                    set.addDrawable(line);
                }
                ++k;
            }
            if (!lastWasInvisible) {
                if (vertex[nrV] < 0) {
                    line.addPoint(knot[-vertex[nrV] - 1]);
                } else {
                    line.addPoint(knot[vertex[nrV] - 1]);
                }
                set.addDrawable(line);
            }
            ++nrF;
            nrV += 4;
        }
        return set;
    }

    private static DrawAble convertPolyLine(DxfPOLYLINE poly) {
        DrawLines line;
        boolean isSpline = (poly.getType() & 4) != 0;
        boolean isClosed = (poly.getType() & 1) != 0;
        boolean hasWidth = poly.hasLineWidth() && (poly.getType() & 8) == 0;
        DxfEntitySet vertices = poly.getVertices();
        if (isSpline) {
            if (hasWidth) {
                DrawLinesWithWidth wline = new DrawLinesWithWidth();
                Enumeration e = vertices.getEntities();
                while (e.hasMoreElements()) {
                    DxfVERTEX v = (DxfVERTEX)e.nextElement();
                    if ((v.getType() & 0x10) != 0) continue;
                    wline.addPoint(v.getPosition(), v.getStartWidth(), v.getEndWidth());
                }
                if (isClosed) {
                    wline.close();
                }
                line = wline;
            } else {
                line = new DrawLines();
                Enumeration e = vertices.getEntities();
                while (e.hasMoreElements()) {
                    DxfVERTEX v = (DxfVERTEX)e.nextElement();
                    if ((v.getType() & 0x10) != 0) continue;
                    line.addPoint(v.getPosition());
                }
            }
        } else {
            DxfVERTEX firstVertex = null;
            DxfVERTEX nextVertex = null;
            int nr = vertices.getNrOfEntities();
            DrawLines sline = hasWidth ? null : new DrawLines();
            DrawLinesWithWidth wline = hasWidth ? new DrawLinesWithWidth() : null;
            line = hasWidth ? wline : sline;
            Enumeration e = vertices.getEntities();
            while (nr-- > 0) {
                if (nextVertex == null) {
                    nextVertex = (DxfVERTEX)e.nextElement();
                }
                DxfVERTEX vertex = nextVertex;
                if (firstVertex == null) {
                    firstVertex = vertex;
                }
                nextVertex = !e.hasMoreElements() ? (isClosed ? firstVertex : null) : (DxfVERTEX)e.nextElement();
                if (vertex.getRounding() == 0.0f || nextVertex == null) {
                    if (hasWidth) {
                        wline.addPoint(vertex.getPosition(), vertex.getStartWidth(), vertex.getEndWidth());
                        continue;
                    }
                    sline.addPoint(vertex.getPosition());
                    continue;
                }
                float[] vec = new float[2];
                float[] mid = new float[2];
                Point3D thisPosition = vertex.getPosition();
                Point3D nextPosition = nextVertex.getPosition();
                float alpha = (float)(4.0 * Math.atan(vertex.getRounding()));
                vec[0] = nextPosition.x - thisPosition.x;
                vec[1] = nextPosition.y - thisPosition.y;
                float dist = (float)Math.sqrt(vec[0] * vec[0] + vec[1] * vec[1]);
                if (dist == 0.0f) continue;
                vec[0] = vec[0] / dist;
                vec[1] = vec[1] / dist;
                float radius = dist / (float)(2.0 * Math.sin(alpha / 2.0f));
                mid[0] = (thisPosition.x + nextPosition.x) / 2.0f - (radius - vertex.getRounding() * dist / 2.0f) * vec[1];
                mid[1] = (thisPosition.y + nextPosition.y) / 2.0f + (radius - vertex.getRounding() * dist / 2.0f) * vec[0];
                int segs = (int)Math.ceil((double)(36.0f * Math.abs(alpha)) / Math.PI / 2.0);
                float start = (float)Math.atan2(thisPosition.y - mid[1], thisPosition.x - mid[0]);
                alpha /= (float)segs;
                if (radius < 0.0f) {
                    radius = -radius;
                }
                if (hasWidth) {
                    if (segs <= 0) continue;
                    float width = vertex.getStartWidth();
                    float deltaWidth = (vertex.getEndWidth() - width) / (float)segs;
                    int j = 0;
                    while (j < segs) {
                        wline.addPoint(mid[0] + radius * (float)Math.cos(start), mid[1] + radius * (float)Math.sin(start), thisPosition.z, width, width + deltaWidth);
                        ++j;
                        start += alpha;
                        width += deltaWidth;
                    }
                    continue;
                }
                int j = 0;
                while (j < segs) {
                    sline.addPoint(mid[0] + radius * (float)Math.cos(start), mid[1] + radius * (float)Math.sin(start), thisPosition.z);
                    ++j;
                    start += alpha;
                }
            }
        }
        if (isClosed) {
            line.close();
        }
        DrawableConverter.setEntityInfo(line, poly);
        return line;
    }

    private static DrawAble convertPolyWeb(DxfPOLYLINE poly) {
        int n;
        int m;
        boolean isClosedN;
        DxfEntitySet vertices = poly.getVertices();
        Enumeration e = vertices.getEntities();
        if (!e.hasMoreElements()) {
            return null;
        }
        boolean isClosedM = (poly.getType() & 1) != 0;
        boolean bl = isClosedN = (poly.getType() & 0x20) != 0;
        if ((poly.getType() & 4) != 0) {
            m = poly.getNrApproxM();
            n = poly.getNrApproxN();
        } else {
            m = poly.getNrCtrlU();
            n = poly.getNrCtrlV();
        }
        int nrM = m + (isClosedM ? 1 : 0);
        int nrN = n + (isClosedN ? 1 : 0);
        DrawLines[] linesM = new DrawLines[nrN];
        int y = 0;
        while (y < nrN) {
            linesM[y] = new DrawLines(nrM);
            ++y;
        }
        DrawLines[] linesN = new DrawLines[nrM];
        int x = 0;
        while (x < nrM) {
            linesN[x] = new DrawLines(nrN);
            ++x;
        }
        DrawSet set = new DrawSet(nrM + nrN);
        x = 0;
        while (x < m) {
            y = 0;
            while (y < n) {
                DxfVERTEX vertex;
                while (((vertex = (DxfVERTEX)e.nextElement()).getType() & 0x10) != 0) {
                }
                linesM[y].addPoint(vertex.getPosition());
                linesN[x].addPoint(vertex.getPosition());
                ++y;
            }
            if (isClosedN) {
                linesN[x].close();
            }
            set.addDrawable(linesN[x]);
            ++x;
        }
        y = 0;
        while (y < n) {
            if (isClosedM) {
                linesM[y].close();
            }
            set.addDrawable(linesM[y]);
            ++y;
        }
        return set;
    }

    public void convert(DxfPOLYLINE poly, DxfFile dxf, Object collector) {
        if (poly.getTile()) {
            return;
        }
        int type = poly.getType();
        DrawAble ret = (type & 0x40) != 0 ? DrawableConverter.convertPolyMesh(poly) : ((type & 0x30) != 0 ? DrawableConverter.convertPolyWeb(poly) : DrawableConverter.convertPolyLine(poly));
        DrawableConverter.setEntityInfo(ret, poly);
        ((DrawSet)collector).addDrawable(DrawableConverter.finalConv(ret, poly, (type & 8) == 0));
    }

    public void convert(DxfSOLID solid, DxfFile dxf, Object collector) {
        if (solid.getTile()) {
            return;
        }
        Point3D[] corner = solid.getCorners();
        int maxp = 3;
        while (maxp >= 1) {
            if (corner[maxp].x != corner[maxp - 1].x || corner[maxp].y != corner[maxp - 1].y || corner[maxp].z != corner[maxp - 1].z) break;
            --maxp;
        }
        DrawPolygon poly = new DrawPolygon(maxp + 1);
        switch (maxp) {
            case 3: {
                poly.addPoint(corner[2]);
            }
            case 2: {
                poly.addPoint(corner[3]);
            }
            case 1: {
                poly.addPoint(corner[1]);
            }
            case 0: {
                poly.addPoint(corner[0]);
                break;
            }
        }
        DrawableConverter.setEntityInfo(poly, solid);
        ((DrawSet)collector).addDrawable(DrawableConverter.finalConv(poly, solid));
    }

    public void convert(DxfTEXT text, DxfFile dxf, Object collector) {
        block3: {
            if (text.getTile()) {
                return;
            }
            if (!this.fontsAvailable()) break block3;
            try {
                DrawText dtext = new DrawText(null, text, dxf, this);
                DrawableConverter.setEntityInfo(dtext, text);
                ((DrawSet)collector).addDrawable(DrawableConverter.finalConv(dtext, text));
            }
            catch (DxfException dxfException) {}
        }
    }

    public void convert(DxfATTRIB attrib, DxfFile dxf, Object collector) {
        switch (dxf.getHeader().getATTMODE()) {
            case 1: {
                if (!attrib.getVisibility()) break;
            }
            case 2: {
                this.convert((DxfTEXT)attrib, dxf, collector);
                break;
            }
        }
    }

    public void convert(DxfATTDEF attdef, DxfFile dxf, Object collector) {
        this.convert((DxfATTRIB)attdef, dxf, collector);
    }

    public void convert(DxfTRACE trace, DxfFile dxf, Object collector) {
        if (trace.getTile()) {
            return;
        }
        this.convert((DxfSOLID)trace, dxf, collector);
    }

    public void convert(DxfEntitySet set, DxfFile dxf, Object collector) {
        DrawSet drawset = new DrawSet(set.getNrOfEntities());
        Enumeration e = set.getEntities();
        while (e.hasMoreElements()) {
            ((DxfEntity)e.nextElement()).convert(this, dxf, (Object)drawset);
        }
        ((DrawSet)collector).addDrawable(drawset);
    }

    protected static DrawAble finalConv(DrawAble dl, DxfEntity entity, boolean doTransform) {
        DrawAble dr;
        if (dl == null) {
            return null;
        }
        if (doTransform) {
            dr = entity.getExtrusion() != 0.0f ? dl.extrude(entity.getExtrusion()) : dl;
            Matrix4D mat = entity.calcArbitMat();
            if (mat != null) {
                dr.transformBy(mat);
            }
        } else {
            dr = entity.getExtrusion() != 0.0f ? dl.extrude(entity.getExtrusion(), entity.getUpwardVector()) : dl;
        }
        return dr;
    }

    protected static DrawAble finalConv(DrawAble dl, DxfEntity entity) {
        return DrawableConverter.finalConv(dl, entity, true);
    }

    protected static void setEntityInfo(DrawAble d, DxfEntity entity) {
        if (d != null) {
            d.setLayer(entity.getLayer());
            d.setColor(entity.getColor());
            d.setLineTypeName(entity.getLtypeName());
        }
    }

    public DrawSet getModel() {
        return this.complete;
    }

    public DxfFont getFont(String fontName, DxfReporter reporter) throws DxfException {
        if (txtTested && txtFont == null) {
            throw new DxfException("err!Fonts");
        }
        String reducedName = fontName.endsWith("8") ? fontName.substring(0, fontName.length() - 1).toUpperCase() : fontName.toUpperCase();
        DxfFont font = (DxfFont)this.fontHash.get(reducedName);
        if (font == null) {
            InputStream input;
            if (DxfViewer.debugLevel > 10) {
                System.out.println("Looking for " + fontFileHead + reducedName + fontFileExt);
            }
            try {
                input = Utility.getInputStream(String.valueOf(fontFileHead) + reducedName + fontFileExt, this);
            }
            catch (SecurityException securityException) {
                return null;
            }
            if (DxfViewer.debugLevel > 10) {
                System.out.println(input == null ? "\tNot found!" : "\tFound");
            }
            if (input == null) {
                if (reporter != null) {
                    reporter.showWarningRes("warnNoFont", new String[]{fontName});
                }
                font = txtFont;
            } else {
                try {
                    font = new DxfFontFromStream(new BufferedInputStream(input));
                }
                catch (IOException iOException) {
                    if (reporter != null) {
                        reporter.showWarningRes("warnNoFontLoad", new String[]{fontName});
                    }
                    font = txtFont;
                }
            }
            if (font != null) {
                this.fontHash.put(reducedName, font);
            }
        }
        return font;
    }

    public boolean fontsAvailable() {
        return txtFont != null;
    }

    static {
        txtFont = null;
    }
}

