/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import processing.app.Base;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.debug.RunnerException;
import processing.core.PApplet;

public class Compiler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compile(Sketch sketch, String buildPath, String primaryClassName, String bootClassPath) throws RunnerException {
        RunnerException exception = null;
        boolean success = false;
        String[] baseCommand = new String[]{"-Xemacs", "-source", "1.5", "-target", "1.5", "-classpath", sketch.getClassPath(), "-nowarn", "-d", buildPath};
        String[] sourceFiles = new String[sketch.getCodeCount()];
        int sourceCount = 0;
        sourceFiles[sourceCount++] = new File(buildPath, primaryClassName + ".java").getAbsolutePath();
        for (SketchCode code : sketch.getCode()) {
            if (!code.isExtension("java")) continue;
            String path = new File(buildPath, code.getFileName()).getAbsolutePath();
            sourceFiles[sourceCount++] = path;
        }
        String[] command = new String[baseCommand.length + sourceCount];
        System.arraycopy(baseCommand, 0, command, 0, baseCommand.length);
        System.arraycopy(sourceFiles, 0, command, baseCommand.length, sourceCount);
        try {
            final StringBuffer errorBuffer = new StringBuffer();
            Writer internalWriter = new Writer(){

                public void write(char[] buf, int off, int len) {
                    errorBuffer.append(buf, off, len);
                }

                public void flush() {
                }

                public void close() {
                }
            };
            PrintWriter writer = new PrintWriter(internalWriter);
            CompilationProgress progress = null;
            PrintWriter outWriter = new PrintWriter(System.out);
            success = BatchCompiler.compile((String[])command, (PrintWriter)outWriter, (PrintWriter)writer, progress);
            writer.flush();
            writer.close();
            BufferedReader reader = new BufferedReader(new StringReader(errorBuffer.toString()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String what;
                String errorFormat = "([\\w\\d_]+.java):(\\d+):\\s*(.*):\\s*(.*)\\s*";
                String[] pieces = PApplet.match((String)line, (String)errorFormat);
                if (pieces == null) {
                    exception = new RunnerException("Cannot parse error text: " + line);
                    exception.hideStackTrace();
                    System.err.println(line);
                    while ((line = reader.readLine()) != null) {
                        System.err.println(line);
                    }
                    break;
                }
                String errorMessage = pieces[4];
                String dotJavaFilename = pieces[1];
                int dotJavaLineIndex = PApplet.parseInt((String)pieces[2]) - 1;
                exception = sketch.placeException(errorMessage, dotJavaFilename, dotJavaLineIndex);
                if (exception == null) {
                    exception = new RunnerException(errorMessage);
                }
                if (errorMessage.startsWith("The import ") && errorMessage.endsWith("cannot be resolved")) {
                    what = errorMessage.substring("The import ".length());
                    what = what.substring(0, what.indexOf(32));
                    System.err.println("Note that release 1.0, libraries must be installed in a folder named 'libraries' inside the 'sketchbook' folder.");
                    exception.setMessage("The package \u201c" + what + "\u201d" + " does not exist. " + "You might be missing a library.");
                    File sketchbookLibraries = Base.getSketchbookLibrariesFolder();
                    if (!sketchbookLibraries.exists() && sketchbookLibraries.mkdirs()) {
                        Base.openFolder(sketchbookLibraries);
                    }
                } else if (errorMessage.endsWith("cannot be resolved to a type")) {
                    what = errorMessage.substring(0, errorMessage.indexOf(32));
                    if (what.equals("BFont") || what.equals("BGraphics") || what.equals("BImage")) {
                        this.handleCrustyCode(exception);
                    } else {
                        exception.setMessage("Cannot find a class or type named \u201c" + what + "\u201d");
                    }
                } else if (errorMessage.endsWith("cannot be resolved")) {
                    what = errorMessage.substring(0, errorMessage.indexOf(32));
                    if (what.equals("LINE_LOOP") || what.equals("LINE_STRIP") || what.equals("framerate")) {
                        this.handleCrustyCode(exception);
                    } else {
                        exception.setMessage("Cannot find anything named \u201c" + what + "\u201d");
                    }
                } else if (!errorMessage.startsWith("Duplicate")) {
                    String[] parts = null;
                    String undefined = "The method (\\S+\\(.*\\)) is undefined for the type (.*)";
                    parts = PApplet.match((String)errorMessage, (String)undefined);
                    if (parts != null) {
                        if (parts[1].equals("framerate(int)") || parts[1].equals("push()")) {
                            this.handleCrustyCode(exception);
                        } else {
                            String mess = "The function " + parts[1] + " does not exist.";
                            exception.setMessage(mess);
                        }
                        break;
                    }
                }
                if (exception == null) continue;
                exception.hideStackTrace();
                break;
            }
        }
        catch (IOException e) {
            String bigSigh = "Error while compiling. (" + e.getMessage() + ")";
            exception = new RunnerException(bigSigh);
            e.printStackTrace();
            success = false;
        }
        if (exception != null) {
            throw exception;
        }
        return success;
    }

    void handleCrustyCode(RunnerException rex) {
        rex.setMessage("This code needs to be updated, please read the Changes page on the Wiki.");
        Base.showChanges();
    }

    protected int caretColumn(String caretLine) {
        return caretLine.indexOf("^");
    }

    public static String contentsToClassPath(File folder) {
        if (folder == null) {
            return "";
        }
        StringBuffer abuffer = new StringBuffer();
        String sep = System.getProperty("path.separator");
        try {
            String path = folder.getCanonicalPath();
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            String[] list = folder.list();
            for (int i = 0; i < list.length; ++i) {
                if (list[i].startsWith(".") || !list[i].toLowerCase().endsWith(".jar") && !list[i].toLowerCase().endsWith(".zip")) continue;
                abuffer.append(sep);
                abuffer.append(path);
                abuffer.append(list[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return abuffer.toString();
    }

    public static String[] packageListFromClassPath(String path) {
        Hashtable table = new Hashtable();
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        for (int i = 0; i < pieces.length; ++i) {
            if (pieces[i].length() == 0) continue;
            if (pieces[i].toLowerCase().endsWith(".jar") || pieces[i].toLowerCase().endsWith(".zip")) {
                Compiler.packageListFromZip(pieces[i], table);
                continue;
            }
            File dir = new File(pieces[i]);
            if (!dir.exists() || !dir.isDirectory()) continue;
            Compiler.packageListFromFolder(dir, null, table);
        }
        int tableCount = table.size();
        String[] output = new String[tableCount];
        int index = 0;
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            output[index++] = ((String)e.nextElement()).replace('/', '.');
        }
        return output;
    }

    private static void packageListFromZip(String filename, Hashtable table) {
        try {
            ZipFile file = new ZipFile(filename);
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                String pname;
                int slash;
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(".class") || (slash = name.lastIndexOf(47)) == -1 || table.get(pname = name.substring(0, slash)) != null) continue;
                table.put(pname, new Object());
            }
        }
        catch (IOException e) {
            System.err.println("Ignoring " + filename + " (" + e.getMessage() + ")");
        }
    }

    private static void packageListFromFolder(File dir, String sofar, Hashtable table) {
        boolean foundClass = false;
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(".") || files[i].equals("..")) continue;
            File sub = new File(dir, files[i]);
            if (sub.isDirectory()) {
                String nowfar = sofar == null ? files[i] : sofar + "." + files[i];
                Compiler.packageListFromFolder(sub, nowfar, table);
                continue;
            }
            if (foundClass || !files[i].endsWith(".class")) continue;
            table.put(sofar, new Object());
            foundClass = true;
        }
    }
}

