/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import processing.core.PApplet;
import processing.xml.StdXMLBuilder;
import processing.xml.StdXMLParser;
import processing.xml.StdXMLReader;
import processing.xml.XMLAttribute;
import processing.xml.XMLException;
import processing.xml.XMLValidator;
import processing.xml.XMLWriter;

public class XMLElement
implements Serializable {
    public static final int NO_LINE = -1;
    private PApplet sketch;
    private XMLElement parent;
    private Vector<XMLAttribute> attributes = new Vector();
    private Vector<XMLElement> children = new Vector(8);
    private String name;
    private String fullName;
    private String namespace;
    private String content;
    private String systemID;
    private int line;

    public XMLElement() {
        this(null, null, null, -1);
    }

    public XMLElement(String string) {
        this(string, null, null, -1);
    }

    public XMLElement(String string, String string2, String string3, int n) {
        int n2;
        this.fullName = string;
        this.name = string2 == null ? string : ((n2 = string.indexOf(58)) >= 0 ? string.substring(n2 + 1) : string);
        this.namespace = string2;
        this.content = null;
        this.line = n;
        this.systemID = string3;
        this.parent = null;
    }

    public XMLElement(PApplet pApplet, String string) {
        this();
        this.sketch = pApplet;
        this.init(pApplet.createReader(string));
    }

    public XMLElement(Reader reader) {
        this();
        this.init(reader);
    }

    public static XMLElement parse(String string) {
        return XMLElement.parse(new StringReader(string));
    }

    public static XMLElement parse(Reader reader) {
        try {
            StdXMLParser stdXMLParser = new StdXMLParser();
            stdXMLParser.setBuilder(new StdXMLBuilder());
            stdXMLParser.setValidator(new XMLValidator());
            stdXMLParser.setReader(new StdXMLReader(reader));
            return (XMLElement)stdXMLParser.parse();
        }
        catch (XMLException xMLException) {
            xMLException.printStackTrace();
            return null;
        }
    }

    protected void init(String string, String string2, String string3, int n) {
        int n2;
        this.fullName = string;
        this.name = string2 == null ? string : ((n2 = string.indexOf(58)) >= 0 ? string.substring(n2 + 1) : string);
        this.namespace = string2;
        this.line = n;
        this.systemID = string3;
    }

    protected void init(Reader reader) {
        try {
            StdXMLParser stdXMLParser = new StdXMLParser();
            stdXMLParser.setBuilder(new StdXMLBuilder(this));
            stdXMLParser.setValidator(new XMLValidator());
            stdXMLParser.setReader(new StdXMLReader(reader));
            stdXMLParser.parse();
        }
        catch (XMLException xMLException) {
            xMLException.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        this.attributes.clear();
        this.attributes = null;
        this.children = null;
        this.fullName = null;
        this.name = null;
        this.namespace = null;
        this.content = null;
        this.systemID = null;
        this.parent = null;
        super.finalize();
    }

    public XMLElement getParent() {
        return this.parent;
    }

    public String getName() {
        return this.fullName;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setName(String string) {
        this.name = string;
        this.fullName = string;
        this.namespace = null;
    }

    public void setName(String string, String string2) {
        int n = string.indexOf(58);
        this.name = string2 == null || n < 0 ? string : string.substring(n + 1);
        this.fullName = string;
        this.namespace = string2;
    }

    public void addChild(XMLElement xMLElement) {
        XMLElement xMLElement2;
        if (xMLElement == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (xMLElement.getLocalName() == null && !this.children.isEmpty() && (xMLElement2 = this.children.lastElement()).getLocalName() == null) {
            xMLElement2.setContent(xMLElement2.getContent() + xMLElement.getContent());
            return;
        }
        xMLElement.parent = this;
        this.children.addElement(xMLElement);
    }

    public void insertChild(XMLElement xMLElement, int n) {
        XMLElement xMLElement2;
        if (xMLElement == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (xMLElement.getLocalName() == null && !this.children.isEmpty() && (xMLElement2 = this.children.lastElement()).getLocalName() == null) {
            xMLElement2.setContent(xMLElement2.getContent() + xMLElement.getContent());
            return;
        }
        xMLElement.parent = this;
        this.children.insertElementAt(xMLElement, n);
    }

    public void removeChild(XMLElement xMLElement) {
        if (xMLElement == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        this.children.removeElement(xMLElement);
    }

    public void removeChild(int n) {
        this.children.removeElementAt(n);
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public String[] listChildren() {
        int n = this.getChildCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getChild(i).getName();
        }
        return stringArray;
    }

    public XMLElement[] getChildren() {
        int n = this.getChildCount();
        Object[] objectArray = new XMLElement[n];
        this.children.copyInto(objectArray);
        return objectArray;
    }

    public XMLElement getChild(int n) {
        return this.children.elementAt(n);
    }

    public XMLElement getChild(String string) {
        if (string.indexOf(47) != -1) {
            return this.getChildRecursive(PApplet.split(string, '/'), 0);
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement = this.getChild(i);
            String string2 = xMLElement.getName();
            if (string2 == null || !string2.equals(string)) continue;
            return xMLElement;
        }
        return null;
    }

    protected XMLElement getChildRecursive(String[] stringArray, int n) {
        if (Character.isDigit(stringArray[n].charAt(0))) {
            XMLElement xMLElement = this.getChild(Integer.parseInt(stringArray[n]));
            if (n == stringArray.length - 1) {
                return xMLElement;
            }
            return xMLElement.getChildRecursive(stringArray, n + 1);
        }
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            XMLElement xMLElement = this.getChild(i);
            String string = xMLElement.getName();
            if (string == null || !string.equals(stringArray[n])) continue;
            if (n == stringArray.length - 1) {
                return xMLElement;
            }
            return xMLElement.getChildRecursive(stringArray, n + 1);
        }
        return null;
    }

    public XMLElement[] getChildren(String string) {
        if (string.indexOf(47) != -1) {
            return this.getChildrenRecursive(PApplet.split(string, '/'), 0);
        }
        if (Character.isDigit(string.charAt(0))) {
            return new XMLElement[]{this.getChild(Integer.parseInt(string))};
        }
        int n = this.getChildCount();
        XMLElement[] xMLElementArray = new XMLElement[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement = this.getChild(i);
            String string2 = xMLElement.getName();
            if (string2 == null || !string2.equals(string)) continue;
            xMLElementArray[n2++] = xMLElement;
        }
        return (XMLElement[])PApplet.subset(xMLElementArray, 0, n2);
    }

    protected XMLElement[] getChildrenRecursive(String[] stringArray, int n) {
        if (n == stringArray.length - 1) {
            return this.getChildren(stringArray[n]);
        }
        XMLElement[] xMLElementArray = this.getChildren(stringArray[n]);
        XMLElement[] xMLElementArray2 = new XMLElement[]{};
        for (int i = 0; i < xMLElementArray.length; ++i) {
            XMLElement[] xMLElementArray3 = xMLElementArray[i].getChildrenRecursive(stringArray, n + 1);
            xMLElementArray2 = (XMLElement[])PApplet.concat(xMLElementArray2, xMLElementArray3);
        }
        return xMLElementArray2;
    }

    private XMLAttribute findAttribute(String string) {
        Enumeration<XMLAttribute> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute xMLAttribute = enumeration.nextElement();
            if (!xMLAttribute.getName().equals(string)) continue;
            return xMLAttribute;
        }
        return null;
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String[] listAttributes() {
        String[] stringArray = new String[this.attributes.size()];
        for (int i = 0; i < this.attributes.size(); ++i) {
            stringArray[i] = this.attributes.get(i).getName();
        }
        return stringArray;
    }

    public String getStringAttribute(String string) {
        return this.getString(string);
    }

    public String getStringAttribute(String string, String string2) {
        return this.getString(string, string2);
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public String getString(String string, String string2) {
        XMLAttribute xMLAttribute = this.findAttribute(string);
        if (xMLAttribute == null) {
            return string2;
        }
        return xMLAttribute.getValue();
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.getString(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equals("1") || string2.toLowerCase().equals("true");
    }

    public int getIntAttribute(String string) {
        return this.getInt(string, 0);
    }

    public int getIntAttribute(String string, int n) {
        return this.getInt(string, n);
    }

    public int getInt(String string) {
        return this.getInt(string, 0);
    }

    public int getInt(String string, int n) {
        String string2 = this.getString(string);
        return string2 == null ? n : PApplet.parseInt(string2, n);
    }

    public float getFloatAttribute(String string) {
        return this.getFloat(string, 0.0f);
    }

    public float getFloatAttribute(String string, float f) {
        return this.getFloat(string, 0.0f);
    }

    public float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    public float getFloat(String string, float f) {
        String string2 = this.getString(string);
        if (string2 == null) {
            return f;
        }
        return PApplet.parseFloat(string2, f);
    }

    public double getDouble(String string) {
        return this.getDouble(string, 0.0);
    }

    public double getDouble(String string, double d) {
        String string2 = this.getString(string);
        return string2 == null ? d : Double.parseDouble(string2);
    }

    public void setString(String string, String string2) {
        XMLAttribute xMLAttribute = this.findAttribute(string);
        if (xMLAttribute == null) {
            xMLAttribute = new XMLAttribute(string, string, null, string2, "CDATA");
            this.attributes.addElement(xMLAttribute);
        } else {
            xMLAttribute.setValue(string2);
        }
    }

    public void setBoolean(String string, boolean bl) {
        this.setString(string, String.valueOf(bl));
    }

    public void setInt(String string, int n) {
        this.setString(string, String.valueOf(n));
    }

    public void setFloat(String string, float f) {
        this.setString(string, String.valueOf(f));
    }

    public void setDouble(String string, double d) {
        this.setString(string, String.valueOf(d));
    }

    public void remove(String string) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            XMLAttribute xMLAttribute = this.attributes.elementAt(i);
            if (!xMLAttribute.getName().equals(string)) continue;
            this.attributes.removeElementAt(i);
            return;
        }
    }

    public boolean hasAttribute(String string) {
        return this.findAttribute(string) != null;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public int getLine() {
        return this.line;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public boolean equals(Object object) {
        Object object2;
        if (!(object instanceof XMLElement)) {
            return false;
        }
        XMLElement xMLElement = (XMLElement)object;
        if (!this.name.equals(xMLElement.getLocalName())) {
            return false;
        }
        if (this.attributes.size() != xMLElement.getAttributeCount()) {
            return false;
        }
        Enumeration<XMLAttribute> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute xMLAttribute = enumeration.nextElement();
            if (!xMLElement.hasAttribute(xMLAttribute.getName())) {
                return false;
            }
            object2 = xMLElement.getString(xMLAttribute.getName(), null);
            if (xMLAttribute.getValue().equals(object2)) continue;
            return false;
        }
        if (this.children.size() != xMLElement.getChildCount()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            XMLElement xMLElement2;
            object2 = this.getChild(i);
            if (((XMLElement)object2).equals(xMLElement2 = xMLElement.getChild(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        XMLWriter xMLWriter = new XMLWriter(outputStreamWriter);
        try {
            xMLWriter.write(this, bl);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toString();
    }

    private PApplet findSketch() {
        if (this.sketch != null) {
            return this.sketch;
        }
        if (this.parent != null) {
            return this.parent.findSketch();
        }
        return null;
    }

    public boolean save(String string) {
        if (this.sketch == null) {
            this.sketch = this.findSketch();
        }
        if (this.sketch == null) {
            System.err.println("save() can only be used on elements loaded by a sketch");
            throw new RuntimeException("no sketch found, use write(PrintWriter) instead.");
        }
        return this.write(this.sketch.createWriter(string));
    }

    public boolean write(PrintWriter printWriter) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        XMLWriter xMLWriter = new XMLWriter(printWriter);
        try {
            xMLWriter.write(this, true);
            printWriter.flush();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }
}

