/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Appendable;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.ResourceDecorator;
import org.apache.tools.ant.util.FileUtils;

public abstract class ContentTransformingResource
extends ResourceDecorator {
    private static final int BUFFER_SIZE = 8192;

    protected ContentTransformingResource() {
    }

    protected ContentTransformingResource(ResourceCollection other) {
        super(other);
    }

    public long getSize() {
        if (this.isExists()) {
            InputStream in = null;
            try {
                int readNow;
                in = this.getInputStream();
                byte[] buf = new byte[8192];
                int size = 0;
                while ((readNow = in.read(buf, 0, buf.length)) > 0) {
                    size += readNow;
                }
                long l = size;
                return l;
            }
            catch (IOException ex) {
                throw new BuildException("caught exception while reading " + this.getName(), ex);
            }
            finally {
                FileUtils.close(in);
            }
        }
        return 0L;
    }

    public InputStream getInputStream() throws IOException {
        InputStream in = this.getResource().getInputStream();
        if (in != null) {
            in = this.wrapStream(in);
        }
        return in;
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream out = this.getResource().getOutputStream();
        if (out != null) {
            out = this.wrapStream(out);
        }
        return out;
    }

    public Object as(Class clazz) {
        if (Appendable.class.isAssignableFrom(clazz)) {
            Appendable a;
            if (this.isAppendSupported() && (a = (Appendable)this.getResource().as(Appendable.class)) != null) {
                return new Appendable(){

                    public OutputStream getAppendOutputStream() throws IOException {
                        OutputStream out = a.getAppendOutputStream();
                        if (out != null) {
                            out = ContentTransformingResource.this.wrapStream(out);
                        }
                        return out;
                    }
                };
            }
            return null;
        }
        return FileProvider.class.isAssignableFrom(clazz) ? null : this.getResource().as(clazz);
    }

    protected boolean isAppendSupported() {
        return false;
    }

    protected abstract InputStream wrapStream(InputStream var1) throws IOException;

    protected abstract OutputStream wrapStream(OutputStream var1) throws IOException;
}

