/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u | (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(4294967229u, 4294967223u, 4294967208u, 4294967220u)
 * (0u | (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(4294967271u, 4294967255u, 4294967272u, 4294967221u)
 * (6u | (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(4294967231u, 4294967223u, 4294967214u, 4294967222u)
 * (6u | (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(4294967271u, 4294967255u, 4294967278u, 4294967223u)
 * (12u | (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(4294967229u, 4294967231u, 4294967212u, 4294967228u)
 * (12u | (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(4294967279u, 4294967263u, 4294967276u, 4294967229u)
 * (32u | (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(4294967229u, 4294967223u, 4294967208u, 4294967220u)
 * (32u | (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(4294967271u, 4294967287u, 4294967272u, 4294967221u)
 * (74u | (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(4294967295u, 4294967295u, 4294967274u, 4294967294u)
 * (74u | (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(4294967279u, 4294967263u, 4294967274u, 4294967295u)
 */
#version 150

void main()
{
  float[all(equal((0u | (~ uvec4(66u, 72u, 87u, 75u))), uvec4(4294967229u, 4294967223u, 4294967208u, 4294967220u))) ? 1 : -1] array0;
  float[all(equal((0u | (~ uvec4(24u, 40u, 23u, 74u))), uvec4(4294967271u, 4294967255u, 4294967272u, 4294967221u))) ? 1 : -1] array1;
  float[all(equal((6u | (~ uvec4(66u, 72u, 87u, 75u))), uvec4(4294967231u, 4294967223u, 4294967214u, 4294967222u))) ? 1 : -1] array2;
  float[all(equal((6u | (~ uvec4(24u, 40u, 23u, 74u))), uvec4(4294967271u, 4294967255u, 4294967278u, 4294967223u))) ? 1 : -1] array3;
  float[all(equal((12u | (~ uvec4(66u, 72u, 87u, 75u))), uvec4(4294967229u, 4294967231u, 4294967212u, 4294967228u))) ? 1 : -1] array4;
  float[all(equal((12u | (~ uvec4(24u, 40u, 23u, 74u))), uvec4(4294967279u, 4294967263u, 4294967276u, 4294967229u))) ? 1 : -1] array5;
  float[all(equal((32u | (~ uvec4(66u, 72u, 87u, 75u))), uvec4(4294967229u, 4294967223u, 4294967208u, 4294967220u))) ? 1 : -1] array6;
  float[all(equal((32u | (~ uvec4(24u, 40u, 23u, 74u))), uvec4(4294967271u, 4294967287u, 4294967272u, 4294967221u))) ? 1 : -1] array7;
  float[all(equal((74u | (~ uvec4(66u, 72u, 87u, 75u))), uvec4(4294967295u, 4294967295u, 4294967274u, 4294967294u))) ? 1 : -1] array8;
  float[all(equal((74u | (~ uvec4(24u, 40u, 23u, 74u))), uvec4(4294967279u, 4294967263u, 4294967274u, 4294967295u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
