/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * notEqual(vec4(-1.5, -1.5, -1.5, -1.5), vec4(-1.5, -0.5, 0.5, 1.5)) => bvec4(false, true, true, true)
 * notEqual(vec4(-0.5, -0.5, -0.5, -0.5), vec4(-1.5, -0.5, 0.5, 1.5)) => bvec4(true, false, true, true)
 * notEqual(vec4(0.5, 0.5, 0.5, 0.5), vec4(-1.5, -0.5, 0.5, 1.5)) => bvec4(true, true, false, true)
 * notEqual(vec4(1.5, 1.5, 1.5, 1.5), vec4(-1.5, -0.5, 0.5, 1.5)) => bvec4(true, true, true, false)
 */
#version 120

void main()
{
  float[all(equal(notEqual(vec4(-1.5, -1.5, -1.5, -1.5), vec4(-1.5, -0.5, 0.5, 1.5)), bvec4(false, true, true, true))) ? 1 : -1] array0;
  float[all(equal(notEqual(vec4(-0.5, -0.5, -0.5, -0.5), vec4(-1.5, -0.5, 0.5, 1.5)), bvec4(true, false, true, true))) ? 1 : -1] array1;
  float[all(equal(notEqual(vec4(0.5, 0.5, 0.5, 0.5), vec4(-1.5, -0.5, 0.5, 1.5)), bvec4(true, true, false, true))) ? 1 : -1] array2;
  float[all(equal(notEqual(vec4(1.5, 1.5, 1.5, 1.5), vec4(-1.5, -0.5, 0.5, 1.5)), bvec4(true, true, true, false))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
