/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec2(-0.1lf, -1.2lf) / -1.3333333333333333lf) => dvec2(0.07500000000000001lf, 0.9lf)
 * (dvec2(-0.1lf, -1.2lf) / 0.85lf) => dvec2(-0.11764705882352942lf, -1.411764705882353lf)
 * (dvec2(-0.42lf, 0.48lf) / -1.3333333333333333lf) => dvec2(0.315lf, -0.36lf)
 * (dvec2(-0.42lf, 0.48lf) / 0.85lf) => dvec2(-0.49411764705882355lf, 0.5647058823529412lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec2(-0.1lf, -1.2lf) / -1.3333333333333333lf), dvec2(0.07500000000000001lf, 0.9lf)) <= 9.031195934094223e-06lf ? 1 : -1] array0;
  double[distance((dvec2(-0.1lf, -1.2lf) / 0.85lf), dvec2(-0.11764705882352942lf, -1.411764705882353lf)) <= 1.4166581857402703e-05lf ? 1 : -1] array1;
  double[distance((dvec2(-0.42lf, 0.48lf) / -1.3333333333333333lf), dvec2(0.315lf, -0.36lf)) <= 4.783565615730593e-06lf ? 1 : -1] array2;
  double[distance((dvec2(-0.42lf, 0.48lf) / 0.85lf), dvec2(-0.49411764705882355lf, 0.5647058823529412lf)) <= 7.50363233840093e-06lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
