/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.Visibility;
import org.openhab.core.automation.template.Template;
import org.openhab.core.config.core.ConfigDescriptionParameter;

@NonNullByDefault
public class RuleTemplate
implements Template {
    private final String uid;
    private final List<Trigger> triggers;
    private final List<Condition> conditions;
    private final List<Action> actions;
    private final Set<String> tags;
    private final @Nullable String label;
    private final @Nullable String description;
    private final Visibility visibility;
    private final List<ConfigDescriptionParameter> configDescriptions;

    public RuleTemplate(@Nullable String uid, @Nullable String label, @Nullable String description, @Nullable Set<String> tags, @Nullable List<Trigger> triggers, @Nullable List<Condition> conditions, @Nullable List<Action> actions, @Nullable List<ConfigDescriptionParameter> configDescriptions, @Nullable Visibility visibility) {
        this.uid = uid == null ? UUID.randomUUID().toString() : uid;
        this.label = label;
        this.description = description;
        this.triggers = triggers == null ? List.of() : Collections.unmodifiableList(triggers);
        this.conditions = conditions == null ? List.of() : Collections.unmodifiableList(conditions);
        this.actions = actions == null ? List.of() : Collections.unmodifiableList(actions);
        this.configDescriptions = configDescriptions == null ? List.of() : Collections.unmodifiableList(configDescriptions);
        this.visibility = visibility == null ? Visibility.VISIBLE : visibility;
        this.tags = tags == null ? Set.of() : Collections.unmodifiableSet(tags);
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public @Nullable String getLabel() {
        return this.label;
    }

    @Override
    public @Nullable String getDescription() {
        return this.description;
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    public List<ConfigDescriptionParameter> getConfigurationDescriptions() {
        return this.configDescriptions;
    }

    public @Nullable Module getModule(String moduleId) {
        for (Module module : this.getModules(Module.class)) {
            if (!module.getId().equals(moduleId)) continue;
            return module;
        }
        return null;
    }

    public <T extends Module> List<T> getModules(Class<T> moduleClazz) {
        List<Module> result;
        if (Module.class == moduleClazz) {
            ArrayList<Module> modules = new ArrayList<Module>();
            modules.addAll(this.triggers);
            modules.addAll(this.conditions);
            modules.addAll(this.actions);
            result = Collections.unmodifiableList(modules);
        } else {
            result = Trigger.class == moduleClazz ? this.triggers : (Condition.class == moduleClazz ? this.conditions : (Action.class == moduleClazz ? this.actions : List.of()));
        }
        return result;
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.uid.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleTemplate)) {
            return false;
        }
        RuleTemplate other = (RuleTemplate)obj;
        return this.uid.equals(other.uid);
    }
}

