/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.parser.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.internal.parser.gson.ActionInstanceCreator;
import org.openhab.core.automation.internal.parser.gson.ConditionInstanceCreator;
import org.openhab.core.automation.internal.parser.gson.TriggerInstanceCreator;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.type.CompositeActionType;
import org.openhab.core.automation.type.CompositeConditionType;
import org.openhab.core.automation.type.CompositeTriggerType;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.config.core.ConfigurationDeserializer;
import org.openhab.core.config.core.ConfigurationSerializer;
import org.openhab.core.config.core.OrderingMapSerializer;
import org.openhab.core.config.core.OrderingSetSerializer;

@NonNullByDefault
public abstract class AbstractGSONParser<T>
implements Parser<T> {
    protected static Gson gson = new GsonBuilder().setDateFormat("MMM d, yyyy, h:mm:ss aaa").registerTypeAdapter(CompositeActionType.class, (Object)new ActionInstanceCreator()).registerTypeAdapter(CompositeConditionType.class, (Object)new ConditionInstanceCreator()).registerTypeAdapter(CompositeTriggerType.class, (Object)new TriggerInstanceCreator()).registerTypeAdapter(Configuration.class, (Object)new ConfigurationDeserializer()).registerTypeAdapter(Configuration.class, (Object)new ConfigurationSerializer()).registerTypeHierarchyAdapter(Map.class, (Object)new OrderingMapSerializer()).registerTypeHierarchyAdapter(Set.class, (Object)new OrderingSetSerializer()).create();

    @Override
    public void serialize(Set<T> dataObjects, OutputStreamWriter writer) throws Exception {
        gson.toJson(dataObjects, (Appendable)writer);
    }
}

