/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal.security;

import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.EnvironmentStringPBEConfig;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.ops4j.util.property.PropertyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurePropertyResolver
implements PropertyResolver {
    public static final Logger LOG = LoggerFactory.getLogger(SecurePropertyResolver.class);
    private String prefix;
    private String suffix;
    private final PropertyResolver delegate;
    private final StringEncryptor encryptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurePropertyResolver(PropertyResolver delegate) {
        String algorithm;
        String provider;
        this.delegate = delegate;
        this.prefix = delegate.get("org.ops4j.pax.web.enc.prefix");
        if (this.prefix == null || "".equals(this.prefix)) {
            this.prefix = "ENC(";
        }
        this.suffix = delegate.get("org.ops4j.pax.web.enc.suffix");
        if (this.suffix == null || "".equals(this.suffix)) {
            this.suffix = ")";
        }
        if ("SunJCE".equals(provider = delegate.get("org.ops4j.pax.web.enc.provider"))) {
            provider = null;
        }
        if ((algorithm = delegate.get("org.ops4j.pax.web.enc.algorithm")) == null || "".equals(algorithm.trim())) {
            algorithm = "PBEWithHmacSHA256AndAES_128";
        }
        String ic = delegate.get("org.ops4j.pax.web.enc.iterationcount");
        String ep = delegate.get("org.ops4j.pax.web.enc.masterpassword.env.variable");
        String sp = delegate.get("org.ops4j.pax.web.enc.masterpassword.sys.property");
        String mp = delegate.get("org.ops4j.pax.web.enc.masterpassword");
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        EnvironmentStringPBEConfig config = new EnvironmentStringPBEConfig();
        config.setAlgorithm(algorithm);
        if (provider != null) {
            config.setProviderName(provider);
        }
        if (ic != null && !"".equals(ic)) {
            try {
                Integer icv = Integer.parseInt(ic);
                config.setKeyObtentionIterations(icv);
            }
            catch (NumberFormatException e) {
                LOG.warn("Illegal value for iteration count ({}), setting the value to 1000", (Object)ic);
                config.setKeyObtentionIterations(Integer.valueOf(1000));
            }
        } else {
            config.setKeyObtentionIterations(Integer.valueOf(1000));
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(StringEncryptor.class.getClassLoader());
            config.setSaltGeneratorClassName("org.jasypt.salt.RandomSaltGenerator");
            config.setIvGeneratorClassName("org.jasypt.iv.RandomIvGenerator");
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        config.setStringOutputType("base64");
        if (ep != null && !"".equals(ep)) {
            config.setPasswordEnvName(ep);
        } else if (sp != null && !"".equals(sp)) {
            config.setPasswordSysPropertyName(sp);
        } else if (mp != null && !"".equals(mp)) {
            config.setPasswordCharArray(mp.toCharArray());
        }
        encryptor.setConfig((PBEConfig)config);
        this.encryptor = encryptor;
    }

    public SecurePropertyResolver(PropertyResolver resolver, StringEncryptor encryptor) {
        this.delegate = resolver;
        this.encryptor = encryptor;
        this.prefix = this.delegate.get("org.ops4j.pax.web.enc.prefix");
        if (this.prefix == null || "".equals(this.prefix)) {
            this.prefix = "ENC(";
        }
        this.suffix = this.delegate.get("org.ops4j.pax.web.enc.suffix");
        if (this.suffix == null || "".equals(this.suffix)) {
            this.suffix = ")";
        }
    }

    public static PropertyResolver wrap(PropertyResolver resolver) {
        return new SecurePropertyResolver(resolver);
    }

    public static PropertyResolver wrap(PropertyResolver resolver, Object encryptor) {
        if (!StringEncryptor.class.isAssignableFrom(encryptor.getClass())) {
            throw new IllegalArgumentException("Can't use " + encryptor + " - it is not an instance of org.jasypt.encryption.StringEncryptor");
        }
        return new SecurePropertyResolver(resolver, (StringEncryptor)encryptor);
    }

    @Override
    public String get(String property) {
        if (property.startsWith("org.ops4j.pax.web.enc.")) {
            return this.delegate.get(property);
        }
        String value = this.delegate.get(property);
        if (value == null) {
            return null;
        }
        if (value.startsWith(this.prefix) && value.endsWith(this.suffix)) {
            return this.encryptor.decrypt(value.substring(this.prefix.length(), value.length() - this.suffix.length()));
        }
        return value;
    }
}

