/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.util.collections;

import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;

public final class PropertyResolver {
    private PropertyResolver() {
    }

    public static String resolve(Properties props, String value) {
        if (value == null) {
            return null;
        }
        if (value.indexOf(36) < 0) {
            return value;
        }
        int pos1 = value.indexOf("${");
        if (pos1 < 0) {
            return value;
        }
        Stack<String> stack = new Stack<String>();
        StringTokenizer st = new StringTokenizer(value, "${}", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            PropertyResolver.processToken(token, stack, props);
        }
        String result = "";
        while (stack.size() > 0) {
            result = stack.pop() + result;
        }
        return result;
    }

    private static void processToken(String token, Stack<String> stack, Properties props) {
        if ("}".equals(token)) {
            String name = stack.pop();
            String open = stack.pop();
            if ("${".equals(open)) {
                PropertyResolver.startProperty(name, props, stack);
            } else {
                PropertyResolver.push(stack, "${" + name + "}");
            }
        } else if ("$".equals(token)) {
            stack.push("$");
        } else {
            PropertyResolver.push(stack, token);
        }
    }

    private static void startProperty(String name, Properties props, Stack<String> stack) {
        String propValue = System.getProperty(name);
        if (propValue == null) {
            propValue = props.getProperty(name);
        }
        if (propValue == null) {
            PropertyResolver.push(stack, "${" + name + "}");
        } else {
            PropertyResolver.push(stack, propValue);
        }
    }

    private static void push(Stack<String> stack, String value) {
        if (stack.size() > 0) {
            String data = stack.pop();
            if ("${".equals(data)) {
                stack.push(data);
                stack.push(value);
            } else {
                stack.push(data + value);
            }
        } else {
            stack.push(value);
        }
    }
}

