/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.service.progress;

import aQute.bnd.service.progress.ProgressPlugin;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class TaskManager {
    static final ThreadLocal<ProgressPlugin.Task> tasks = new ThreadLocal();
    static final AtomicBoolean shutdown = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T with(ProgressPlugin.Task task, Callable<T> callable) throws Exception {
        ProgressPlugin.Task prev = tasks.get();
        tasks.set(task);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            tasks.set(prev);
        }
    }

    public static boolean isCanceled() {
        if (shutdown.get()) {
            return true;
        }
        ProgressPlugin.Task task = tasks.get();
        if (task != null) {
            return task.isCanceled();
        }
        return false;
    }

    public static void cancel() {
        ProgressPlugin.Task task = tasks.get();
        if (task != null) {
            task.abort();
        }
    }

    public static void shtutdown() {
        shutdown.set(true);
    }

    public Optional<ProgressPlugin.Task> getTask() {
        return Optional.ofNullable(tasks.get());
    }
}

