/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.aspectj.plugin;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.JarResource;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.WriteResource;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.Strategy;
import aQute.bnd.service.export.Exporter;
import aQute.bnd.version.Version;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.libg.command.Command;
import aQute.libg.glob.Glob;
import aQute.libg.tuple.Pair;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BndPlugin(hide=false, name="AspectJ")
public class AspectJ
implements Exporter {
    private static Logger log = LoggerFactory.getLogger(AspectJ.class);
    private static Pattern AJC_WARNING_P = Pattern.compile("^(.*) \\[warning\\] (.*)$", 8);
    private static Pattern AJC_ERROR_P = Pattern.compile("^(.*) \\[error\\] (.*)$", 8);
    private static final String TYPE = "bnd.executablejar.aspectj";
    private static final String ORG_ASPECTJ_ASPECTJTOOLS = "org.aspectj:aspectjtools";
    private static final String ORG_ASPECTJ_ASPECTJRT = "org.aspectj:aspectjrt";

    @Override
    public String[] getTypes() {
        return new String[]{TYPE};
    }

    @Override
    public Map.Entry<String, Resource> export(String type, Project project, Map<String, String> options) throws Exception {
        File ab;
        Workspace workspace = project.getWorkspace();
        ArrayList<Jar> closeable = new ArrayList<Jar>();
        ArrayList<File> aspectpath = new ArrayList<File>();
        ArrayList<File> extraBundles = new ArrayList<File>();
        Glob match = new Glob(options.getOrDefault("match", "*"));
        Pair<File, Version> acj = this.get(workspace, ORG_ASPECTJ_ASPECTJTOOLS);
        if (acj == null) {
            project.error("export %s, no %s in repo", project, ORG_ASPECTJ_ASPECTJTOOLS);
            return null;
        }
        Pair<File, Version> aspectjrt = this.get(workspace, ORG_ASPECTJ_ASPECTJRT);
        if (aspectjrt == null) {
            project.error("export %s, no %s in repo", project, ORG_ASPECTJ_ASPECTJRT);
            return null;
        }
        Map.Entry<String, Resource> entry = project.export("bnd.executablejar.pack", options);
        File tmp = Files.createTempDirectory(entry.getKey(), new FileAttribute[0]).toFile();
        File output = IO.getFile(project.getTarget(), "aspect-" + entry.getKey());
        File aspectjrtBundle = this.wrap(project, new File(tmp, "biz.aQute.aspectjrt.jar"), aspectjrt);
        if (aspectjrtBundle == null) {
            return null;
        }
        aspectpath.add(aspectjrt.getFirst());
        extraBundles.add(aspectjrtBundle);
        ArrayList<File> cp = new ArrayList<File>();
        cp.add(aspectjrt.getFirst());
        cp.add(acj.getFirst());
        String aspectPathString = options.getOrDefault("aspectpath", "");
        List<Container> aspectBundles = project.getBundles(Strategy.HIGHEST, aspectPathString, null);
        for (Container c2 : Container.flatten(aspectBundles)) {
            if (c2.isOk()) {
                aspectpath.add(c2.getFile());
                ab = new File(tmp, c2.getFile().getName());
                String result = this.ajc(project, cp, c2.getFile(), Collections.emptyList(), Collections.singletonList(c2.getFile()), ab, options, false);
                if (result != null) {
                    project.error("export: %s", result);
                    continue;
                }
                extraBundles.add(ab);
                continue;
            }
            project.error("export, dependency error %s", c2);
        }
        try (Jar jar = new Jar(entry.getKey(), entry.getValue().openInputStream());){
            Resource properties = jar.getResource("launcher.properties");
            if (properties == null) {
                project.error("export %s, no launcher.properties found", project);
                ab = null;
                return ab;
            }
            UTF8Properties launchProperties = new UTF8Properties();
            launchProperties.load(properties.openInputStream());
            String bundles = launchProperties.getProperty("launch.bundles");
            if (bundles == null) {
                project.error("export: no 'launch.bundles' found in launch.properties: ", launchProperties);
                Map.Entry<String, Resource> entry2 = null;
                return entry2;
            }
            Parameters updated = new Parameters(bundles);
            List<String> toWeave = updated.keyList();
            for (File ap : extraBundles) {
                String path = "jar/" + ap.getName();
                jar.putResource(path, new FileResource(ap));
                updated.put(path, new Attrs());
            }
            launchProperties.setProperty("launch.bundles", updated.toString());
            jar.putResource("launcher.properties", this.propertiesResource(properties, launchProperties));
            for (String path : toWeave) {
                Manifest manifest;
                String simple = this.simple(path);
                if (match.finds(simple) < 0) continue;
                Resource resource = jar.getResource(path);
                if (resource == null) {
                    project.error("export: bundle in 'launch.bundles' but not in jar ", path);
                    continue;
                }
                File inpath = IO.getFile(tmp, path);
                inpath.getParentFile().mkdirs();
                IO.copy(resource.openInputStream(), inpath);
                HashSet<String> resources = new HashSet<String>();
                try (Jar in = new Jar(inpath);){
                    manifest = in.getManifest();
                    resources.addAll(in.getResources().keySet());
                }
                File outpath = IO.getFile(tmp, path + ".tmp");
                outpath.getParentFile().mkdirs();
                String result = this.ajc(project, cp, inpath, Collections.emptyList(), aspectpath, outpath, options, true);
                if (result != null) {
                    project.error("export: %s", result);
                    continue;
                }
                Jar bundle = new Jar(outpath);
                bundle.getResources().keySet().retainAll(resources);
                manifest.getMainAttributes().putValue("DynamicImport-Package", "*");
                bundle.setManifest(manifest);
                resource = new JarResource(bundle);
                jar.putResource(path, resource);
                closeable.add(bundle);
            }
            if (project.isOk()) {
                jar.write(output);
            }
        }
        closeable.forEach(c -> IO.close(c));
        IO.delete(tmp);
        if (project.isOk()) {
            FileResource result = new FileResource(output);
            return new AbstractMap.SimpleEntry<String, Resource>(entry.getKey(), result);
        }
        return null;
    }

    private File wrap(Project project, File aspectjrtBundle, Pair<File, Version> aspectjrt) throws Exception, IOException {
        try (Builder b = new Builder();
             Jar aj = new Jar(aspectjrt.getFirst());){
            Manifest manifest = new Manifest(aj.getManifest());
            aj.setManifest(new Manifest());
            b.setJar(aj);
            b.setProperty("Bundle-SymbolicName", "biz.aQute.aspectjrt");
            b.setProperty("Bundle-Description", "Generated from Aspectj runtime");
            b.setProperty("Bundle-Version", aspectjrt.getSecond().toString());
            b.setProperty("-exportcontents", "*;version='" + aspectjrt.getSecond() + "'");
            Jar jar = b.build();
            if (!b.isOk()) {
                project.getInfo(b);
                File file = null;
                return file;
            }
            Manifest newer = jar.getManifest();
            for (Map.Entry<String, Attributes> e : manifest.getEntries().entrySet()) {
                newer.getEntries().put(e.getKey(), e.getValue());
            }
            jar.write(aspectjrtBundle);
        }
        return aspectjrtBundle;
    }

    private WriteResource propertiesResource(final Resource properties, final UTF8Properties launchProperties) {
        return new WriteResource(){

            @Override
            public void write(OutputStream out) throws Exception {
                launchProperties.store(out);
            }

            @Override
            public long lastModified() {
                return properties.lastModified();
            }
        };
    }

    private String simple(String path) {
        int n = path.lastIndexOf(47);
        if (n < 0) {
            return path;
        }
        return path.substring(n + 1);
    }

    private Pair<File, Version> get(Workspace workspace, String bsn) throws Exception {
        for (RepositoryPlugin rp : workspace.getPlugins(RepositoryPlugin.class)) {
            SortedSet<Version> list = rp.versions(bsn);
            if (list.isEmpty()) continue;
            return new Pair<File, Version>(rp.get(bsn, list.last(), null, new RepositoryPlugin.DownloadListener[0]), list.last());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String ajc(Project project, List<File> cp, File inpath, List<File> sourceroots, List<File> aspectpath, File outpath, Map<String, String> options, boolean warnings) {
        String string;
        StringBuffer stdout;
        Command acjt;
        block7: {
            acjt = new Command();
            acjt.add(IO.getJavaExecutablePath("java"));
            acjt.add("-classpath");
            acjt.add(this.path(cp));
            acjt.add("org.aspectj.tools.ajc.Main");
            acjt.add("-inpath");
            acjt.add(inpath.getAbsolutePath());
            acjt.add("-sourceroots");
            acjt.add(this.path(sourceroots));
            acjt.add("-aspectpath");
            acjt.add(this.path(aspectpath));
            acjt.add("-outjar");
            acjt.add(outpath.getAbsolutePath());
            acjt.setTimeout(2L, TimeUnit.MINUTES);
            String source = project.getProperty("javac.source", options.getOrDefault("javac.source", "1.8"));
            String target = project.getProperty("javac.target", options.getOrDefault("javac.source", source));
            acjt.add("-source");
            acjt.add(source);
            acjt.add("-target");
            acjt.add(target);
            String coptions = options.get("ajc");
            if (coptions != null) {
                for (String coption : Strings.split(coptions)) {
                    acjt.add(coption);
                }
            }
            stdout = new StringBuffer();
            System.out.println(acjt);
            int n = acjt.execute(stdout, stdout);
            String output = stdout.toString();
            this.doErrors(project, warnings, output);
            if (n == 0) break block7;
            String string2 = stdout.toString();
            project.trace("console output %s", stdout);
            return string2;
        }
        try {
            System.out.println(stdout);
            string = null;
        }
        catch (Exception e) {
            String string3;
            try {
                Reporter.SetLocation location = project.exception(e, "failed to run acj: %s on %s\n%s", e.getMessage(), acjt, stdout);
                this.setLocation(project, location);
                string3 = stdout.toString();
            }
            catch (Throwable throwable) {
                project.trace("console output %s", stdout);
                throw throwable;
            }
            project.trace("console output %s", stdout);
            return string3;
        }
        project.trace("console output %s", stdout);
        return string;
    }

    private void doErrors(Project project, boolean warnings, String output) throws Exception {
        Reporter.SetLocation location;
        Matcher m;
        if (warnings) {
            m = AJC_WARNING_P.matcher(output);
            while (m.find()) {
                location = project.warning("%s", m.group(2));
                this.setLocation(project, location);
            }
        }
        m = AJC_ERROR_P.matcher(output);
        while (m.find()) {
            location = project.error("%s", m.group(2));
            this.setLocation(project, location);
        }
    }

    private void setLocation(Project project, Reporter.SetLocation location) {
        try {
            Project bnd = project.getWorkspace().getProject(project.getBase().getName());
            if (bnd == null) {
                bnd = project;
            }
            Processor.FileLine header = bnd.getHeader("-export", project.getPropertiesFile().getName());
            header.set(location);
        }
        catch (Exception e) {
            log.error("failed to set location {}", (Object)e, (Object)e);
        }
    }

    private String path(List<File> paths) {
        return Strings.join(File.pathSeparator, paths);
    }
}

