/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.log4j.helpers.LogLog;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class Loader {
    static final String TSTR = "Caught Exception while in Loader.getResource. This may be innocuous.";
    private static boolean ignoreTCL = false;

    public static URL getResource(String resource, Class clazz) {
        return Loader.getResource(resource);
    }

    public static URL getResource(String resource) {
        URL url;
        Bundle bundle = FrameworkUtil.getBundle(Loader.class);
        if (bundle != null) {
            LogLog.debug("Trying to find [" + resource + "] using " + bundle.getSymbolicName() + "/" + bundle.getVersion() + " bundle.");
            url = bundle.getResource(resource);
            if (url != null) {
                return url;
            }
        }
        try {
            URL url0;
            if (!ignoreTCL && (url0 = Loader.innerGetResource(resource, Loader.getTCL())) != null) {
                return url0;
            }
            url = Loader.innerGetResource(resource, Loader.class.getClassLoader());
            if (url != null) {
                return url;
            }
        }
        catch (SecurityException t) {
            LogLog.warn(TSTR, t);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        LogLog.debug("Trying to find [" + resource + "] using ClassLoader.getSystemResource().");
        return ClassLoader.getSystemResource(resource);
    }

    private static URL innerGetResource(String resource, ClassLoader classLoader) {
        if (classLoader != null) {
            LogLog.debug("Trying to find [" + resource + "] using " + classLoader + " class loader.");
            return classLoader.getResource(resource);
        }
        return null;
    }

    @Deprecated
    public static boolean isJava1() {
        return false;
    }

    private static ClassLoader getTCL() throws IllegalAccessException, InvocationTargetException {
        Method method = null;
        try {
            method = Thread.class.getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
    }

    public static Class loadClass(String clazz) throws ClassNotFoundException {
        Bundle bundle;
        if (Thread.currentThread().getContextClassLoader() != null) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((bundle = FrameworkUtil.getBundle(Loader.class)) != null) {
            try {
                return bundle.loadClass(clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Class.forName(clazz);
    }
}

