/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.model.JBBPNumericArray;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPFieldArrayInt
extends JBBPAbstractArrayField<JBBPFieldInt>
implements JBBPNumericArray {
    private static final long serialVersionUID = 6839868800303265190L;
    private final int[] array;

    public JBBPFieldArrayInt(JBBPNamedFieldInfo name, int[] array) {
        super(name);
        JBBPUtils.assertNotNull(array, "Array must not be null");
        this.array = array;
    }

    public int[] getArray() {
        return (int[])this.array.clone();
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public JBBPFieldInt getElementAt(int index) {
        JBBPFieldInt result = new JBBPFieldInt(this.fieldNameInfo, this.array[index]);
        result.payload = this.payload;
        return result;
    }

    @Override
    public int getAsInt(int index) {
        return this.array[index];
    }

    @Override
    public long getAsLong(int index) {
        return this.getAsInt(index);
    }

    @Override
    public boolean getAsBool(int index) {
        return this.array[index] != 0;
    }

    @Override
    public Object getValueArrayAsObject(boolean reverseBits) {
        int[] result;
        if (reverseBits) {
            result = (int[])this.array.clone();
            for (int i = 0; i < result.length; ++i) {
                result[i] = (int)JBBPFieldInt.reverseBits(result[i]);
            }
        } else {
            result = (int[])this.array.clone();
        }
        return result;
    }

    @Override
    public String getTypeAsString() {
        return "int [" + this.array.length + ']';
    }
}

