/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.websocket.log;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.openhab.core.io.websocket.log.LogDTO;
import org.openhab.core.io.websocket.log.LogWebSocketAdapter;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
@NonNullByDefault
public class LogWebSocket
implements LogListener {
    private static final TypeToken<List<String>> STRING_LIST_TYPE = TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class});
    private final Logger logger = LoggerFactory.getLogger(LogWebSocket.class);
    private final LogWebSocketAdapter wsAdapter;
    private final Gson gson;
    private @Nullable Session session;
    private @Nullable RemoteEndpoint remoteEndpoint;
    private String remoteIdentifier = "<unknown>";
    private List<Pattern> loggerPatterns = List.of();

    public LogWebSocket(Gson gson, LogWebSocketAdapter wsAdapter) {
        this.wsAdapter = wsAdapter;
        this.gson = gson;
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.wsAdapter.unregisterListener(this);
        this.remoteIdentifier = "<unknown>";
        this.session = null;
        this.remoteEndpoint = null;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        RemoteEndpoint remoteEndpoint;
        this.session = session;
        this.remoteEndpoint = remoteEndpoint = session.getRemote();
        this.remoteIdentifier = remoteEndpoint.getInetSocketAddress().toString();
        this.wsAdapter.registerListener(this);
    }

    @OnWebSocketMessage
    public void onText(String message) {
        RemoteEndpoint remoteEndpoint = this.remoteEndpoint;
        if (this.session == null || remoteEndpoint == null) {
            return;
        }
        try {
            this.loggerPatterns = ((List)this.gson.fromJson(message, STRING_LIST_TYPE)).stream().map(Pattern::compile).toList();
        }
        catch (JsonParseException e) {
            this.logger.warn("Failed to parse '{}' to a list of subscribed loggers", (Object)message);
        }
    }

    @OnWebSocketError
    public void onError(Session session, @Nullable Throwable error) {
        if (session != null) {
            session.close();
        }
        String message = error == null ? "<null>" : Objects.requireNonNullElse(error.getMessage(), "<null>");
        this.logger.info("WebSocket error: {}", (Object)message);
        this.onClose(1005, message);
    }

    private synchronized void sendMessage(String message) throws IOException {
        RemoteEndpoint remoteEndpoint = this.remoteEndpoint;
        if (remoteEndpoint == null) {
            this.logger.warn("Could not determine remote endpoint, failed to send '{}'.", (Object)message);
            return;
        }
        remoteEndpoint.sendString(message);
    }

    public void logged(@NonNullByDefault(value={}) LogEntry logEntry) {
        if (!this.loggerPatterns.isEmpty() && this.loggerPatterns.stream().noneMatch(LogWebSocket.logMatch(logEntry))) {
            return;
        }
        try {
            LogDTO logDTO = LogWebSocket.map(logEntry);
            this.sendMessage(this.gson.toJson((Object)logDTO));
        }
        catch (IOException e) {
            this.logger.debug("Failed to send log {} to {}: {}", new Object[]{logEntry, this.remoteIdentifier, e.getMessage()});
        }
    }

    private static Predicate<Pattern> logMatch(LogEntry logEntry) {
        return pattern -> pattern.matcher(logEntry.getLoggerName()).matches();
    }

    private static LogDTO map(LogEntry logEntry) {
        LogDTO logDTO = new LogDTO();
        logDTO.loggerName = logEntry.getLoggerName();
        logDTO.level = logEntry.getLogLevel();
        logDTO.unixtime = logEntry.getTime();
        logDTO.timestamp = new Date(logEntry.getTime());
        logDTO.message = logEntry.getMessage();
        return logDTO;
    }
}

