/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio.internal.webaudio;

import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.internal.webaudio.PlayURLEvent;
import org.openhab.core.events.AbstractEventFactory;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFactory;
import org.osgi.service.component.annotations.Component;

@NonNullByDefault
@Component(service={EventFactory.class}, immediate=true)
public class WebAudioEventFactory
extends AbstractEventFactory {
    private static final String PLAY_URL_TOPIC = "openhab/webaudio/playurl";

    public WebAudioEventFactory() {
        super(Set.of(PlayURLEvent.TYPE));
    }

    protected Event createEventByType(String eventType, String topic, String payload, @Nullable String source) throws Exception {
        if (PlayURLEvent.TYPE.equals(eventType)) {
            String url = (String)WebAudioEventFactory.deserializePayload((String)payload, String.class);
            return WebAudioEventFactory.createPlayURLEvent(url);
        }
        throw new IllegalArgumentException("The event type '" + eventType + "' is not supported by this factory.");
    }

    public static PlayURLEvent createPlayURLEvent(String url) {
        String payload = WebAudioEventFactory.serializePayload((Object)url);
        return new PlayURLEvent(PLAY_URL_TOPIC, payload, url);
    }
}

