/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.coordinator.impl;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class LogWrapper {
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    private final Set<ServiceReference> loggerRefs = new TreeSet<ServiceReference>(new Comparator<ServiceReference>(){

        @Override
        public int compare(ServiceReference o1, ServiceReference o2) {
            return o2.compareTo((Object)o1);
        }
    });
    private BundleContext context;
    private ServiceListener logServiceListener;
    private int logLevel = 2;

    public static LogWrapper getLogger() {
        return LogWrapperLoader.SINGLETON;
    }

    public static void setContext(BundleContext context) {
        LogWrapper logWrapper = LogWrapperLoader.SINGLETON;
        if (context == null) {
            if (logWrapper.logServiceListener != null) {
                logWrapper.context.removeServiceListener(logWrapper.logServiceListener);
                logWrapper.logServiceListener = null;
            }
            logWrapper.removeLoggerRefs();
        }
        logWrapper.setBundleContext(context);
        if (context != null) {
            try {
                ServiceListener listener = new ServiceListener(){

                    public void serviceChanged(ServiceEvent event) {
                        if (1 == event.getType()) {
                            LogWrapperLoader.SINGLETON.addLoggerRef(event.getServiceReference());
                        } else if (4 == event.getType()) {
                            LogWrapperLoader.SINGLETON.removeLoggerRef(event.getServiceReference());
                        }
                    }
                };
                context.addServiceListener(listener, "(objectClass=org.osgi.service.log.LogService)");
                logWrapper.logServiceListener = listener;
                ServiceReference[] refs = context.getServiceReferences("org.osgi.service.log.LogService", null);
                if (null != refs) {
                    for (int i = 0; i < refs.length; ++i) {
                        logWrapper.addLoggerRef(refs[i]);
                    }
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
    }

    LogWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLoggerRefs() {
        Set<ServiceReference> set = this.loggerRefs;
        synchronized (set) {
            this.loggerRefs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLoggerRef(ServiceReference ref) {
        Set<ServiceReference> set = this.loggerRefs;
        synchronized (set) {
            this.loggerRefs.add(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLoggerRef(ServiceReference ref) {
        Set<ServiceReference> set = this.loggerRefs;
        synchronized (set) {
            this.loggerRefs.remove(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBundleContext(BundleContext context) {
        Set<ServiceReference> set = this.loggerRefs;
        synchronized (set) {
            this.context = context;
        }
    }

    public void log(int level, String msg) {
        this.log(null, level, msg, null);
    }

    public void log(int level, String msg, Throwable ex) {
        this.log(null, level, msg, null);
    }

    public void log(ServiceReference sr, int level, String msg) {
        this.log(sr, level, msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(ServiceReference sr, int level, String msg, Throwable ex) {
        Set<ServiceReference> set = this.loggerRefs;
        synchronized (set) {
            if (level > this.logLevel) {
                return;
            }
            boolean logged = false;
            if (!this.loggerRefs.isEmpty()) {
                Iterator<ServiceReference> iter = this.loggerRefs.iterator();
                while (iter.hasNext()) {
                    ServiceReference next = iter.next();
                    LogService logger = (LogService)this.context.getService(next);
                    if (null != logger) {
                        if (sr == null) {
                            if (ex == null) {
                                logger.log(level, msg);
                            } else {
                                logger.log(level, msg, ex);
                            }
                        } else if (ex == null) {
                            logger.log(sr, level, msg);
                        } else {
                            logger.log(sr, level, msg, ex);
                        }
                        this.context.ungetService(next);
                        logged = true;
                        break;
                    }
                    iter.remove();
                }
            }
            if (!logged) {
                this._log(sr, level, msg, ex);
            }
        }
    }

    private void _log(ServiceReference sr, int level, String msg, Throwable ex) {
        String s = sr == null ? null : "SvcRef " + sr;
        s = s == null ? msg : s + " " + msg;
        s = ex == null ? s : s + " (" + ex + ")";
        switch (level) {
            case 4: {
                System.out.println("DEBUG: " + s);
                break;
            }
            case 1: {
                System.out.println("ERROR: " + s);
                if (ex == null) break;
                if (ex instanceof BundleException && ((BundleException)ex).getNestedException() != null) {
                    ex = ((BundleException)ex).getNestedException();
                }
                ex.printStackTrace();
                break;
            }
            case 3: {
                System.out.println("INFO: " + s);
                break;
            }
            case 2: {
                System.out.println("WARNING: " + s);
                break;
            }
            default: {
                System.out.println("UNKNOWN[" + level + "]: " + s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogLevel(int logLevel) {
        Set<ServiceReference> set = this.loggerRefs;
        synchronized (set) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLogLevel() {
        Set<ServiceReference> set = this.loggerRefs;
        synchronized (set) {
            return this.logLevel;
        }
    }

    private static class LogWrapperLoader {
        static final LogWrapper SINGLETON = new LogWrapper();

        private LogWrapperLoader() {
        }
    }
}

