/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.binding.annotations;

import java.util.Set;
import org.jupnp.binding.AllowedValueProvider;
import org.jupnp.binding.AllowedValueRangeProvider;
import org.jupnp.binding.LocalServiceBindingException;
import org.jupnp.binding.annotations.AnnotationLocalServiceBinder;
import org.jupnp.binding.annotations.UpnpStateVariable;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.meta.StateVariableAllowedValueRange;
import org.jupnp.model.meta.StateVariableEventDetails;
import org.jupnp.model.meta.StateVariableTypeDetails;
import org.jupnp.model.state.StateVariableAccessor;
import org.jupnp.model.types.Datatype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationStateVariableBinder {
    private final Logger logger = LoggerFactory.getLogger(AnnotationLocalServiceBinder.class);
    protected UpnpStateVariable annotation;
    protected String name;
    protected StateVariableAccessor accessor;
    protected Set<Class> stringConvertibleTypes;

    public AnnotationStateVariableBinder(UpnpStateVariable annotation, String name, StateVariableAccessor accessor, Set<Class> stringConvertibleTypes) {
        this.annotation = annotation;
        this.name = name;
        this.accessor = accessor;
        this.stringConvertibleTypes = stringConvertibleTypes;
    }

    public UpnpStateVariable getAnnotation() {
        return this.annotation;
    }

    public String getName() {
        return this.name;
    }

    public StateVariableAccessor getAccessor() {
        return this.accessor;
    }

    public Set<Class> getStringConvertibleTypes() {
        return this.stringConvertibleTypes;
    }

    protected StateVariable createStateVariable() throws LocalServiceBindingException {
        boolean sendEvents;
        this.logger.trace("Creating state variable '{}' with accessor: {}", (Object)this.getName(), (Object)this.getAccessor());
        Datatype datatype = this.createDatatype();
        String defaultValue = this.createDefaultValue(datatype);
        String[] allowedValues = null;
        if (Datatype.Builtin.STRING.equals((Object)datatype.getBuiltin())) {
            if (this.getAnnotation().allowedValueProvider() != Void.TYPE) {
                allowedValues = this.getAllowedValuesFromProvider();
            } else if (this.getAnnotation().allowedValues().length > 0) {
                allowedValues = this.getAnnotation().allowedValues();
            } else if (this.getAnnotation().allowedValuesEnum() != Void.TYPE) {
                allowedValues = this.getAllowedValues(this.getAnnotation().allowedValuesEnum());
            } else if (this.getAccessor() != null && this.getAccessor().getReturnType().isEnum()) {
                allowedValues = this.getAllowedValues(this.getAccessor().getReturnType());
            } else {
                this.logger.trace("Not restricting allowed values (of string typed state var): {}", (Object)this.getName());
            }
            if (allowedValues != null && defaultValue != null) {
                boolean foundValue = false;
                for (String s : allowedValues) {
                    if (!s.equals(defaultValue)) continue;
                    foundValue = true;
                    break;
                }
                if (!foundValue) {
                    throw new LocalServiceBindingException("Default value '" + defaultValue + "' is not in allowed values of: " + this.getName());
                }
            }
        }
        StateVariableAllowedValueRange allowedValueRange = null;
        if (Datatype.Builtin.isNumeric(datatype.getBuiltin())) {
            if (this.getAnnotation().allowedValueRangeProvider() != Void.TYPE) {
                allowedValueRange = this.getAllowedRangeFromProvider();
            } else if (this.getAnnotation().allowedValueMinimum() > 0L || this.getAnnotation().allowedValueMaximum() > 0L) {
                allowedValueRange = this.getAllowedValueRange(this.getAnnotation().allowedValueMinimum(), this.getAnnotation().allowedValueMaximum(), this.getAnnotation().allowedValueStep());
            } else {
                this.logger.trace("Not restricting allowed value range (of numeric typed state var): {}", (Object)this.getName());
            }
            if (defaultValue != null && allowedValueRange != null) {
                long v;
                try {
                    v = Long.parseLong(defaultValue);
                }
                catch (Exception e) {
                    throw new LocalServiceBindingException("Default value '" + defaultValue + "' is not numeric (for range checking) of: " + this.getName());
                }
                if (!allowedValueRange.isInRange(v)) {
                    throw new LocalServiceBindingException("Default value '" + defaultValue + "' is not in allowed range of: " + this.getName());
                }
            }
        }
        if ((sendEvents = this.getAnnotation().sendEvents()) && this.getAccessor() == null) {
            throw new LocalServiceBindingException("State variable sends events but has no accessor for field or getter: " + this.getName());
        }
        int eventMaximumRateMillis = 0;
        int eventMinimumDelta = 0;
        if (sendEvents) {
            if (this.getAnnotation().eventMaximumRateMilliseconds() > 0) {
                this.logger.trace("Moderating state variable events using maximum rate (milliseconds): {}", (Object)this.getAnnotation().eventMaximumRateMilliseconds());
                eventMaximumRateMillis = this.getAnnotation().eventMaximumRateMilliseconds();
            }
            if (this.getAnnotation().eventMinimumDelta() > 0 && Datatype.Builtin.isNumeric(datatype.getBuiltin())) {
                this.logger.trace("Moderating state variable events using minimum delta: {}", (Object)this.getAnnotation().eventMinimumDelta());
                eventMinimumDelta = this.getAnnotation().eventMinimumDelta();
            }
        }
        StateVariableTypeDetails typeDetails = new StateVariableTypeDetails(datatype, defaultValue, allowedValues, allowedValueRange);
        StateVariableEventDetails eventDetails = new StateVariableEventDetails(sendEvents, eventMaximumRateMillis, eventMinimumDelta);
        return new StateVariable(this.getName(), typeDetails, eventDetails);
    }

    protected Datatype createDatatype() throws LocalServiceBindingException {
        String declaredDatatype = this.getAnnotation().datatype();
        if (declaredDatatype.isEmpty() && this.getAccessor() != null) {
            Class<?> returnType = this.getAccessor().getReturnType();
            this.logger.trace("Using accessor return type as state variable type: {}", returnType);
            if (ModelUtil.isStringConvertibleType(this.getStringConvertibleTypes(), returnType)) {
                this.logger.trace("Return type is string-convertible, using string datatype");
                return Datatype.Default.STRING.getBuiltinType().getDatatype();
            }
            Datatype.Default defaultDatatype = Datatype.Default.getByJavaType(returnType);
            if (defaultDatatype != null) {
                this.logger.trace("Return type has default UPnP datatype: {}", (Object)defaultDatatype);
                return defaultDatatype.getBuiltinType().getDatatype();
            }
        }
        if (!(declaredDatatype != null && !declaredDatatype.isEmpty() || this.getAnnotation().allowedValues().length <= 0 && this.getAnnotation().allowedValuesEnum() == Void.TYPE)) {
            this.logger.trace("State variable has restricted allowed values, hence using 'string' datatype");
            declaredDatatype = "string";
        }
        if (declaredDatatype == null || declaredDatatype.isEmpty()) {
            throw new LocalServiceBindingException("Could not detect datatype of state variable: " + this.getName());
        }
        this.logger.trace("Trying to find built-in UPnP datatype for detected name: {}", (Object)declaredDatatype);
        Datatype.Builtin builtin = Datatype.Builtin.getByDescriptorName(declaredDatatype);
        if (builtin != null) {
            this.logger.trace("Found built-in UPnP datatype: {}", (Object)builtin);
            return builtin.getDatatype();
        }
        throw new LocalServiceBindingException("No built-in UPnP datatype found, using CustomDataType (TODO: NOT IMPLEMENTED)");
    }

    protected String createDefaultValue(Datatype datatype) throws LocalServiceBindingException {
        if (!this.getAnnotation().defaultValue().isEmpty()) {
            try {
                datatype.valueOf(this.getAnnotation().defaultValue());
                this.logger.trace("Found state variable default value: {}", (Object)this.getAnnotation().defaultValue());
                return this.getAnnotation().defaultValue();
            }
            catch (Exception e) {
                throw new LocalServiceBindingException("Default value doesn't match datatype of state variable '" + this.getName() + "': " + e.getMessage());
            }
        }
        return null;
    }

    protected String[] getAllowedValues(Class enumType) throws LocalServiceBindingException {
        if (!enumType.isEnum()) {
            throw new LocalServiceBindingException("Allowed values type is not an Enum: " + String.valueOf(enumType));
        }
        this.logger.trace("Restricting allowed values of state variable to Enum: {}", (Object)this.getName());
        String[] allowedValueStrings = new String[enumType.getEnumConstants().length];
        for (int i = 0; i < enumType.getEnumConstants().length; ++i) {
            Object o = enumType.getEnumConstants()[i];
            if (o.toString().length() > 32) {
                throw new LocalServiceBindingException("Allowed value string (that is, Enum constant name) is longer than 32 characters: " + String.valueOf(o));
            }
            this.logger.trace("Adding allowed value (converted to string): {}", o);
            allowedValueStrings[i] = o.toString();
        }
        return allowedValueStrings;
    }

    protected StateVariableAllowedValueRange getAllowedValueRange(long min, long max, long step) throws LocalServiceBindingException {
        if (max < min) {
            throw new LocalServiceBindingException("Allowed value range maximum is smaller than minimum: " + this.getName());
        }
        return new StateVariableAllowedValueRange(min, max, step);
    }

    protected String[] getAllowedValuesFromProvider() throws LocalServiceBindingException {
        Class provider = this.getAnnotation().allowedValueProvider();
        if (!AllowedValueProvider.class.isAssignableFrom(provider)) {
            throw new LocalServiceBindingException("Allowed value provider is not of type " + String.valueOf(AllowedValueProvider.class) + ": " + this.getName());
        }
        try {
            return ((AllowedValueProvider)provider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getValues();
        }
        catch (Exception e) {
            throw new LocalServiceBindingException("Allowed value provider can't be instantiated: " + this.getName(), e);
        }
    }

    protected StateVariableAllowedValueRange getAllowedRangeFromProvider() throws LocalServiceBindingException {
        Class provider = this.getAnnotation().allowedValueRangeProvider();
        if (!AllowedValueRangeProvider.class.isAssignableFrom(provider)) {
            throw new LocalServiceBindingException("Allowed value range provider is not of type " + String.valueOf(AllowedValueRangeProvider.class) + ": " + this.getName());
        }
        try {
            AllowedValueRangeProvider providerInstance = (AllowedValueRangeProvider)provider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return this.getAllowedValueRange(providerInstance.getMinimum(), providerInstance.getMaximum(), providerInstance.getStep());
        }
        catch (Exception e) {
            throw new LocalServiceBindingException("Allowed value range provider can't be instantiated: " + this.getName(), e);
        }
    }
}

