/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.xtext.util.formallang.FollowerFunction;
import org.eclipse.xtext.util.formallang.Production;

public class FollowerFunctionImpl<E, T>
implements FollowerFunction<E> {
    protected Direction direction = Direction.L2R;
    protected Predicate<E> filter;
    protected Production<E, T> production;
    protected UnorderedStrategy unorderedStrategy = UnorderedStrategy.MULIT_ALTERNATIVE;

    public FollowerFunctionImpl(Production<E, T> production) {
        this.production = production;
    }

    protected void collectByParent(E element, Set<E> result, Set<E> visited) {
        E container = this.production.getParent(element);
        if (container == null) {
            result.add(null);
        } else {
            Iterable<E> children = this.production.getSequentialChildren(container);
            if (children != null) {
                this.collectByParentSequence(element, container, children, result, visited);
            } else {
                children = this.production.getUnorderedChildren(container);
                if (children != null) {
                    switch (this.unorderedStrategy) {
                        case SEQUENCE: {
                            this.collectByParentSequence(element, container, children, result, visited);
                            break;
                        }
                        case MULIT_ALTERNATIVE: {
                            this.collectElement(container, result, visited);
                            this.collectByParent(container, result, visited);
                        }
                    }
                } else {
                    if (this.production.isMany(container)) {
                        this.collectElement(container, result, visited);
                    }
                    this.collectByParent(container, result, visited);
                }
            }
        }
    }

    protected void collectByParentSequence(E element, E container, Iterable<E> children, Set<E> result, Set<E> visited) {
        List<E> sequentialChildren = this.orderedList(children);
        int i = sequentialChildren.indexOf(element) + 1;
        while (i < sequentialChildren.size()) {
            E next = sequentialChildren.get(i);
            this.collectElement(next, result, visited);
            if (!this.production.isOptional(next)) break;
            ++i;
        }
        if (i >= sequentialChildren.size()) {
            if (this.production.isMany(container)) {
                this.collectElement(container, result, visited);
            }
            this.collectByParent(container, result, visited);
        }
    }

    protected void collectChildren(E element, Set<E> result, Set<E> visited) {
        Iterable<E> children = this.production.getSequentialChildren(element);
        if (children != null) {
            this.collectChildrenSequence(element, children, result, visited);
        } else {
            children = this.production.getAlternativeChildren(element);
            if (children != null) {
                this.collectChildrenAlternative(element, children, result, visited);
            } else {
                children = this.production.getUnorderedChildren(element);
                if (children != null) {
                    switch (this.unorderedStrategy) {
                        case SEQUENCE: {
                            this.collectChildrenSequence(element, children, result, visited);
                            break;
                        }
                        case MULIT_ALTERNATIVE: {
                            this.collectChildrenUnorderedAlt(element, children, result, visited);
                        }
                    }
                } else {
                    if (this.production.isMany(element)) {
                        this.collectElement(element, result, visited);
                    }
                    this.collectByParent(element, result, visited);
                }
            }
        }
    }

    protected void collectChildrenAlternative(E element, Iterable<E> alternativeChildren, Set<E> result, Set<E> visited) {
        boolean optional = this.production.isOptional(element);
        for (E child : this.orderedIterable(alternativeChildren)) {
            optional |= this.production.isOptional(child);
            this.collectElement(child, result, visited);
        }
        if (optional) {
            this.collectByParent(element, result, visited);
        }
    }

    protected void collectChildrenSequence(E element, Iterable<E> sequentialChildren, Set<E> result, Set<E> visited) {
        boolean reachedEnd = true;
        for (E child : this.orderedIterable(sequentialChildren)) {
            this.collectElement(child, result, visited);
            if (this.production.isOptional(child)) continue;
            reachedEnd = false;
            break;
        }
        if (reachedEnd || this.production.isOptional(element)) {
            this.collectByParent(element, result, visited);
        }
    }

    protected void collectChildrenUnorderedAlt(E element, Iterable<E> alternativeChildren, Set<E> result, Set<E> visited) {
        boolean hasMandatory = false;
        for (E child : this.orderedIterable(alternativeChildren)) {
            hasMandatory |= !this.production.isOptional(child);
            this.collectElement(child, result, visited);
        }
        if (!hasMandatory || this.production.isOptional(element)) {
            this.collectByParent(element, result, visited);
        }
    }

    protected void collectElement(E ele, Set<E> result, Set<E> visited) {
        if (!visited.add(ele)) {
            return;
        }
        if (this.filter(ele)) {
            result.add(ele);
        } else {
            this.collectChildren(ele, result, visited);
        }
    }

    protected boolean filter(E ele) {
        if (this.filter != null) {
            return this.filter.apply(ele);
        }
        return this.production.getSequentialChildren(ele) == null && this.production.getAlternativeChildren(ele) == null && this.production.getUnorderedChildren(ele) == null;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Predicate<E> getFilter() {
        return this.filter;
    }

    @Override
    public Iterable<E> getFollowers(E element) {
        if (this.filter(element)) {
            if (element == null) {
                throw new NullPointerException();
            }
            LinkedHashSet outgoing = Sets.newLinkedHashSet();
            this.collectChildren(element, outgoing, Sets.newHashSet());
            return outgoing;
        }
        return Collections.emptyList();
    }

    public Production<E, ?> getProduction() {
        return this.production;
    }

    @Override
    public Iterable<E> getStarts(E root) {
        if (root == null) {
            throw new NullPointerException();
        }
        LinkedHashSet outgoing = Sets.newLinkedHashSet();
        if (this.filter(root)) {
            outgoing.add(root);
            if (this.production.isOptional(root)) {
                outgoing.add(null);
            }
        } else {
            this.collectChildren(root, outgoing, Sets.newHashSet());
        }
        return outgoing;
    }

    public UnorderedStrategy getUnorderedStrategy() {
        return this.unorderedStrategy;
    }

    protected Iterable<E> orderedIterable(Iterable<E> elements) {
        return this.direction == Direction.L2R ? elements : Lists.reverse(this.toList(elements));
    }

    protected List<E> orderedList(Iterable<E> elements) {
        if (this.direction == Direction.L2R) {
            return this.toList(elements);
        }
        ArrayList result = Lists.newArrayList(elements);
        Collections.reverse(result);
        return result;
    }

    public FollowerFunctionImpl<E, T> setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public FollowerFunctionImpl<E, T> setFilter(Predicate<E> filter) {
        this.filter = filter;
        return this;
    }

    public FollowerFunctionImpl<E, T> setUnorderedStrategy(UnorderedStrategy unorderedStrategy) {
        this.unorderedStrategy = unorderedStrategy;
        return this;
    }

    protected List<E> toList(Iterable<E> elements) {
        return elements instanceof List ? (List)elements : Lists.newArrayList(elements);
    }

    public static enum Direction {
        L2R,
        R2L;

    }

    public static enum UnorderedStrategy {
        MULIT_ALTERNATIVE,
        SEQUENCE;

    }
}

