/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack.congestioncontrol;

import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.RemoteEndpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.CongestionControlLayer;

public class LinuxRto
extends CongestionControlLayer {
    public LinuxRto(NetworkConfig config) {
        super(config);
    }

    @Override
    public void initializeRTOEstimators(long measuredRTT, int estimatorType, RemoteEndpoint endpoint) {
        long RTT;
        endpoint.SRTT = RTT = measuredRTT;
        endpoint.mdev = RTT / 2L;
        endpoint.RTTVAR = endpoint.mdev_max = Math.max(endpoint.mdev, 50L);
        long newRTO = endpoint.SRTT + 4L * endpoint.RTTVAR;
        endpoint.printLinuxStats();
        endpoint.updateRTO(newRTO);
    }

    @Override
    protected void updateEstimator(long measuredRTT, int estimatorType, RemoteEndpoint endpoint) {
        long RTT = measuredRTT;
        endpoint.SRTT += Math.round(0.125 * (double)(RTT - endpoint.SRTT));
        endpoint.mdev = RTT < endpoint.SRTT - endpoint.mdev ? Math.round(0.96875 * (double)endpoint.mdev) + Math.round(0.03125 * (double)Math.abs(RTT - endpoint.SRTT)) : Math.round(0.75 * (double)endpoint.mdev) + Math.round(0.25 * (double)Math.abs(RTT - endpoint.SRTT));
        if (endpoint.mdev > endpoint.mdev_max) {
            endpoint.mdev_max = endpoint.mdev;
            if (endpoint.mdev_max > endpoint.RTTVAR) {
                endpoint.RTTVAR = endpoint.mdev_max;
            }
        }
        if (endpoint.mdev_max < endpoint.RTTVAR) {
            endpoint.RTTVAR = Math.round(0.75 * (double)endpoint.RTTVAR) + Math.round(0.25 * (double)endpoint.mdev_max);
        }
        endpoint.mdev_max = 50L;
        long newRTO = endpoint.SRTT + 4L * endpoint.RTTVAR;
        endpoint.printLinuxStats();
        endpoint.updateRTO(newRTO);
    }

    @Override
    public void processRTTmeasurement(long measuredRTT, Exchange exchange, int retransmissionCount) {
        RemoteEndpoint endpoint = this.getRemoteEndpoint(exchange);
        int rtoType = endpoint.getExchangeEstimatorState(exchange);
        if (rtoType == 3 || rtoType == 2) {
            return;
        }
        endpoint.matchCurrentRTO();
        if (endpoint.isBlindStrong() && rtoType == 1) {
            endpoint.setBlindStrong(false);
            this.initializeRTOEstimators(measuredRTT, rtoType, endpoint);
        } else {
            this.updateEstimator(measuredRTT, rtoType, endpoint);
        }
    }
}

