/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.PrincipalEndpointContextMatcher;
import org.eclipse.californium.elements.RelaxedDtlsEndpointContextMatcher;
import org.eclipse.californium.elements.StrictDtlsEndpointContextMatcher;
import org.eclipse.californium.elements.TcpEndpointContextMatcher;
import org.eclipse.californium.elements.TlsEndpointContextMatcher;
import org.eclipse.californium.elements.UdpEndpointContextMatcher;

public class EndpointContextMatcherFactory {
    public static EndpointContextMatcher create(Connector connector, NetworkConfig config) {
        String protocol = null;
        if (null != connector) {
            protocol = connector.getProtocol();
            if ("TCP".equalsIgnoreCase(protocol)) {
                return new TcpEndpointContextMatcher();
            }
            if ("TLS".equalsIgnoreCase(protocol)) {
                return new TlsEndpointContextMatcher();
            }
        }
        String textualMode = "???";
        MatcherMode mode = MatcherMode.STRICT;
        try {
            textualMode = config.getString("RESPONSE_MATCHING");
            mode = MatcherMode.valueOf(textualMode);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Response matching mode '" + textualMode + "' not supported!");
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Response matching mode not provided/configured!");
        }
        switch (mode) {
            case RELAXED: {
                if ("UDP".equalsIgnoreCase(protocol)) {
                    return new UdpEndpointContextMatcher(false);
                }
                return new RelaxedDtlsEndpointContextMatcher();
            }
            case PRINCIPAL: {
                if ("UDP".equalsIgnoreCase(protocol)) {
                    return new UdpEndpointContextMatcher(false);
                }
                return new PrincipalEndpointContextMatcher();
            }
        }
        if ("UDP".equalsIgnoreCase(protocol)) {
            return new UdpEndpointContextMatcher(true);
        }
        return new StrictDtlsEndpointContextMatcher();
    }

    public static enum MatcherMode {
        STRICT,
        RELAXED,
        PRINCIPAL;

    }
}

