/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;

public class JcePublicKeyDataDecryptorFactoryBuilder {
    private static final int X25519_KEY_SIZE = 32;
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private OperatorHelper contentHelper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();
    private JcaKeyFingerprintCalculator fingerprintCalculator = new JcaKeyFingerprintCalculator();

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.contentHelper = this.helper;
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        this.contentHelper = this.helper;
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(Provider provider) {
        this.contentHelper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(String string) {
        this.contentHelper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        return this;
    }

    public PublicKeyDataDecryptorFactory build(final PrivateKey privateKey) {
        return new PublicKeyDataDecryptorFactory(){

            public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
                if (n == 18) {
                    throw new PGPException("ECDH requires use of PGPPrivateKey for decryption");
                }
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(n, privateKey, byArray);
            }

            public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(bl, n, byArray);
            }
        };
    }

    public PublicKeyDataDecryptorFactory build(final PGPPrivateKey pGPPrivateKey) {
        return new PublicKeyDataDecryptorFactory(){

            public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
                if (n == 18) {
                    return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter, pGPPrivateKey, byArray);
                }
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(n, JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter.getPrivateKey(pGPPrivateKey), byArray);
            }

            public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(bl, n, byArray);
            }
        };
    }

    private byte[] decryptSessionData(JcaPGPKeyConverter jcaPGPKeyConverter, PGPPrivateKey pGPPrivateKey, byte[][] byArray) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
        byte[] byArray2 = byArray[0];
        int n = (((byArray2[0] & 0xFF) << 8) + (byArray2[1] & 0xFF) + 7) / 8;
        if (2 + n + 1 > byArray2.length) {
            throw new PGPException("encoded length out of range");
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 2, byArray3, 0, n);
        int n2 = byArray2[n + 2] & 0xFF;
        if (2 + n + 1 + n2 > byArray2.length) {
            throw new PGPException("encoded length out of range");
        }
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray2, 2 + n + 1, byArray4, 0, n2);
        try {
            Object object;
            PublicKey publicKey;
            Object object2;
            KeyAgreement keyAgreement;
            if (eCDHPublicBCPGKey.getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
                keyAgreement = this.helper.createKeyAgreement(RFC6637Utils.getXDHAlgorithm(publicKeyPacket));
                object2 = this.helper.createKeyFactory("XDH");
                if (byArray3.length != 33 || 64 != byArray3[0]) {
                    throw new IllegalArgumentException("Invalid Curve25519 public key");
                }
                publicKey = object2.generatePublic(new X509EncodedKeySpec(new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), Arrays.copyOfRange((byte[])byArray3, (int)1, (int)byArray3.length)).getEncoded()));
            } else {
                object2 = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)eCDHPublicBCPGKey.getCurveOID());
                object = object2.getCurve().decodePoint(byArray3);
                keyAgreement = this.helper.createKeyAgreement(RFC6637Utils.getAgreementAlgorithm(publicKeyPacket));
                publicKey = jcaPGPKeyConverter.getPublicKey(new PGPPublicKey(new PublicKeyPacket(18, new Date(), new ECDHPublicBCPGKey(eCDHPublicBCPGKey.getCurveOID(), (ECPoint)object, (int)eCDHPublicBCPGKey.getHashAlgorithm(), (int)eCDHPublicBCPGKey.getSymmetricKeyAlgorithm())), this.fingerprintCalculator));
            }
            object2 = RFC6637Utils.createUserKeyingMaterial(publicKeyPacket, this.fingerprintCalculator);
            object = jcaPGPKeyConverter.getPrivateKey(pGPPrivateKey);
            keyAgreement.init((Key)object, (AlgorithmParameterSpec)new UserKeyingMaterialSpec((byte[])object2));
            keyAgreement.doPhase(publicKey, true);
            SecretKey secretKey = keyAgreement.generateSecret(RFC6637Utils.getKeyEncryptionOID(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm()).getId());
            Cipher cipher = this.helper.createKeyWrapper(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
            cipher.init(4, secretKey);
            Key key = cipher.unwrap(byArray4, "Session", 3);
            return PGPPad.unpadSessionData(key.getEncoded());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("error setting asymmetric cipher", invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PGPException("error setting asymmetric cipher", noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new PGPException("error setting asymmetric cipher", invalidAlgorithmParameterException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("error setting asymmetric cipher", generalSecurityException);
        }
        catch (IOException iOException) {
            throw new PGPException("error setting asymmetric cipher", iOException);
        }
    }

    private byte[] decryptSessionData(int n, PrivateKey privateKey, byte[][] byArray) throws PGPException {
        Object object;
        Cipher cipher = this.helper.createPublicKeyCipher(n);
        try {
            cipher.init(2, privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("error setting asymmetric cipher", invalidKeyException);
        }
        if (n == 2 || n == 1) {
            object = byArray[0];
            cipher.update((byte[])object, 2, ((Object)object).length - 2);
        } else {
            object = (DHKey)((Object)privateKey);
            int n2 = (object.getParams().getP().bitLength() + 7) / 8;
            byte[] byArray2 = new byte[n2];
            byte[] byArray3 = byArray[0];
            if (byArray3.length - 2 > n2) {
                cipher.update(byArray3, 3, byArray3.length - 3);
            } else {
                System.arraycopy(byArray3, 2, byArray2, byArray2.length - (byArray3.length - 2), byArray3.length - 2);
                cipher.update(byArray2);
            }
            byArray3 = byArray[1];
            for (int i = 0; i != byArray2.length; ++i) {
                byArray2[i] = 0;
            }
            if (byArray3.length - 2 > n2) {
                cipher.update(byArray3, 3, byArray3.length - 3);
            } else {
                System.arraycopy(byArray3, 2, byArray2, byArray2.length - (byArray3.length - 2), byArray3.length - 2);
                cipher.update(byArray2);
            }
        }
        try {
            return cipher.doFinal();
        }
        catch (Exception exception) {
            throw new PGPException("exception decrypting session data", exception);
        }
    }
}

