/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.ChopBoxConnector;
import CH.ifa.draw.standard.FigureAttributes;
import CH.ifa.draw.standard.FigureChangeEventMulticaster;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public abstract class AbstractFigure
implements Figure {
    private FigureAttributes fAttributes;
    private transient FigureChangeListener fListener;
    private static final long serialVersionUID = -10857585979273442L;
    private int abstractFigureSerializedDataVersion = 1;
    protected static Font dialogFont = Font.decode("dialog-PLAIN-12");

    protected AbstractFigure() {
    }

    public void moveBy(int n, int n2) {
        this.willChange();
        this.basicMoveBy(n, n2);
        this.changed();
    }

    protected abstract void basicMoveBy(int var1, int var2);

    public void displayBox(Point point, Point point2) {
        this.willChange();
        this.basicDisplayBox(point, point2);
        this.changed();
    }

    public abstract void basicDisplayBox(Point var1, Point var2);

    public abstract Rectangle displayBox();

    public abstract Vector handles();

    public FigureEnumeration figures() {
        Vector<AbstractFigure> vector = new Vector<AbstractFigure>(1);
        vector.addElement(this);
        return new FigureEnumerator(vector);
    }

    public Dimension size() {
        return new Dimension(this.displayBox().width, this.displayBox().height);
    }

    public boolean isEmpty() {
        return this.size().width < 3 || this.size().height < 3;
    }

    public Figure findFigureInside(int n, int n2) {
        if (this.containsPoint(n, n2)) {
            return this;
        }
        return null;
    }

    public boolean containsPoint(int n, int n2) {
        return this.displayBox().contains(n, n2);
    }

    public void displayBox(Rectangle rectangle) {
        this.displayBox(new Point(rectangle.x, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
    }

    public boolean includes(Figure figure) {
        return figure == this;
    }

    public FigureEnumeration decompose() {
        Vector<AbstractFigure> vector = new Vector<AbstractFigure>(1);
        vector.addElement(this);
        return new FigureEnumerator(vector);
    }

    public void addToContainer(FigureChangeListener figureChangeListener) {
        this.addFigureChangeListener(figureChangeListener);
        this.invalidate();
    }

    public void removeFromContainer(FigureChangeListener figureChangeListener) {
        this.invalidate();
        this.removeFigureChangeListener(figureChangeListener);
        this.changed();
    }

    public void addFigureChangeListener(FigureChangeListener figureChangeListener) {
        this.fListener = FigureChangeEventMulticaster.add(this.fListener, figureChangeListener);
    }

    public void removeFigureChangeListener(FigureChangeListener figureChangeListener) {
        this.fListener = FigureChangeEventMulticaster.remove(this.fListener, figureChangeListener);
    }

    public FigureChangeListener listener() {
        return this.fListener;
    }

    public void release() {
        if (this.fListener != null) {
            this.fListener.figureRemoved(new FigureChangeEvent(this));
        }
    }

    public void invalidate() {
        if (this.fListener != null) {
            Rectangle rectangle = this.displayBox();
            rectangle.grow(8, 8);
            this.fListener.figureInvalidated(new FigureChangeEvent(this, rectangle));
        }
    }

    public void willChange() {
        this.invalidate();
    }

    public void changed() {
        this.invalidate();
        if (this.fListener != null) {
            this.fListener.figureChanged(new FigureChangeEvent(this));
        }
    }

    public Point center() {
        return Geom.center(this.displayBox());
    }

    public boolean canConnect() {
        return true;
    }

    public Insets connectionInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Connector connectorAt(int n, int n2) {
        return new ChopBoxConnector(this);
    }

    public void connectorVisibility(boolean bl) {
    }

    public Locator connectedTextLocator(Figure figure) {
        return RelativeLocator.center();
    }

    public Object defaultAttribute(String string) {
        return null;
    }

    public Object getAttribute(String string) {
        if (this.fAttributes != null && this.fAttributes.hasDefined(string)) {
            return this.fAttributes.get(string);
        }
        return this.defaultAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set(string, object);
        this.changed();
    }

    public Object clone() {
        Closeable closeable;
        Object object = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(200);
        try {
            closeable = new ObjectOutputStream(byteArrayOutputStream);
            closeable.writeObject(this);
            closeable.close();
        }
        catch (IOException iOException) {
            System.out.println("Class not found: " + iOException);
        }
        closeable = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)closeable);
            object = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found: " + classNotFoundException);
        }
        return object;
    }

    public void write(StorableOutput storableOutput) {
        if (this.fAttributes == null) {
            storableOutput.writeString("no_attributes");
        } else {
            storableOutput.writeString("attributes");
            this.fAttributes.write(storableOutput);
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        if (storableInput.testForNumber()) {
            return;
        }
        String string = storableInput.readString();
        if (string.toLowerCase().equals("attributes")) {
            this.fAttributes = new FigureAttributes();
            this.fAttributes.read(storableInput);
        }
    }

    public abstract /* synthetic */ void draw(Graphics var1, boolean var2);

    public abstract /* synthetic */ String getMap();
}

