/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.jhotdraw.util.LocaleUtil;

public class ResourceBundleUtil
implements Serializable {
    private transient ResourceBundle resource;
    private Locale locale;
    private Class baseClass = this.getClass();
    private String baseName;
    private static boolean isVerbose = false;
    private static HashMap<String, String[]> propertyNameModifiers = new HashMap();

    public ResourceBundleUtil(String string, Locale locale) {
        this.locale = locale;
        this.baseName = string;
        this.resource = ResourceBundle.getBundle(string, locale);
    }

    public ResourceBundle getWrappedBundle() {
        return this.resource;
    }

    public String getString(String string) {
        try {
            String string2 = this.getStringRecursive(string);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            if (isVerbose) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "] \"" + string + "\" not found.");
            }
            return string;
        }
    }

    private String getStringRecursive(String string) throws MissingResourceException {
        int n;
        String string2 = this.resource.getString(string);
        int n2 = string2.indexOf("${");
        while (n2 != -1 && (n = string2.indexOf(125, n2 + 2)) != -1) {
            String string3 = string2.substring(n2 + 2, n);
            ArrayList<String> arrayList = new ArrayList<String>();
            this.generateFallbackKeys(string3, arrayList);
            boolean bl = false;
            for (String string4 : arrayList) {
                try {
                    string2 = string2.substring(0, n2) + this.getStringRecursive(string4) + string2.substring(n + 1);
                    bl = true;
                    break;
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
            if (!bl) {
                throw new MissingResourceException("Resource not found.", this.baseName, string);
            }
            n2 = string2.indexOf("${");
        }
        return string2;
    }

    private void generateFallbackKeys(String string, ArrayList<String> arrayList) {
        int n = string.indexOf("[$");
        if (n == -1) {
            arrayList.add(string);
        } else {
            int n2 = string.indexOf(93, n + 2);
            if (n2 == -1) {
                return;
            }
            String string2 = string.substring(n + 2, n2);
            String[] stringArray = propertyNameModifiers.get(string2);
            if (stringArray == null) {
                stringArray = new String[]{"default"};
            }
            for (String string3 : stringArray) {
                this.generateFallbackKeys(string.substring(0, n) + string3 + string.substring(n2 + 1), arrayList);
            }
        }
    }

    public String getFormatted(String string, Object ... objectArray) {
        return MessageFormat.format(this.getString(string), objectArray);
    }

    public String format(String string, Object ... objectArray) {
        return new Formatter(this.resource.getLocale()).format(this.getString(string), objectArray).toString();
    }

    public Integer getInteger(String string) {
        try {
            return Integer.valueOf(this.getStringRecursive(string));
        }
        catch (MissingResourceException missingResourceException) {
            if (isVerbose) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "] \"" + string + "\" not found.");
            }
            return new Integer(-1);
        }
    }

    public ImageIcon getIconProperty(String string, Class clazz) {
        try {
            String string2 = this.getStringRecursive(string + ".icon");
            if (string2.equals("")) {
                return null;
            }
            URL uRL = clazz.getResource(string2);
            if (isVerbose && uRL == null) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "].getIconProperty \"" + string + ".icon\" resource:" + string2 + " not found.");
            }
            return uRL == null ? null : new ImageIcon(uRL);
        }
        catch (MissingResourceException missingResourceException) {
            if (isVerbose) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "].getIconProperty \"" + string + ".icon\" not found.");
            }
            return null;
        }
    }

    public char getMnemonic(String string) {
        String string2 = this.getStringRecursive(string);
        return string2 == null || string2.length() == 0 ? (char)'\u0000' : string2.charAt(0);
    }

    public char getMnemonicProperty(String string) {
        String string2;
        try {
            string2 = this.getStringRecursive(string + ".mnemonic");
        }
        catch (MissingResourceException missingResourceException) {
            if (isVerbose) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "] \"" + string + ".mnemonic\" not found.");
            }
            string2 = null;
        }
        return string2 == null || string2.length() == 0 ? (char)'\u0000' : string2.charAt(0);
    }

    public String getToolTipTextProperty(String string) {
        try {
            String string2 = this.getStringRecursive(string + ".toolTipText");
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            if (isVerbose) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "] \"" + string + ".toolTipText\" not found.");
            }
            return null;
        }
    }

    public String getTextProperty(String string) {
        try {
            String string2 = this.getStringRecursive(string + ".text");
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            if (isVerbose) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "] \"" + string + ".text\" not found.");
            }
            return null;
        }
    }

    public KeyStroke getKeyStroke(String string) {
        KeyStroke keyStroke = null;
        try {
            String string2 = this.getStringRecursive(string);
            keyStroke = string2 == null ? (KeyStroke)null : KeyStroke.getKeyStroke(string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return keyStroke;
    }

    public KeyStroke getAcceleratorProperty(String string) {
        KeyStroke keyStroke = null;
        try {
            String string2 = this.getStringRecursive(string + ".accelerator");
            keyStroke = string2 == null ? (KeyStroke)null : KeyStroke.getKeyStroke(string2);
        }
        catch (MissingResourceException missingResourceException) {
            if (isVerbose) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "] \"" + string + ".accelerator\" not found.");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return keyStroke;
    }

    public static ResourceBundleUtil getBundle(String string) throws MissingResourceException {
        return ResourceBundleUtil.getBundle(string, LocaleUtil.getDefault());
    }

    public void setBaseClass(Class clazz) {
        this.baseClass = clazz;
    }

    public Class getBaseClass() {
        return this.baseClass;
    }

    public void configureAction(Action action, String string) {
        this.configureAction(action, string, this.getBaseClass());
    }

    public void configureAction(Action action, String string, Class clazz) {
        action.putValue("Name", this.getTextProperty(string));
        String string2 = this.getToolTipTextProperty(string);
        if (string2 != null && string2.length() > 0) {
            action.putValue("ShortDescription", string2);
        }
        action.putValue("AcceleratorKey", this.getAcceleratorProperty(string));
        action.putValue("MnemonicKey", new Integer(this.getMnemonicProperty(string)));
        action.putValue("SmallIcon", this.getIconProperty(string, clazz));
    }

    public void configureButton(AbstractButton abstractButton, String string) {
        this.configureButton(abstractButton, string, this.getBaseClass());
    }

    public void configureButton(AbstractButton abstractButton, String string, Class clazz) {
        abstractButton.setText(this.getTextProperty(string));
        abstractButton.setIcon(this.getIconProperty(string, clazz));
        abstractButton.setToolTipText(this.getToolTipTextProperty(string));
    }

    public void configureToolBarButton(AbstractButton abstractButton, String string) {
        this.configureToolBarButton(abstractButton, string, this.getBaseClass());
    }

    public void configureToolBarButton(AbstractButton abstractButton, String string, Class clazz) {
        ImageIcon imageIcon = this.getIconProperty(string, clazz);
        if (imageIcon != null) {
            abstractButton.setIcon(this.getIconProperty(string, clazz));
            abstractButton.setText(null);
        } else {
            abstractButton.setIcon(null);
            abstractButton.setText(this.getTextProperty(string));
        }
        abstractButton.setToolTipText(this.getToolTipTextProperty(string));
    }

    public void configureMenu(JMenuItem jMenuItem, String string) {
        jMenuItem.setText(this.getTextProperty(string));
        if (!(jMenuItem instanceof JMenu)) {
            jMenuItem.setAccelerator(this.getAcceleratorProperty(string));
        }
        jMenuItem.setMnemonic(this.getMnemonicProperty(string));
        jMenuItem.setIcon(this.getIconProperty(string, this.baseClass));
    }

    public JMenuItem createMenuItem(Action action, String string) {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAction(action);
        this.configureMenu(jMenuItem, string);
        return jMenuItem;
    }

    public static ResourceBundleUtil getBundle(String string, Locale locale) throws MissingResourceException {
        ResourceBundleUtil resourceBundleUtil = new ResourceBundleUtil(string, locale);
        return resourceBundleUtil;
    }

    public String toString() {
        return super.toString() + "[" + this.baseName + ", " + this.resource + "]";
    }

    public static void setVerbose(boolean bl) {
        isVerbose = bl;
    }

    public static boolean isVerbose() {
        return isVerbose;
    }

    public static void putPropertyNameModifier(String string, String ... stringArray) {
        propertyNameModifiers.put(string, stringArray);
    }

    public static void removePropertyNameModifier(String string) {
        propertyNameModifiers.remove(string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.resource = ResourceBundle.getBundle(this.baseName, this.locale);
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = string.startsWith("mac os x") ? "mac" : (string.startsWith("windows") ? "win" : "other");
        propertyNameModifiers.put("os", new String[]{string2, "default"});
    }
}

