/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.xml;

import java.io.IOException;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.xml.XMLWriter;

public class XmlWriterUtil {
    public static final String LS = System.getProperty("line.separator");
    private static final String CRLF = "\r\n";
    public static final int DEFAULT_INDENTATION_SIZE = 2;
    public static final int DEFAULT_COLUMN_LINE = 80;

    public static void writeLineBreak(XMLWriter writer) throws IOException {
        XmlWriterUtil.writeLineBreak(writer, 1);
    }

    public static void writeLineBreak(XMLWriter writer, int repeat) throws IOException {
        for (int i = 0; i < repeat; ++i) {
            writer.writeMarkup(CRLF);
        }
    }

    public static void writeLineBreak(XMLWriter writer, int repeat, int indent) throws IOException {
        XmlWriterUtil.writeLineBreak(writer, repeat, indent, 2);
    }

    public static void writeLineBreak(XMLWriter writer, int repeat, int indent, int indentSize) throws IOException {
        XmlWriterUtil.writeLineBreak(writer, repeat);
        if (indent < 0) {
            indent = 0;
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        writer.writeText(StringUtils.repeat(" ", indent * indentSize));
    }

    public static void writeCommentLineBreak(XMLWriter writer) throws IOException {
        XmlWriterUtil.writeCommentLineBreak(writer, 80);
    }

    public static void writeCommentLineBreak(XMLWriter writer, int columnSize) throws IOException {
        if (columnSize < 10) {
            columnSize = 80;
        }
        writer.writeMarkup("<!-- " + StringUtils.repeat("=", columnSize - 10) + " -->" + CRLF);
    }

    public static void writeComment(XMLWriter writer, String comment) throws IOException {
        XmlWriterUtil.writeComment(writer, comment, 0, 2);
    }

    public static void writeComment(XMLWriter writer, String comment, int indent) throws IOException {
        XmlWriterUtil.writeComment(writer, comment, indent, 2);
    }

    public static void writeComment(XMLWriter writer, String comment, int indent, int indentSize) throws IOException {
        XmlWriterUtil.writeComment(writer, comment, indent, indentSize, 80);
    }

    public static void writeComment(XMLWriter writer, String comment, int indent, int indentSize, int columnSize) throws IOException {
        if (comment == null) {
            comment = "null";
        }
        if (indent < 0) {
            indent = 0;
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        if (columnSize < 0) {
            columnSize = 80;
        }
        String indentation = StringUtils.repeat(" ", indent * indentSize);
        int magicNumber = indentation.length() + columnSize - "-->".length() - 1;
        String[] sentences = StringUtils.split(comment, CRLF);
        StringBuffer line = new StringBuffer(indentation + "<!-- ");
        for (String sentence : sentences) {
            String[] words;
            for (String word : words = StringUtils.split(sentence, " ")) {
                StringBuilder sentenceTmp = new StringBuilder(line.toString());
                sentenceTmp.append(word).append(' ');
                if (sentenceTmp.length() > magicNumber) {
                    if (line.length() != indentation.length() + "<!-- ".length()) {
                        if (magicNumber - line.length() > 0) {
                            line.append(StringUtils.repeat(" ", magicNumber - line.length()));
                        }
                        line.append("-->").append(CRLF);
                        writer.writeMarkup(line.toString());
                    }
                    line = new StringBuffer(indentation + "<!-- ");
                    line.append(word).append(' ');
                    continue;
                }
                line.append(word).append(' ');
            }
            if (magicNumber - line.length() <= 0) continue;
            line.append(StringUtils.repeat(" ", magicNumber - line.length()));
        }
        if (line.length() <= magicNumber) {
            line.append(StringUtils.repeat(" ", magicNumber - line.length()));
        }
        line.append("-->").append(CRLF);
        writer.writeMarkup(line.toString());
    }

    public static void writeCommentText(XMLWriter writer, String comment) throws IOException {
        XmlWriterUtil.writeCommentText(writer, comment, 0, 2);
    }

    public static void writeCommentText(XMLWriter writer, String comment, int indent) throws IOException {
        XmlWriterUtil.writeCommentText(writer, comment, indent, 2);
    }

    public static void writeCommentText(XMLWriter writer, String comment, int indent, int indentSize) throws IOException {
        XmlWriterUtil.writeCommentText(writer, comment, indent, indentSize, 80);
    }

    public static void writeCommentText(XMLWriter writer, String comment, int indent, int indentSize, int columnSize) throws IOException {
        if (indent < 0) {
            indent = 0;
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        if (columnSize < 0) {
            columnSize = 80;
        }
        XmlWriterUtil.writeLineBreak(writer, 1);
        writer.writeMarkup(StringUtils.repeat(" ", indent * indentSize));
        XmlWriterUtil.writeCommentLineBreak(writer, columnSize);
        XmlWriterUtil.writeComment(writer, comment, indent, indentSize, columnSize);
        writer.writeMarkup(StringUtils.repeat(" ", indent * indentSize));
        XmlWriterUtil.writeCommentLineBreak(writer, columnSize);
        XmlWriterUtil.writeLineBreak(writer, 1, indent, indentSize);
    }
}

