/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrUuidMSFT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneComponentsLocateInfoMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BASESPACE;
    public static final int TIME;
    public static final int COMPONENTIDCOUNT;
    public static final int COMPONENTIDS;

    public XrSceneComponentsLocateInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneComponentsLocateInfoMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneComponentsLocateInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSceneComponentsLocateInfoMSFT.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrSceneComponentsLocateInfoMSFT.nbaseSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrSceneComponentsLocateInfoMSFT.ntime(this.address());
    }

    @NativeType(value="uint32_t")
    public int componentIdCount() {
        return XrSceneComponentsLocateInfoMSFT.ncomponentIdCount(this.address());
    }

    @Nullable
    @NativeType(value="XrUuidMSFT const *")
    public XrUuidMSFT.Buffer componentIds() {
        return XrSceneComponentsLocateInfoMSFT.ncomponentIds(this.address());
    }

    public XrSceneComponentsLocateInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneComponentsLocateInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneComponentsLocateInfoMSFT type$Default() {
        return this.type(1000097007);
    }

    public XrSceneComponentsLocateInfoMSFT next(@NativeType(value="void const *") long value) {
        XrSceneComponentsLocateInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneComponentsLocateInfoMSFT baseSpace(XrSpace value) {
        XrSceneComponentsLocateInfoMSFT.nbaseSpace(this.address(), value);
        return this;
    }

    public XrSceneComponentsLocateInfoMSFT time(@NativeType(value="XrTime") long value) {
        XrSceneComponentsLocateInfoMSFT.ntime(this.address(), value);
        return this;
    }

    public XrSceneComponentsLocateInfoMSFT componentIdCount(@NativeType(value="uint32_t") int value) {
        XrSceneComponentsLocateInfoMSFT.ncomponentIdCount(this.address(), value);
        return this;
    }

    public XrSceneComponentsLocateInfoMSFT componentIds(@Nullable @NativeType(value="XrUuidMSFT const *") XrUuidMSFT.Buffer value) {
        XrSceneComponentsLocateInfoMSFT.ncomponentIds(this.address(), value);
        return this;
    }

    public XrSceneComponentsLocateInfoMSFT set(int type, long next, XrSpace baseSpace, long time, int componentIdCount, @Nullable XrUuidMSFT.Buffer componentIds) {
        this.type(type);
        this.next(next);
        this.baseSpace(baseSpace);
        this.time(time);
        this.componentIdCount(componentIdCount);
        this.componentIds(componentIds);
        return this;
    }

    public XrSceneComponentsLocateInfoMSFT set(XrSceneComponentsLocateInfoMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneComponentsLocateInfoMSFT malloc() {
        return (XrSceneComponentsLocateInfoMSFT)XrSceneComponentsLocateInfoMSFT.wrap(XrSceneComponentsLocateInfoMSFT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSceneComponentsLocateInfoMSFT calloc() {
        return (XrSceneComponentsLocateInfoMSFT)XrSceneComponentsLocateInfoMSFT.wrap(XrSceneComponentsLocateInfoMSFT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSceneComponentsLocateInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSceneComponentsLocateInfoMSFT)XrSceneComponentsLocateInfoMSFT.wrap(XrSceneComponentsLocateInfoMSFT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSceneComponentsLocateInfoMSFT create(long address) {
        return (XrSceneComponentsLocateInfoMSFT)XrSceneComponentsLocateInfoMSFT.wrap(XrSceneComponentsLocateInfoMSFT.class, (long)address);
    }

    @Nullable
    public static XrSceneComponentsLocateInfoMSFT createSafe(long address) {
        return address == 0L ? null : (XrSceneComponentsLocateInfoMSFT)XrSceneComponentsLocateInfoMSFT.wrap(XrSceneComponentsLocateInfoMSFT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSceneComponentsLocateInfoMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSceneComponentsLocateInfoMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSceneComponentsLocateInfoMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneComponentsLocateInfoMSFT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSceneComponentsLocateInfoMSFT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSceneComponentsLocateInfoMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSceneComponentsLocateInfoMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSceneComponentsLocateInfoMSFT malloc(MemoryStack stack) {
        return (XrSceneComponentsLocateInfoMSFT)XrSceneComponentsLocateInfoMSFT.wrap(XrSceneComponentsLocateInfoMSFT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneComponentsLocateInfoMSFT calloc(MemoryStack stack) {
        return (XrSceneComponentsLocateInfoMSFT)XrSceneComponentsLocateInfoMSFT.wrap(XrSceneComponentsLocateInfoMSFT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneComponentsLocateInfoMSFT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneComponentsLocateInfoMSFT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BASESPACE));
    }

    public static long ntime(long struct) {
        return UNSAFE.getLong(null, struct + (long)TIME);
    }

    public static int ncomponentIdCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPONENTIDCOUNT);
    }

    @Nullable
    public static XrUuidMSFT.Buffer ncomponentIds(long struct) {
        return XrUuidMSFT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)COMPONENTIDS)), XrSceneComponentsLocateInfoMSFT.ncomponentIdCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BASESPACE), (long)value.address());
    }

    public static void ntime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)TIME, value);
    }

    public static void ncomponentIdCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMPONENTIDCOUNT, value);
    }

    public static void ncomponentIds(long struct, @Nullable XrUuidMSFT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)COMPONENTIDS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrSceneComponentsLocateInfoMSFT.ncomponentIdCount(struct, value.remaining());
        }
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BASESPACE)));
    }

    static {
        Struct.Layout layout = XrSceneComponentsLocateInfoMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneComponentsLocateInfoMSFT.__member((int)4), XrSceneComponentsLocateInfoMSFT.__member((int)POINTER_SIZE), XrSceneComponentsLocateInfoMSFT.__member((int)POINTER_SIZE), XrSceneComponentsLocateInfoMSFT.__member((int)8), XrSceneComponentsLocateInfoMSFT.__member((int)4), XrSceneComponentsLocateInfoMSFT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BASESPACE = layout.offsetof(2);
        TIME = layout.offsetof(3);
        COMPONENTIDCOUNT = layout.offsetof(4);
        COMPONENTIDS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrSceneComponentsLocateInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneComponentsLocateInfoMSFT ELEMENT_FACTORY = XrSceneComponentsLocateInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneComponentsLocateInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneComponentsLocateInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSceneComponentsLocateInfoMSFT.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrSceneComponentsLocateInfoMSFT.nbaseSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrSceneComponentsLocateInfoMSFT.ntime(this.address());
        }

        @NativeType(value="uint32_t")
        public int componentIdCount() {
            return XrSceneComponentsLocateInfoMSFT.ncomponentIdCount(this.address());
        }

        @Nullable
        @NativeType(value="XrUuidMSFT const *")
        public XrUuidMSFT.Buffer componentIds() {
            return XrSceneComponentsLocateInfoMSFT.ncomponentIds(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneComponentsLocateInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097007);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSceneComponentsLocateInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrSceneComponentsLocateInfoMSFT.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrSceneComponentsLocateInfoMSFT.ntime(this.address(), value);
            return this;
        }

        public Buffer componentIdCount(@NativeType(value="uint32_t") int value) {
            XrSceneComponentsLocateInfoMSFT.ncomponentIdCount(this.address(), value);
            return this;
        }

        public Buffer componentIds(@Nullable @NativeType(value="XrUuidMSFT const *") XrUuidMSFT.Buffer value) {
            XrSceneComponentsLocateInfoMSFT.ncomponentIds(this.address(), value);
            return this;
        }
    }
}

