/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSceneFrustumBoundMSFT;
import org.lwjgl.openxr.XrSceneOrientedBoxBoundMSFT;
import org.lwjgl.openxr.XrSceneSphereBoundMSFT;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneBoundsMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SPACE;
    public static final int TIME;
    public static final int SPHERECOUNT;
    public static final int SPHERES;
    public static final int BOXCOUNT;
    public static final int BOXES;
    public static final int FRUSTUMCOUNT;
    public static final int FRUSTUMS;

    public XrSceneBoundsMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneBoundsMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrSceneBoundsMSFT.nspace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrSceneBoundsMSFT.ntime(this.address());
    }

    @NativeType(value="uint32_t")
    public int sphereCount() {
        return XrSceneBoundsMSFT.nsphereCount(this.address());
    }

    @Nullable
    @NativeType(value="XrSceneSphereBoundMSFT const *")
    public XrSceneSphereBoundMSFT.Buffer spheres() {
        return XrSceneBoundsMSFT.nspheres(this.address());
    }

    @NativeType(value="uint32_t")
    public int boxCount() {
        return XrSceneBoundsMSFT.nboxCount(this.address());
    }

    @Nullable
    @NativeType(value="XrSceneOrientedBoxBoundMSFT const *")
    public XrSceneOrientedBoxBoundMSFT.Buffer boxes() {
        return XrSceneBoundsMSFT.nboxes(this.address());
    }

    @NativeType(value="uint32_t")
    public int frustumCount() {
        return XrSceneBoundsMSFT.nfrustumCount(this.address());
    }

    @Nullable
    @NativeType(value="XrSceneFrustumBoundMSFT const *")
    public XrSceneFrustumBoundMSFT.Buffer frustums() {
        return XrSceneBoundsMSFT.nfrustums(this.address());
    }

    public XrSceneBoundsMSFT space(XrSpace value) {
        XrSceneBoundsMSFT.nspace(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT time(@NativeType(value="XrTime") long value) {
        XrSceneBoundsMSFT.ntime(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT sphereCount(@NativeType(value="uint32_t") int value) {
        XrSceneBoundsMSFT.nsphereCount(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT spheres(@Nullable @NativeType(value="XrSceneSphereBoundMSFT const *") XrSceneSphereBoundMSFT.Buffer value) {
        XrSceneBoundsMSFT.nspheres(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT boxCount(@NativeType(value="uint32_t") int value) {
        XrSceneBoundsMSFT.nboxCount(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT boxes(@Nullable @NativeType(value="XrSceneOrientedBoxBoundMSFT const *") XrSceneOrientedBoxBoundMSFT.Buffer value) {
        XrSceneBoundsMSFT.nboxes(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT frustumCount(@NativeType(value="uint32_t") int value) {
        XrSceneBoundsMSFT.nfrustumCount(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT frustums(@Nullable @NativeType(value="XrSceneFrustumBoundMSFT const *") XrSceneFrustumBoundMSFT.Buffer value) {
        XrSceneBoundsMSFT.nfrustums(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT set(XrSpace space, long time, int sphereCount, @Nullable XrSceneSphereBoundMSFT.Buffer spheres, int boxCount, @Nullable XrSceneOrientedBoxBoundMSFT.Buffer boxes, int frustumCount, @Nullable XrSceneFrustumBoundMSFT.Buffer frustums) {
        this.space(space);
        this.time(time);
        this.sphereCount(sphereCount);
        this.spheres(spheres);
        this.boxCount(boxCount);
        this.boxes(boxes);
        this.frustumCount(frustumCount);
        this.frustums(frustums);
        return this;
    }

    public XrSceneBoundsMSFT set(XrSceneBoundsMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneBoundsMSFT malloc() {
        return (XrSceneBoundsMSFT)XrSceneBoundsMSFT.wrap(XrSceneBoundsMSFT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSceneBoundsMSFT calloc() {
        return (XrSceneBoundsMSFT)XrSceneBoundsMSFT.wrap(XrSceneBoundsMSFT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSceneBoundsMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSceneBoundsMSFT)XrSceneBoundsMSFT.wrap(XrSceneBoundsMSFT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSceneBoundsMSFT create(long address) {
        return (XrSceneBoundsMSFT)XrSceneBoundsMSFT.wrap(XrSceneBoundsMSFT.class, (long)address);
    }

    @Nullable
    public static XrSceneBoundsMSFT createSafe(long address) {
        return address == 0L ? null : (XrSceneBoundsMSFT)XrSceneBoundsMSFT.wrap(XrSceneBoundsMSFT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSceneBoundsMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSceneBoundsMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSceneBoundsMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneBoundsMSFT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSceneBoundsMSFT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSceneBoundsMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSceneBoundsMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSceneBoundsMSFT malloc(MemoryStack stack) {
        return (XrSceneBoundsMSFT)XrSceneBoundsMSFT.wrap(XrSceneBoundsMSFT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneBoundsMSFT calloc(MemoryStack stack) {
        return (XrSceneBoundsMSFT)XrSceneBoundsMSFT.wrap(XrSceneBoundsMSFT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneBoundsMSFT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneBoundsMSFT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPACE));
    }

    public static long ntime(long struct) {
        return UNSAFE.getLong(null, struct + (long)TIME);
    }

    public static int nsphereCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SPHERECOUNT);
    }

    @Nullable
    public static XrSceneSphereBoundMSFT.Buffer nspheres(long struct) {
        return XrSceneSphereBoundMSFT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)SPHERES)), XrSceneBoundsMSFT.nsphereCount(struct));
    }

    public static int nboxCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)BOXCOUNT);
    }

    @Nullable
    public static XrSceneOrientedBoxBoundMSFT.Buffer nboxes(long struct) {
        return XrSceneOrientedBoxBoundMSFT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)BOXES)), XrSceneBoundsMSFT.nboxCount(struct));
    }

    public static int nfrustumCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRUSTUMCOUNT);
    }

    @Nullable
    public static XrSceneFrustumBoundMSFT.Buffer nfrustums(long struct) {
        return XrSceneFrustumBoundMSFT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)FRUSTUMS)), XrSceneBoundsMSFT.nfrustumCount(struct));
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE), (long)value.address());
    }

    public static void ntime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)TIME, value);
    }

    public static void nsphereCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SPHERECOUNT, value);
    }

    public static void nspheres(long struct, @Nullable XrSceneSphereBoundMSFT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPHERES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrSceneBoundsMSFT.nsphereCount(struct, value.remaining());
        }
    }

    public static void nboxCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BOXCOUNT, value);
    }

    public static void nboxes(long struct, @Nullable XrSceneOrientedBoxBoundMSFT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BOXES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrSceneBoundsMSFT.nboxCount(struct, value.remaining());
        }
    }

    public static void nfrustumCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRUSTUMCOUNT, value);
    }

    public static void nfrustums(long struct, @Nullable XrSceneFrustumBoundMSFT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FRUSTUMS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrSceneBoundsMSFT.nfrustumCount(struct, value.remaining());
        }
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACE)));
    }

    static {
        Struct.Layout layout = XrSceneBoundsMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneBoundsMSFT.__member((int)POINTER_SIZE), XrSceneBoundsMSFT.__member((int)8), XrSceneBoundsMSFT.__member((int)4), XrSceneBoundsMSFT.__member((int)POINTER_SIZE), XrSceneBoundsMSFT.__member((int)4), XrSceneBoundsMSFT.__member((int)POINTER_SIZE), XrSceneBoundsMSFT.__member((int)4), XrSceneBoundsMSFT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SPACE = layout.offsetof(0);
        TIME = layout.offsetof(1);
        SPHERECOUNT = layout.offsetof(2);
        SPHERES = layout.offsetof(3);
        BOXCOUNT = layout.offsetof(4);
        BOXES = layout.offsetof(5);
        FRUSTUMCOUNT = layout.offsetof(6);
        FRUSTUMS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrSceneBoundsMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneBoundsMSFT ELEMENT_FACTORY = XrSceneBoundsMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneBoundsMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrSceneBoundsMSFT.nspace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrSceneBoundsMSFT.ntime(this.address());
        }

        @NativeType(value="uint32_t")
        public int sphereCount() {
            return XrSceneBoundsMSFT.nsphereCount(this.address());
        }

        @Nullable
        @NativeType(value="XrSceneSphereBoundMSFT const *")
        public XrSceneSphereBoundMSFT.Buffer spheres() {
            return XrSceneBoundsMSFT.nspheres(this.address());
        }

        @NativeType(value="uint32_t")
        public int boxCount() {
            return XrSceneBoundsMSFT.nboxCount(this.address());
        }

        @Nullable
        @NativeType(value="XrSceneOrientedBoxBoundMSFT const *")
        public XrSceneOrientedBoxBoundMSFT.Buffer boxes() {
            return XrSceneBoundsMSFT.nboxes(this.address());
        }

        @NativeType(value="uint32_t")
        public int frustumCount() {
            return XrSceneBoundsMSFT.nfrustumCount(this.address());
        }

        @Nullable
        @NativeType(value="XrSceneFrustumBoundMSFT const *")
        public XrSceneFrustumBoundMSFT.Buffer frustums() {
            return XrSceneBoundsMSFT.nfrustums(this.address());
        }

        public Buffer space(XrSpace value) {
            XrSceneBoundsMSFT.nspace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrSceneBoundsMSFT.ntime(this.address(), value);
            return this;
        }

        public Buffer sphereCount(@NativeType(value="uint32_t") int value) {
            XrSceneBoundsMSFT.nsphereCount(this.address(), value);
            return this;
        }

        public Buffer spheres(@Nullable @NativeType(value="XrSceneSphereBoundMSFT const *") XrSceneSphereBoundMSFT.Buffer value) {
            XrSceneBoundsMSFT.nspheres(this.address(), value);
            return this;
        }

        public Buffer boxCount(@NativeType(value="uint32_t") int value) {
            XrSceneBoundsMSFT.nboxCount(this.address(), value);
            return this;
        }

        public Buffer boxes(@Nullable @NativeType(value="XrSceneOrientedBoxBoundMSFT const *") XrSceneOrientedBoxBoundMSFT.Buffer value) {
            XrSceneBoundsMSFT.nboxes(this.address(), value);
            return this;
        }

        public Buffer frustumCount(@NativeType(value="uint32_t") int value) {
            XrSceneBoundsMSFT.nfrustumCount(this.address(), value);
            return this;
        }

        public Buffer frustums(@Nullable @NativeType(value="XrSceneFrustumBoundMSFT const *") XrSceneFrustumBoundMSFT.Buffer value) {
            XrSceneBoundsMSFT.nfrustums(this.address(), value);
            return this;
        }
    }
}

