/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGraphicsBindingOpenGLWaylandKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int DISPLAY;

    public XrGraphicsBindingOpenGLWaylandKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrGraphicsBindingOpenGLWaylandKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGraphicsBindingOpenGLWaylandKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrGraphicsBindingOpenGLWaylandKHR.nnext(this.address());
    }

    @NativeType(value="struct wl_display *")
    public long display() {
        return XrGraphicsBindingOpenGLWaylandKHR.ndisplay(this.address());
    }

    public XrGraphicsBindingOpenGLWaylandKHR type(@NativeType(value="XrStructureType") int value) {
        XrGraphicsBindingOpenGLWaylandKHR.ntype(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLWaylandKHR type$Default() {
        return this.type(1000023003);
    }

    public XrGraphicsBindingOpenGLWaylandKHR next(@NativeType(value="void const *") long value) {
        XrGraphicsBindingOpenGLWaylandKHR.nnext(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLWaylandKHR display(@NativeType(value="struct wl_display *") long value) {
        XrGraphicsBindingOpenGLWaylandKHR.ndisplay(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLWaylandKHR set(int type, long next, long display) {
        this.type(type);
        this.next(next);
        this.display(display);
        return this;
    }

    public XrGraphicsBindingOpenGLWaylandKHR set(XrGraphicsBindingOpenGLWaylandKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrGraphicsBindingOpenGLWaylandKHR malloc() {
        return (XrGraphicsBindingOpenGLWaylandKHR)XrGraphicsBindingOpenGLWaylandKHR.wrap(XrGraphicsBindingOpenGLWaylandKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrGraphicsBindingOpenGLWaylandKHR calloc() {
        return (XrGraphicsBindingOpenGLWaylandKHR)XrGraphicsBindingOpenGLWaylandKHR.wrap(XrGraphicsBindingOpenGLWaylandKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrGraphicsBindingOpenGLWaylandKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrGraphicsBindingOpenGLWaylandKHR)XrGraphicsBindingOpenGLWaylandKHR.wrap(XrGraphicsBindingOpenGLWaylandKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrGraphicsBindingOpenGLWaylandKHR create(long address) {
        return (XrGraphicsBindingOpenGLWaylandKHR)XrGraphicsBindingOpenGLWaylandKHR.wrap(XrGraphicsBindingOpenGLWaylandKHR.class, (long)address);
    }

    @Nullable
    public static XrGraphicsBindingOpenGLWaylandKHR createSafe(long address) {
        return address == 0L ? null : (XrGraphicsBindingOpenGLWaylandKHR)XrGraphicsBindingOpenGLWaylandKHR.wrap(XrGraphicsBindingOpenGLWaylandKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrGraphicsBindingOpenGLWaylandKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrGraphicsBindingOpenGLWaylandKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrGraphicsBindingOpenGLWaylandKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGraphicsBindingOpenGLWaylandKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrGraphicsBindingOpenGLWaylandKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrGraphicsBindingOpenGLWaylandKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrGraphicsBindingOpenGLWaylandKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrGraphicsBindingOpenGLWaylandKHR malloc(MemoryStack stack) {
        return (XrGraphicsBindingOpenGLWaylandKHR)XrGraphicsBindingOpenGLWaylandKHR.wrap(XrGraphicsBindingOpenGLWaylandKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrGraphicsBindingOpenGLWaylandKHR calloc(MemoryStack stack) {
        return (XrGraphicsBindingOpenGLWaylandKHR)XrGraphicsBindingOpenGLWaylandKHR.wrap(XrGraphicsBindingOpenGLWaylandKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrGraphicsBindingOpenGLWaylandKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrGraphicsBindingOpenGLWaylandKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long ndisplay(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DISPLAY));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ndisplay(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DISPLAY), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DISPLAY)));
    }

    static {
        Struct.Layout layout = XrGraphicsBindingOpenGLWaylandKHR.__struct((Struct.Member[])new Struct.Member[]{XrGraphicsBindingOpenGLWaylandKHR.__member((int)4), XrGraphicsBindingOpenGLWaylandKHR.__member((int)POINTER_SIZE), XrGraphicsBindingOpenGLWaylandKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        DISPLAY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrGraphicsBindingOpenGLWaylandKHR, Buffer>
    implements NativeResource {
        private static final XrGraphicsBindingOpenGLWaylandKHR ELEMENT_FACTORY = XrGraphicsBindingOpenGLWaylandKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrGraphicsBindingOpenGLWaylandKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGraphicsBindingOpenGLWaylandKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrGraphicsBindingOpenGLWaylandKHR.nnext(this.address());
        }

        @NativeType(value="struct wl_display *")
        public long display() {
            return XrGraphicsBindingOpenGLWaylandKHR.ndisplay(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGraphicsBindingOpenGLWaylandKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000023003);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrGraphicsBindingOpenGLWaylandKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer display(@NativeType(value="struct wl_display *") long value) {
            XrGraphicsBindingOpenGLWaylandKHR.ndisplay(this.address(), value);
            return this;
        }
    }
}

