/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSampleLocationsInfoEXT;

public class VkSubpassSampleLocationsEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SUBPASSINDEX;
    public static final int SAMPLELOCATIONSINFO;

    public VkSubpassSampleLocationsEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSubpassSampleLocationsEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int subpassIndex() {
        return VkSubpassSampleLocationsEXT.nsubpassIndex(this.address());
    }

    public VkSampleLocationsInfoEXT sampleLocationsInfo() {
        return VkSubpassSampleLocationsEXT.nsampleLocationsInfo(this.address());
    }

    public VkSubpassSampleLocationsEXT subpassIndex(@NativeType(value="uint32_t") int value) {
        VkSubpassSampleLocationsEXT.nsubpassIndex(this.address(), value);
        return this;
    }

    public VkSubpassSampleLocationsEXT sampleLocationsInfo(VkSampleLocationsInfoEXT value) {
        VkSubpassSampleLocationsEXT.nsampleLocationsInfo(this.address(), value);
        return this;
    }

    public VkSubpassSampleLocationsEXT sampleLocationsInfo(Consumer<VkSampleLocationsInfoEXT> consumer) {
        consumer.accept(this.sampleLocationsInfo());
        return this;
    }

    public VkSubpassSampleLocationsEXT set(int subpassIndex, VkSampleLocationsInfoEXT sampleLocationsInfo) {
        this.subpassIndex(subpassIndex);
        this.sampleLocationsInfo(sampleLocationsInfo);
        return this;
    }

    public VkSubpassSampleLocationsEXT set(VkSubpassSampleLocationsEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSubpassSampleLocationsEXT malloc() {
        return (VkSubpassSampleLocationsEXT)VkSubpassSampleLocationsEXT.wrap(VkSubpassSampleLocationsEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSubpassSampleLocationsEXT calloc() {
        return (VkSubpassSampleLocationsEXT)VkSubpassSampleLocationsEXT.wrap(VkSubpassSampleLocationsEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSubpassSampleLocationsEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSubpassSampleLocationsEXT)VkSubpassSampleLocationsEXT.wrap(VkSubpassSampleLocationsEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSubpassSampleLocationsEXT create(long address) {
        return (VkSubpassSampleLocationsEXT)VkSubpassSampleLocationsEXT.wrap(VkSubpassSampleLocationsEXT.class, (long)address);
    }

    @Nullable
    public static VkSubpassSampleLocationsEXT createSafe(long address) {
        return address == 0L ? null : (VkSubpassSampleLocationsEXT)VkSubpassSampleLocationsEXT.wrap(VkSubpassSampleLocationsEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSubpassSampleLocationsEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSubpassSampleLocationsEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSubpassSampleLocationsEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubpassSampleLocationsEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSubpassSampleLocationsEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSubpassSampleLocationsEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSubpassSampleLocationsEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkSubpassSampleLocationsEXT mallocStack() {
        return VkSubpassSampleLocationsEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubpassSampleLocationsEXT callocStack() {
        return VkSubpassSampleLocationsEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubpassSampleLocationsEXT mallocStack(MemoryStack stack) {
        return VkSubpassSampleLocationsEXT.malloc(stack);
    }

    @Deprecated
    public static VkSubpassSampleLocationsEXT callocStack(MemoryStack stack) {
        return VkSubpassSampleLocationsEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSubpassSampleLocationsEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSubpassSampleLocationsEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubpassSampleLocationsEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubpassSampleLocationsEXT.calloc(capacity, stack);
    }

    public static VkSubpassSampleLocationsEXT malloc(MemoryStack stack) {
        return (VkSubpassSampleLocationsEXT)VkSubpassSampleLocationsEXT.wrap(VkSubpassSampleLocationsEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassSampleLocationsEXT calloc(MemoryStack stack) {
        return (VkSubpassSampleLocationsEXT)VkSubpassSampleLocationsEXT.wrap(VkSubpassSampleLocationsEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkSubpassSampleLocationsEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkSubpassSampleLocationsEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsubpassIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBPASSINDEX);
    }

    public static VkSampleLocationsInfoEXT nsampleLocationsInfo(long struct) {
        return VkSampleLocationsInfoEXT.create(struct + (long)SAMPLELOCATIONSINFO);
    }

    public static void nsubpassIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBPASSINDEX, value);
    }

    public static void nsampleLocationsInfo(long struct, VkSampleLocationsInfoEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SAMPLELOCATIONSINFO), (long)VkSampleLocationsInfoEXT.SIZEOF);
    }

    public static void validate(long struct) {
        VkSampleLocationsInfoEXT.validate(struct + (long)SAMPLELOCATIONSINFO);
    }

    static {
        Struct.Layout layout = VkSubpassSampleLocationsEXT.__struct((Struct.Member[])new Struct.Member[]{VkSubpassSampleLocationsEXT.__member((int)4), VkSubpassSampleLocationsEXT.__member((int)VkSampleLocationsInfoEXT.SIZEOF, (int)VkSampleLocationsInfoEXT.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SUBPASSINDEX = layout.offsetof(0);
        SAMPLELOCATIONSINFO = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassSampleLocationsEXT, Buffer>
    implements NativeResource {
        private static final VkSubpassSampleLocationsEXT ELEMENT_FACTORY = VkSubpassSampleLocationsEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSubpassSampleLocationsEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int subpassIndex() {
            return VkSubpassSampleLocationsEXT.nsubpassIndex(this.address());
        }

        public VkSampleLocationsInfoEXT sampleLocationsInfo() {
            return VkSubpassSampleLocationsEXT.nsampleLocationsInfo(this.address());
        }

        public Buffer subpassIndex(@NativeType(value="uint32_t") int value) {
            VkSubpassSampleLocationsEXT.nsubpassIndex(this.address(), value);
            return this;
        }

        public Buffer sampleLocationsInfo(VkSampleLocationsInfoEXT value) {
            VkSubpassSampleLocationsEXT.nsampleLocationsInfo(this.address(), value);
            return this;
        }

        public Buffer sampleLocationsInfo(Consumer<VkSampleLocationsInfoEXT> consumer) {
            consumer.accept(this.sampleLocationsInfo());
            return this;
        }
    }
}

