/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkConformanceVersion;

public class VkConformanceVersionKHR
extends VkConformanceVersion {
    public VkConformanceVersionKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkConformanceVersionKHR major(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersionKHR.nmajor(this.address(), value);
        return this;
    }

    @Override
    public VkConformanceVersionKHR minor(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersionKHR.nminor(this.address(), value);
        return this;
    }

    @Override
    public VkConformanceVersionKHR subminor(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersionKHR.nsubminor(this.address(), value);
        return this;
    }

    @Override
    public VkConformanceVersionKHR patch(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersionKHR.npatch(this.address(), value);
        return this;
    }

    @Override
    public VkConformanceVersionKHR set(byte major, byte minor, byte subminor, byte patch) {
        this.major(major);
        this.minor(minor);
        this.subminor(subminor);
        this.patch(patch);
        return this;
    }

    public VkConformanceVersionKHR set(VkConformanceVersionKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkConformanceVersionKHR malloc() {
        return (VkConformanceVersionKHR)VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkConformanceVersionKHR calloc() {
        return (VkConformanceVersionKHR)VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkConformanceVersionKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkConformanceVersionKHR)VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkConformanceVersionKHR create(long address) {
        return (VkConformanceVersionKHR)VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, (long)address);
    }

    @Nullable
    public static VkConformanceVersionKHR createSafe(long address) {
        return address == 0L ? null : (VkConformanceVersionKHR)VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkConformanceVersionKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkConformanceVersionKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkConformanceVersionKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkConformanceVersionKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkConformanceVersionKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkConformanceVersionKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkConformanceVersionKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkConformanceVersionKHR mallocStack() {
        return VkConformanceVersionKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkConformanceVersionKHR callocStack() {
        return VkConformanceVersionKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkConformanceVersionKHR mallocStack(MemoryStack stack) {
        return VkConformanceVersionKHR.malloc(stack);
    }

    @Deprecated
    public static VkConformanceVersionKHR callocStack(MemoryStack stack) {
        return VkConformanceVersionKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkConformanceVersionKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkConformanceVersionKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkConformanceVersionKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkConformanceVersionKHR.calloc(capacity, stack);
    }

    public static VkConformanceVersionKHR malloc(MemoryStack stack) {
        return (VkConformanceVersionKHR)VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkConformanceVersionKHR calloc(MemoryStack stack) {
        return (VkConformanceVersionKHR)VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkConformanceVersionKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkConformanceVersionKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkConformanceVersion.Buffer {
        private static final VkConformanceVersionKHR ELEMENT_FACTORY = VkConformanceVersionKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkConformanceVersionKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer major(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersionKHR.nmajor(this.address(), value);
            return this;
        }

        @Override
        public Buffer minor(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersionKHR.nminor(this.address(), value);
            return this;
        }

        @Override
        public Buffer subminor(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersionKHR.nsubminor(this.address(), value);
            return this;
        }

        @Override
        public Buffer patch(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersionKHR.npatch(this.address(), value);
            return this;
        }
    }
}

