/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindVertexBufferIndirectCommandNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFERADDRESS;
    public static final int SIZE;
    public static final int STRIDE;

    public VkBindVertexBufferIndirectCommandNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBindVertexBufferIndirectCommandNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long bufferAddress() {
        return VkBindVertexBufferIndirectCommandNV.nbufferAddress(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return VkBindVertexBufferIndirectCommandNV.nsize(this.address());
    }

    @NativeType(value="uint32_t")
    public int stride() {
        return VkBindVertexBufferIndirectCommandNV.nstride(this.address());
    }

    public VkBindVertexBufferIndirectCommandNV bufferAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkBindVertexBufferIndirectCommandNV.nbufferAddress(this.address(), value);
        return this;
    }

    public VkBindVertexBufferIndirectCommandNV size(@NativeType(value="uint32_t") int value) {
        VkBindVertexBufferIndirectCommandNV.nsize(this.address(), value);
        return this;
    }

    public VkBindVertexBufferIndirectCommandNV stride(@NativeType(value="uint32_t") int value) {
        VkBindVertexBufferIndirectCommandNV.nstride(this.address(), value);
        return this;
    }

    public VkBindVertexBufferIndirectCommandNV set(long bufferAddress, int size, int stride) {
        this.bufferAddress(bufferAddress);
        this.size(size);
        this.stride(stride);
        return this;
    }

    public VkBindVertexBufferIndirectCommandNV set(VkBindVertexBufferIndirectCommandNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBindVertexBufferIndirectCommandNV malloc() {
        return (VkBindVertexBufferIndirectCommandNV)VkBindVertexBufferIndirectCommandNV.wrap(VkBindVertexBufferIndirectCommandNV.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBindVertexBufferIndirectCommandNV calloc() {
        return (VkBindVertexBufferIndirectCommandNV)VkBindVertexBufferIndirectCommandNV.wrap(VkBindVertexBufferIndirectCommandNV.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBindVertexBufferIndirectCommandNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBindVertexBufferIndirectCommandNV)VkBindVertexBufferIndirectCommandNV.wrap(VkBindVertexBufferIndirectCommandNV.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBindVertexBufferIndirectCommandNV create(long address) {
        return (VkBindVertexBufferIndirectCommandNV)VkBindVertexBufferIndirectCommandNV.wrap(VkBindVertexBufferIndirectCommandNV.class, (long)address);
    }

    @Nullable
    public static VkBindVertexBufferIndirectCommandNV createSafe(long address) {
        return address == 0L ? null : (VkBindVertexBufferIndirectCommandNV)VkBindVertexBufferIndirectCommandNV.wrap(VkBindVertexBufferIndirectCommandNV.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBindVertexBufferIndirectCommandNV.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBindVertexBufferIndirectCommandNV.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBindVertexBufferIndirectCommandNV.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindVertexBufferIndirectCommandNV.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBindVertexBufferIndirectCommandNV.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBindVertexBufferIndirectCommandNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBindVertexBufferIndirectCommandNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkBindVertexBufferIndirectCommandNV malloc(MemoryStack stack) {
        return (VkBindVertexBufferIndirectCommandNV)VkBindVertexBufferIndirectCommandNV.wrap(VkBindVertexBufferIndirectCommandNV.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindVertexBufferIndirectCommandNV calloc(MemoryStack stack) {
        return (VkBindVertexBufferIndirectCommandNV)VkBindVertexBufferIndirectCommandNV.wrap(VkBindVertexBufferIndirectCommandNV.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkBindVertexBufferIndirectCommandNV.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkBindVertexBufferIndirectCommandNV.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nbufferAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFERADDRESS);
    }

    public static int nsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIZE);
    }

    public static int nstride(long struct) {
        return UNSAFE.getInt(null, struct + (long)STRIDE);
    }

    public static void nbufferAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFERADDRESS, value);
    }

    public static void nsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIZE, value);
    }

    public static void nstride(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STRIDE, value);
    }

    static {
        Struct.Layout layout = VkBindVertexBufferIndirectCommandNV.__struct((Struct.Member[])new Struct.Member[]{VkBindVertexBufferIndirectCommandNV.__member((int)8), VkBindVertexBufferIndirectCommandNV.__member((int)4), VkBindVertexBufferIndirectCommandNV.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFERADDRESS = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        STRIDE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBindVertexBufferIndirectCommandNV, Buffer>
    implements NativeResource {
        private static final VkBindVertexBufferIndirectCommandNV ELEMENT_FACTORY = VkBindVertexBufferIndirectCommandNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBindVertexBufferIndirectCommandNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long bufferAddress() {
            return VkBindVertexBufferIndirectCommandNV.nbufferAddress(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return VkBindVertexBufferIndirectCommandNV.nsize(this.address());
        }

        @NativeType(value="uint32_t")
        public int stride() {
            return VkBindVertexBufferIndirectCommandNV.nstride(this.address());
        }

        public Buffer bufferAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkBindVertexBufferIndirectCommandNV.nbufferAddress(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="uint32_t") int value) {
            VkBindVertexBufferIndirectCommandNV.nsize(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="uint32_t") int value) {
            VkBindVertexBufferIndirectCommandNV.nstride(this.address(), value);
            return this;
        }
    }
}

