/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkStyleButton;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_window_header")
public class NkStyleWindowHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int CLOSE_BUTTON;
    public static final int MINIMIZE_BUTTON;
    public static final int CLOSE_SYMBOL;
    public static final int MINIMIZE_SYMBOL;
    public static final int MAXIMIZE_SYMBOL;
    public static final int LABEL_NORMAL;
    public static final int LABEL_HOVER;
    public static final int LABEL_ACTIVE;
    public static final int ALIGN;
    public static final int PADDING;
    public static final int LABEL_PADDING;
    public static final int SPACING;

    public NkStyleWindowHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkStyleWindowHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem normal() {
        return NkStyleWindowHeader.nnormal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem hover() {
        return NkStyleWindowHeader.nhover(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem active() {
        return NkStyleWindowHeader.nactive(this.address());
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton close_button() {
        return NkStyleWindowHeader.nclose_button(this.address());
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton minimize_button() {
        return NkStyleWindowHeader.nminimize_button(this.address());
    }

    @NativeType(value="enum nk_symbol_type")
    public int close_symbol() {
        return NkStyleWindowHeader.nclose_symbol(this.address());
    }

    @NativeType(value="enum nk_symbol_type")
    public int minimize_symbol() {
        return NkStyleWindowHeader.nminimize_symbol(this.address());
    }

    @NativeType(value="enum nk_symbol_type")
    public int maximize_symbol() {
        return NkStyleWindowHeader.nmaximize_symbol(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor label_normal() {
        return NkStyleWindowHeader.nlabel_normal(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor label_hover() {
        return NkStyleWindowHeader.nlabel_hover(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor label_active() {
        return NkStyleWindowHeader.nlabel_active(this.address());
    }

    @NativeType(value="enum nk_style_header_align")
    public int align() {
        return NkStyleWindowHeader.nalign(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleWindowHeader.npadding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 label_padding() {
        return NkStyleWindowHeader.nlabel_padding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 spacing() {
        return NkStyleWindowHeader.nspacing(this.address());
    }

    public NkStyleWindowHeader normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleWindowHeader.nnormal(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.normal());
        return this;
    }

    public NkStyleWindowHeader hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleWindowHeader.nhover(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.hover());
        return this;
    }

    public NkStyleWindowHeader active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleWindowHeader.nactive(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader active(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.active());
        return this;
    }

    public NkStyleWindowHeader close_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyleWindowHeader.nclose_button(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader close_button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.close_button());
        return this;
    }

    public NkStyleWindowHeader minimize_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyleWindowHeader.nminimize_button(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader minimize_button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.minimize_button());
        return this;
    }

    public NkStyleWindowHeader close_symbol(@NativeType(value="enum nk_symbol_type") int value) {
        NkStyleWindowHeader.nclose_symbol(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader minimize_symbol(@NativeType(value="enum nk_symbol_type") int value) {
        NkStyleWindowHeader.nminimize_symbol(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader maximize_symbol(@NativeType(value="enum nk_symbol_type") int value) {
        NkStyleWindowHeader.nmaximize_symbol(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader label_normal(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleWindowHeader.nlabel_normal(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader label_normal(Consumer<NkColor> consumer) {
        consumer.accept(this.label_normal());
        return this;
    }

    public NkStyleWindowHeader label_hover(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleWindowHeader.nlabel_hover(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader label_hover(Consumer<NkColor> consumer) {
        consumer.accept(this.label_hover());
        return this;
    }

    public NkStyleWindowHeader label_active(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleWindowHeader.nlabel_active(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader label_active(Consumer<NkColor> consumer) {
        consumer.accept(this.label_active());
        return this;
    }

    public NkStyleWindowHeader align(@NativeType(value="enum nk_style_header_align") int value) {
        NkStyleWindowHeader.nalign(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleWindowHeader.npadding(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleWindowHeader label_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleWindowHeader.nlabel_padding(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader label_padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.label_padding());
        return this;
    }

    public NkStyleWindowHeader spacing(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleWindowHeader.nspacing(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader spacing(Consumer<NkVec2> consumer) {
        consumer.accept(this.spacing());
        return this;
    }

    public NkStyleWindowHeader set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkStyleButton close_button, NkStyleButton minimize_button, int close_symbol, int minimize_symbol, int maximize_symbol, NkColor label_normal, NkColor label_hover, NkColor label_active, int align, NkVec2 padding, NkVec2 label_padding, NkVec2 spacing) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.close_button(close_button);
        this.minimize_button(minimize_button);
        this.close_symbol(close_symbol);
        this.minimize_symbol(minimize_symbol);
        this.maximize_symbol(maximize_symbol);
        this.label_normal(label_normal);
        this.label_hover(label_hover);
        this.label_active(label_active);
        this.align(align);
        this.padding(padding);
        this.label_padding(label_padding);
        this.spacing(spacing);
        return this;
    }

    public NkStyleWindowHeader set(NkStyleWindowHeader src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkStyleWindowHeader malloc() {
        return (NkStyleWindowHeader)NkStyleWindowHeader.wrap(NkStyleWindowHeader.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkStyleWindowHeader calloc() {
        return (NkStyleWindowHeader)NkStyleWindowHeader.wrap(NkStyleWindowHeader.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkStyleWindowHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkStyleWindowHeader)NkStyleWindowHeader.wrap(NkStyleWindowHeader.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkStyleWindowHeader create(long address) {
        return (NkStyleWindowHeader)NkStyleWindowHeader.wrap(NkStyleWindowHeader.class, (long)address);
    }

    @Nullable
    public static NkStyleWindowHeader createSafe(long address) {
        return address == 0L ? null : (NkStyleWindowHeader)NkStyleWindowHeader.wrap(NkStyleWindowHeader.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkStyleWindowHeader.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkStyleWindowHeader.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkStyleWindowHeader.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleWindowHeader.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkStyleWindowHeader.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkStyleWindowHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkStyleWindowHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static NkStyleWindowHeader mallocStack() {
        return NkStyleWindowHeader.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleWindowHeader callocStack() {
        return NkStyleWindowHeader.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleWindowHeader mallocStack(MemoryStack stack) {
        return NkStyleWindowHeader.malloc(stack);
    }

    @Deprecated
    public static NkStyleWindowHeader callocStack(MemoryStack stack) {
        return NkStyleWindowHeader.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleWindowHeader.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleWindowHeader.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleWindowHeader.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleWindowHeader.calloc(capacity, stack);
    }

    public static NkStyleWindowHeader malloc(MemoryStack stack) {
        return (NkStyleWindowHeader)NkStyleWindowHeader.wrap(NkStyleWindowHeader.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleWindowHeader calloc(MemoryStack stack) {
        return (NkStyleWindowHeader)NkStyleWindowHeader.wrap(NkStyleWindowHeader.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NkStyleWindowHeader.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NkStyleWindowHeader.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkStyleButton nclose_button(long struct) {
        return NkStyleButton.create(struct + (long)CLOSE_BUTTON);
    }

    public static NkStyleButton nminimize_button(long struct) {
        return NkStyleButton.create(struct + (long)MINIMIZE_BUTTON);
    }

    public static int nclose_symbol(long struct) {
        return UNSAFE.getInt(null, struct + (long)CLOSE_SYMBOL);
    }

    public static int nminimize_symbol(long struct) {
        return UNSAFE.getInt(null, struct + (long)MINIMIZE_SYMBOL);
    }

    public static int nmaximize_symbol(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXIMIZE_SYMBOL);
    }

    public static NkColor nlabel_normal(long struct) {
        return NkColor.create(struct + (long)LABEL_NORMAL);
    }

    public static NkColor nlabel_hover(long struct) {
        return NkColor.create(struct + (long)LABEL_HOVER);
    }

    public static NkColor nlabel_active(long struct) {
        return NkColor.create(struct + (long)LABEL_ACTIVE);
    }

    public static int nalign(long struct) {
        return UNSAFE.getInt(null, struct + (long)ALIGN);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkVec2 nlabel_padding(long struct) {
        return NkVec2.create(struct + (long)LABEL_PADDING);
    }

    public static NkVec2 nspacing(long struct) {
        return NkVec2.create(struct + (long)SPACING);
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)NORMAL), (long)NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HOVER), (long)NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ACTIVE), (long)NkStyleItem.SIZEOF);
    }

    public static void nclose_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CLOSE_BUTTON), (long)NkStyleButton.SIZEOF);
    }

    public static void nminimize_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MINIMIZE_BUTTON), (long)NkStyleButton.SIZEOF);
    }

    public static void nclose_symbol(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CLOSE_SYMBOL, value);
    }

    public static void nminimize_symbol(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MINIMIZE_SYMBOL, value);
    }

    public static void nmaximize_symbol(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXIMIZE_SYMBOL, value);
    }

    public static void nlabel_normal(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)LABEL_NORMAL), (long)NkColor.SIZEOF);
    }

    public static void nlabel_hover(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)LABEL_HOVER), (long)NkColor.SIZEOF);
    }

    public static void nlabel_active(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)LABEL_ACTIVE), (long)NkColor.SIZEOF);
    }

    public static void nalign(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ALIGN, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PADDING), (long)NkVec2.SIZEOF);
    }

    public static void nlabel_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)LABEL_PADDING), (long)NkVec2.SIZEOF);
    }

    public static void nspacing(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SPACING), (long)NkVec2.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyleWindowHeader.__struct((Struct.Member[])new Struct.Member[]{NkStyleWindowHeader.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleWindowHeader.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleWindowHeader.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleWindowHeader.__member((int)NkStyleButton.SIZEOF, (int)NkStyleButton.ALIGNOF), NkStyleWindowHeader.__member((int)NkStyleButton.SIZEOF, (int)NkStyleButton.ALIGNOF), NkStyleWindowHeader.__member((int)4), NkStyleWindowHeader.__member((int)4), NkStyleWindowHeader.__member((int)4), NkStyleWindowHeader.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleWindowHeader.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleWindowHeader.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleWindowHeader.__member((int)4), NkStyleWindowHeader.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF), NkStyleWindowHeader.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF), NkStyleWindowHeader.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        CLOSE_BUTTON = layout.offsetof(3);
        MINIMIZE_BUTTON = layout.offsetof(4);
        CLOSE_SYMBOL = layout.offsetof(5);
        MINIMIZE_SYMBOL = layout.offsetof(6);
        MAXIMIZE_SYMBOL = layout.offsetof(7);
        LABEL_NORMAL = layout.offsetof(8);
        LABEL_HOVER = layout.offsetof(9);
        LABEL_ACTIVE = layout.offsetof(10);
        ALIGN = layout.offsetof(11);
        PADDING = layout.offsetof(12);
        LABEL_PADDING = layout.offsetof(13);
        SPACING = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<NkStyleWindowHeader, Buffer>
    implements NativeResource {
        private static final NkStyleWindowHeader ELEMENT_FACTORY = NkStyleWindowHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkStyleWindowHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem normal() {
            return NkStyleWindowHeader.nnormal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem hover() {
            return NkStyleWindowHeader.nhover(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem active() {
            return NkStyleWindowHeader.nactive(this.address());
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton close_button() {
            return NkStyleWindowHeader.nclose_button(this.address());
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton minimize_button() {
            return NkStyleWindowHeader.nminimize_button(this.address());
        }

        @NativeType(value="enum nk_symbol_type")
        public int close_symbol() {
            return NkStyleWindowHeader.nclose_symbol(this.address());
        }

        @NativeType(value="enum nk_symbol_type")
        public int minimize_symbol() {
            return NkStyleWindowHeader.nminimize_symbol(this.address());
        }

        @NativeType(value="enum nk_symbol_type")
        public int maximize_symbol() {
            return NkStyleWindowHeader.nmaximize_symbol(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor label_normal() {
            return NkStyleWindowHeader.nlabel_normal(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor label_hover() {
            return NkStyleWindowHeader.nlabel_hover(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor label_active() {
            return NkStyleWindowHeader.nlabel_active(this.address());
        }

        @NativeType(value="enum nk_style_header_align")
        public int align() {
            return NkStyleWindowHeader.nalign(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleWindowHeader.npadding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 label_padding() {
            return NkStyleWindowHeader.nlabel_padding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 spacing() {
            return NkStyleWindowHeader.nspacing(this.address());
        }

        public Buffer normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleWindowHeader.nnormal(this.address(), value);
            return this;
        }

        public Buffer normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.normal());
            return this;
        }

        public Buffer hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleWindowHeader.nhover(this.address(), value);
            return this;
        }

        public Buffer hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.hover());
            return this;
        }

        public Buffer active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleWindowHeader.nactive(this.address(), value);
            return this;
        }

        public Buffer active(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.active());
            return this;
        }

        public Buffer close_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyleWindowHeader.nclose_button(this.address(), value);
            return this;
        }

        public Buffer close_button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.close_button());
            return this;
        }

        public Buffer minimize_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyleWindowHeader.nminimize_button(this.address(), value);
            return this;
        }

        public Buffer minimize_button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.minimize_button());
            return this;
        }

        public Buffer close_symbol(@NativeType(value="enum nk_symbol_type") int value) {
            NkStyleWindowHeader.nclose_symbol(this.address(), value);
            return this;
        }

        public Buffer minimize_symbol(@NativeType(value="enum nk_symbol_type") int value) {
            NkStyleWindowHeader.nminimize_symbol(this.address(), value);
            return this;
        }

        public Buffer maximize_symbol(@NativeType(value="enum nk_symbol_type") int value) {
            NkStyleWindowHeader.nmaximize_symbol(this.address(), value);
            return this;
        }

        public Buffer label_normal(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleWindowHeader.nlabel_normal(this.address(), value);
            return this;
        }

        public Buffer label_normal(Consumer<NkColor> consumer) {
            consumer.accept(this.label_normal());
            return this;
        }

        public Buffer label_hover(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleWindowHeader.nlabel_hover(this.address(), value);
            return this;
        }

        public Buffer label_hover(Consumer<NkColor> consumer) {
            consumer.accept(this.label_hover());
            return this;
        }

        public Buffer label_active(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleWindowHeader.nlabel_active(this.address(), value);
            return this;
        }

        public Buffer label_active(Consumer<NkColor> consumer) {
            consumer.accept(this.label_active());
            return this;
        }

        public Buffer align(@NativeType(value="enum nk_style_header_align") int value) {
            NkStyleWindowHeader.nalign(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleWindowHeader.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer label_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleWindowHeader.nlabel_padding(this.address(), value);
            return this;
        }

        public Buffer label_padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.label_padding());
            return this;
        }

        public Buffer spacing(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleWindowHeader.nspacing(this.address(), value);
            return this;
        }

        public Buffer spacing(Consumer<NkVec2> consumer) {
            consumer.accept(this.spacing());
            return this;
        }
    }
}

