/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_property_state")
public class NkPropertyState
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACTIVE;
    public static final int PREV;
    public static final int BUFFER;
    public static final int LENGTH;
    public static final int CURSOR;
    public static final int SELECT_START;
    public static final int SELECT_END;
    public static final int NAME;
    public static final int SEQ;
    public static final int OLD;
    public static final int STATE;

    public NkPropertyState(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkPropertyState.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int active() {
        return NkPropertyState.nactive(this.address());
    }

    public int prev() {
        return NkPropertyState.nprev(this.address());
    }

    @NativeType(value="char[NK_MAX_NUMBER_BUFFER]")
    public ByteBuffer buffer() {
        return NkPropertyState.nbuffer(this.address());
    }

    @NativeType(value="char")
    public byte buffer(int index) {
        return NkPropertyState.nbuffer(this.address(), index);
    }

    public int length() {
        return NkPropertyState.nlength(this.address());
    }

    public int cursor() {
        return NkPropertyState.ncursor(this.address());
    }

    public int select_start() {
        return NkPropertyState.nselect_start(this.address());
    }

    public int select_end() {
        return NkPropertyState.nselect_end(this.address());
    }

    @NativeType(value="nk_hash")
    public int name() {
        return NkPropertyState.nname(this.address());
    }

    @NativeType(value="unsigned int")
    public int seq() {
        return NkPropertyState.nseq(this.address());
    }

    @NativeType(value="unsigned int")
    public int old() {
        return NkPropertyState.nold(this.address());
    }

    public int state() {
        return NkPropertyState.nstate(this.address());
    }

    public static NkPropertyState create(long address) {
        return (NkPropertyState)NkPropertyState.wrap(NkPropertyState.class, (long)address);
    }

    @Nullable
    public static NkPropertyState createSafe(long address) {
        return address == 0L ? null : (NkPropertyState)NkPropertyState.wrap(NkPropertyState.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkPropertyState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkPropertyState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static int nactive(long struct) {
        return UNSAFE.getInt(null, struct + (long)ACTIVE);
    }

    public static int nprev(long struct) {
        return UNSAFE.getInt(null, struct + (long)PREV);
    }

    public static ByteBuffer nbuffer(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)BUFFER), (int)64);
    }

    public static byte nbuffer(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)BUFFER + Checks.check((int)index, (int)64) * 1L);
    }

    public static int nlength(long struct) {
        return UNSAFE.getInt(null, struct + (long)LENGTH);
    }

    public static int ncursor(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURSOR);
    }

    public static int nselect_start(long struct) {
        return UNSAFE.getInt(null, struct + (long)SELECT_START);
    }

    public static int nselect_end(long struct) {
        return UNSAFE.getInt(null, struct + (long)SELECT_END);
    }

    public static int nname(long struct) {
        return UNSAFE.getInt(null, struct + (long)NAME);
    }

    public static int nseq(long struct) {
        return UNSAFE.getInt(null, struct + (long)SEQ);
    }

    public static int nold(long struct) {
        return UNSAFE.getInt(null, struct + (long)OLD);
    }

    public static int nstate(long struct) {
        return UNSAFE.getInt(null, struct + (long)STATE);
    }

    static {
        Struct.Layout layout = NkPropertyState.__struct((Struct.Member[])new Struct.Member[]{NkPropertyState.__member((int)4), NkPropertyState.__member((int)4), NkPropertyState.__array((int)1, (int)64), NkPropertyState.__member((int)4), NkPropertyState.__member((int)4), NkPropertyState.__member((int)4), NkPropertyState.__member((int)4), NkPropertyState.__member((int)4), NkPropertyState.__member((int)4), NkPropertyState.__member((int)4), NkPropertyState.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACTIVE = layout.offsetof(0);
        PREV = layout.offsetof(1);
        BUFFER = layout.offsetof(2);
        LENGTH = layout.offsetof(3);
        CURSOR = layout.offsetof(4);
        SELECT_START = layout.offsetof(5);
        SELECT_END = layout.offsetof(6);
        NAME = layout.offsetof(7);
        SEQ = layout.offsetof(8);
        OLD = layout.offsetof(9);
        STATE = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<NkPropertyState, Buffer> {
        private static final NkPropertyState ELEMENT_FACTORY = NkPropertyState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkPropertyState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int active() {
            return NkPropertyState.nactive(this.address());
        }

        public int prev() {
            return NkPropertyState.nprev(this.address());
        }

        @NativeType(value="char[NK_MAX_NUMBER_BUFFER]")
        public ByteBuffer buffer() {
            return NkPropertyState.nbuffer(this.address());
        }

        @NativeType(value="char")
        public byte buffer(int index) {
            return NkPropertyState.nbuffer(this.address(), index);
        }

        public int length() {
            return NkPropertyState.nlength(this.address());
        }

        public int cursor() {
            return NkPropertyState.ncursor(this.address());
        }

        public int select_start() {
            return NkPropertyState.nselect_start(this.address());
        }

        public int select_end() {
            return NkPropertyState.nselect_end(this.address());
        }

        @NativeType(value="nk_hash")
        public int name() {
            return NkPropertyState.nname(this.address());
        }

        @NativeType(value="unsigned int")
        public int seq() {
            return NkPropertyState.nseq(this.address());
        }

        @NativeType(value="unsigned int")
        public int old() {
            return NkPropertyState.nold(this.address());
        }

        public int state() {
            return NkPropertyState.nstate(this.address());
        }
    }
}

