/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.EventPosition;
import java.time.Instant;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventPositionImpl
implements EventPosition {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(EventPositionImpl.class);
    private static final long serialVersionUID = 7304813338251422629L;
    private final String offset;
    private final Long sequenceNumber;
    private final Instant dateTime;
    private final Boolean inclusiveFlag;

    private EventPositionImpl(String o, Long s, Instant d, Boolean i) {
        this.offset = o;
        this.sequenceNumber = s;
        this.dateTime = d;
        this.inclusiveFlag = i;
    }

    public static EventPositionImpl fromOffset(String offset) {
        return EventPositionImpl.fromOffset(offset, false);
    }

    public static EventPositionImpl fromOffset(String offset, boolean inclusiveFlag) {
        return new EventPositionImpl(offset, null, null, inclusiveFlag);
    }

    public static EventPositionImpl fromSequenceNumber(Long sequenceNumber) {
        return EventPositionImpl.fromSequenceNumber(sequenceNumber, false);
    }

    public static EventPositionImpl fromSequenceNumber(Long sequenceNumber, boolean inclusiveFlag) {
        return new EventPositionImpl(null, sequenceNumber, null, inclusiveFlag);
    }

    public static EventPositionImpl fromEnqueuedTime(Instant dateTime) {
        return new EventPositionImpl(null, null, dateTime, null);
    }

    public static EventPositionImpl fromStartOfStream() {
        return new EventPositionImpl("-1", null, null, true);
    }

    public static EventPositionImpl fromEndOfStream() {
        return new EventPositionImpl("@latest", null, null, false);
    }

    @Override
    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public Instant getEnqueuedTime() {
        return this.dateTime;
    }

    @Override
    public String getOffset() {
        return this.offset;
    }

    @Override
    public boolean getInclusiveFlag() {
        return this.inclusiveFlag;
    }

    String getExpression() {
        if (this.offset != null) {
            return this.inclusiveFlag != false ? String.format("amqp.annotation.%s >%s '%s'", "x-opt-offset", "=", this.offset) : String.format("amqp.annotation.%s >%s '%s'", "x-opt-offset", "", this.offset);
        }
        if (this.sequenceNumber != null) {
            return this.inclusiveFlag != false ? String.format("amqp.annotation.%s >%s '%s'", "x-opt-sequence-number", "=", this.sequenceNumber) : String.format("amqp.annotation.%s >%s '%s'", "x-opt-sequence-number", "", this.sequenceNumber);
        }
        if (this.dateTime != null) {
            String ms;
            block5: {
                try {
                    ms = Long.toString(this.dateTime.toEpochMilli());
                }
                catch (ArithmeticException ex) {
                    ms = Long.toString(Long.MAX_VALUE);
                    if (!TRACE_LOGGER.isWarnEnabled()) break block5;
                    TRACE_LOGGER.warn("receiver not yet created, action[createReceiveLink], warning[starting receiver from epoch+Long.Max]");
                }
            }
            return String.format("amqp.annotation.%s >%s '%s'", "x-opt-enqueued-time", "", ms);
        }
        throw new IllegalArgumentException("No starting position was set.");
    }

    public String toString() {
        return String.format(Locale.US, "offset[%s], sequenceNumber[%s], enqueuedTime[%s], inclusiveFlag[%s]", this.offset, this.sequenceNumber, this.dateTime != null ? Long.valueOf(this.dateTime.toEpochMilli()) : "null", this.inclusiveFlag);
    }
}

