/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.msgpack.jruby.ExtensionRegistry;
import org.msgpack.jruby.Packer;
import org.msgpack.jruby.Unpacker;

@JRubyClass(name={"MessagePack::Factory"})
public class Factory
extends RubyObject {
    private static final long serialVersionUID = 8441284623445322492L;
    private final transient Ruby runtime;
    private transient ExtensionRegistry extensionRegistry;
    private boolean hasSymbolExtType;
    private boolean hasBigIntExtType;

    public Factory(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.runtime = ruby;
        this.extensionRegistry = new ExtensionRegistry();
        this.hasSymbolExtType = false;
        this.hasBigIntExtType = false;
    }

    public ExtensionRegistry extensionRegistry() {
        return this.extensionRegistry.dup();
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext threadContext) {
        return this;
    }

    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        Factory factory = (Factory)super.dup();
        factory.extensionRegistry = this.extensionRegistry();
        factory.hasSymbolExtType = this.hasSymbolExtType;
        return factory;
    }

    @JRubyMethod(name={"packer"}, optional=2)
    public Packer packer(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return Packer.newPacker(threadContext, this.extensionRegistry(), this.hasSymbolExtType, this.hasBigIntExtType, iRubyObjectArray);
    }

    @JRubyMethod(name={"unpacker"}, optional=2)
    public Unpacker unpacker(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return Unpacker.newUnpacker(threadContext, this.extensionRegistry(), iRubyObjectArray);
    }

    @JRubyMethod(name={"registered_types_internal"}, visibility=Visibility.PRIVATE)
    public IRubyObject registeredTypesInternal(ThreadContext threadContext) {
        return RubyArray.newArray((Ruby)threadContext.runtime, (IRubyObject[])new IRubyObject[]{this.extensionRegistry.toInternalPackerRegistry(threadContext), this.extensionRegistry.toInternalUnpackerRegistry(threadContext)});
    }

    @JRubyMethod(name={"register_type_internal"}, required=3, visibility=Visibility.PRIVATE)
    public IRubyObject registerTypeInternal(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        IRubyObject iRubyObject4;
        this.testFrozen("MessagePack::Factory");
        Ruby ruby = threadContext.runtime;
        RubyHash rubyHash = (RubyHash)iRubyObject3;
        IRubyObject iRubyObject5 = rubyHash.fastARef((IRubyObject)ruby.newSymbol("packer"));
        IRubyObject iRubyObject6 = rubyHash.fastARef((IRubyObject)ruby.newSymbol("unpacker"));
        long l = ((RubyFixnum)iRubyObject).getLongValue();
        if (l < -128L || l > 127L) {
            throw ruby.newRangeError(String.format("integer %d too big to convert to `signed char'", l));
        }
        if (!(iRubyObject2 instanceof RubyModule)) {
            throw ruby.newArgumentError(String.format("expected Module/Class but found %s.", iRubyObject2.getType().getName()));
        }
        RubyModule rubyModule = (RubyModule)iRubyObject2;
        boolean bl = false;
        if (rubyHash != null && (iRubyObject4 = rubyHash.fastARef((IRubyObject)ruby.newSymbol("recursive"))) != null && iRubyObject4.isTrue()) {
            bl = true;
        }
        this.extensionRegistry.put(rubyModule, (int)l, bl, iRubyObject5, iRubyObject6);
        if (rubyModule == ruby.getSymbol() && !iRubyObject5.isNil()) {
            this.hasSymbolExtType = true;
        }
        if (rubyHash != null && (iRubyObject4 = rubyHash.fastARef((IRubyObject)ruby.newSymbol("oversized_integer_extension"))) != null && iRubyObject4.isTrue()) {
            if (rubyModule == ruby.getModule("Integer")) {
                this.hasBigIntExtType = true;
            } else {
                throw ruby.newArgumentError("oversized_integer_extension: true is only for Integer class");
            }
        }
        return ruby.getNil();
    }

    static class FactoryAllocator
    implements ObjectAllocator {
        FactoryAllocator() {
        }

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new Factory(ruby, rubyClass);
        }
    }
}

