/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.util.List;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;

public abstract class AbstractTarget<A extends Address>
implements Target<A> {
    private static final long serialVersionUID = 7869222257083840513L;
    private A address;
    private int version = 3;
    private int retries = SNMP4JSettings.getDefaultRetries();
    private long timeout = SNMP4JSettings.getDefaultTimeoutMillis();
    private int maxSizeRequestPDU = 65535;
    private List<TransportMapping<? super A>> preferredTransports;
    protected int securityLevel = 1;
    protected int securityModel = 3;
    protected OctetString securityName = new OctetString();

    protected AbstractTarget() {
    }

    protected AbstractTarget(A address) {
        this.address = address;
    }

    protected AbstractTarget(A address, OctetString securityName) {
        this(address);
        this.securityName = securityName;
    }

    @Override
    public A getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(A address) {
        this.address = address;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setRetries(int retries) {
        if (retries < 0) {
            throw new IllegalArgumentException("Number of retries < 0");
        }
        this.retries = retries;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public int getMaxSizeRequestPDU() {
        return this.maxSizeRequestPDU;
    }

    @Override
    public void setMaxSizeRequestPDU(int maxSizeRequestPDU) {
        if (maxSizeRequestPDU < 484) {
            throw new IllegalArgumentException("The minimum PDU length is: 484");
        }
        this.maxSizeRequestPDU = maxSizeRequestPDU;
    }

    @Override
    public List<TransportMapping<? super A>> getPreferredTransports() {
        return this.preferredTransports;
    }

    public void setPreferredTransports(List<TransportMapping<? super A>> preferredTransports) {
        this.preferredTransports = preferredTransports;
    }

    protected String toStringAbstractTarget() {
        return "address=" + String.valueOf(this.getAddress()) + ",version=" + this.version + ",timeout=" + this.timeout + ",retries=" + this.retries + ",securityLevel=" + this.securityLevel + ",securityModel=" + this.securityModel + ",securityName=" + String.valueOf(this.securityName) + ",preferredTransports=" + String.valueOf(this.preferredTransports);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.toStringAbstractTarget() + "]";
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public int getSecurityModel() {
        return this.securityModel;
    }

    @Override
    public final OctetString getSecurityName() {
        return this.securityName;
    }

    @Override
    public int getSecurityLevel() {
        return this.securityLevel;
    }

    @Override
    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = securityLevel;
    }

    @Override
    public void setSecurityModel(int securityModel) {
        this.securityModel = securityModel;
    }

    @Override
    public final void setSecurityName(OctetString securityName) {
        this.securityName = securityName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTarget that = (AbstractTarget)o;
        if (this.getVersion() != that.getVersion()) {
            return false;
        }
        if (this.getRetries() != that.getRetries()) {
            return false;
        }
        if (this.getTimeout() != that.getTimeout()) {
            return false;
        }
        if (this.getMaxSizeRequestPDU() != that.getMaxSizeRequestPDU()) {
            return false;
        }
        if (this.getSecurityLevel() != that.getSecurityLevel()) {
            return false;
        }
        if (this.getSecurityModel() != that.getSecurityModel()) {
            return false;
        }
        if (!this.getAddress().equals(that.getAddress())) {
            return false;
        }
        if (this.getPreferredTransports() != null ? !this.getPreferredTransports().equals(that.getPreferredTransports()) : that.getPreferredTransports() != null) {
            return false;
        }
        return !(this.getSecurityName() != null ? !this.getSecurityName().equals(that.getSecurityName()) : that.getSecurityName() != null);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.version;
        result = 31 * result + this.securityName.hashCode();
        return result;
    }
}

