/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.sql.Array;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.transaction.xa.Xid;
import org.apache.derby.client.BasicClientDataSource;
import org.apache.derby.client.ClientAutoloadedDriver;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientCallableStatement;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientDatabaseMetaData;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.EncryptionManager;
import org.apache.derby.client.am.FailedProperties40;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SectionManager;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetCallableStatement;
import org.apache.derby.client.net.NetConfiguration;
import org.apache.derby.client.net.NetDatabaseMetaData;
import org.apache.derby.client.net.NetPreparedStatement;
import org.apache.derby.client.net.NetStatement;
import org.apache.derby.client.net.NetXAResource;
import org.apache.derby.client.net.Typdef;
import org.apache.derby.shared.common.i18n.MessageUtil;
import org.apache.derby.shared.common.sanity.SanityManager;

public class NetConnection
extends ClientConnection {
    private static final MessageUtil msgutil = SqlException.getMessageUtil();
    protected NetAgent netAgent_;
    private final ClientPooledConnection pooledConnection_;
    private final boolean closeStatementsOnClose;
    protected int targetAgent_ = 7;
    protected int targetCmntcpip_ = 5;
    protected int targetRdb_ = 7;
    int targetSecmgr_ = 7;
    protected int targetCmnappc_ = 0;
    protected int targetXamgr_ = 7;
    protected int targetSyncptmgr_ = 0;
    protected int targetRsyncmgr_ = 0;
    protected int targetUnicodemgr_ = 1208;
    private String extnam_;
    String targetSrvclsnm_;
    String targetSrvrlslv_;
    private transient byte[] publicKey_;
    private transient byte[] targetPublicKey_;
    private transient byte[] sourceSeed_;
    private transient byte[] targetSeed_;
    private ByteBuffer prddta_;
    byte[] crrtkn_;
    private int targetSecmec_;
    private int securityMechanism_;
    private transient char[] deferredResetPassword_ = null;
    private boolean connectionNull = false;
    protected NetXAResource xares_ = null;
    private List<Xid> indoubtTransactions_ = null;
    protected int currXACallInfoOffset_ = 0;
    private PreparedStatement isValidStmt;

    private void setDeferredResetPassword(String password) {
        this.deferredResetPassword_ = password == null ? null : this.flipBits(password.toCharArray());
    }

    private String getDeferredResetPassword() {
        if (this.deferredResetPassword_ == null) {
            return null;
        }
        String password = new String(this.flipBits(this.deferredResetPassword_));
        this.flipBits(this.deferredResetPassword_);
        return password;
    }

    NetConnection(LogWriter logWriter, int driverManagerLoginTimeout, String serverName, int portNumber, String databaseName, Properties properties) throws SqlException {
        super(logWriter, driverManagerLoginTimeout, serverName, portNumber, databaseName, properties);
        this.pooledConnection_ = null;
        this.closeStatementsOnClose = true;
        this.netAgent_ = (NetAgent)this.agent_;
        if (this.netAgent_.exceptionOpeningSocket_ != null) {
            throw this.netAgent_.exceptionOpeningSocket_;
        }
        this.checkDatabaseName();
        String password = BasicClientDataSource.getPassword(properties);
        this.securityMechanism_ = BasicClientDataSource.getSecurityMechanism(properties);
        this.flowConnect(password, this.securityMechanism_);
        if (!this.isConnectionNull()) {
            this.completeConnect();
        }
        this.netAgent_.setTimeout(0);
    }

    NetConnection(LogWriter logWriter, String user, String password, BasicClientDataSource dataSource, int rmId, boolean isXAConn) throws SqlException {
        super(logWriter, user, password, isXAConn, dataSource);
        this.pooledConnection_ = null;
        this.closeStatementsOnClose = true;
        this.netAgent_ = (NetAgent)this.agent_;
        this.initialize(password, dataSource, isXAConn);
    }

    NetConnection(LogWriter logWriter, String user, String password, BasicClientDataSource dataSource, int rmId, boolean isXAConn, ClientPooledConnection cpc) throws SqlException {
        super(logWriter, user, password, isXAConn, dataSource);
        this.netAgent_ = (NetAgent)this.agent_;
        this.initialize(password, dataSource, isXAConn);
        this.pooledConnection_ = cpc;
        this.closeStatementsOnClose = !cpc.isStatementPoolingEnabled();
    }

    private void initialize(String password, BasicClientDataSource dataSource, boolean isXAConn) throws SqlException {
        this.securityMechanism_ = dataSource.getSecurityMechanism(password);
        this.setDeferredResetPassword(password);
        this.checkDatabaseName();
        this.dataSource_ = dataSource;
        this.isXAConnection_ = isXAConn;
        this.flowConnect(password, this.securityMechanism_);
        if (!this.isConnectionNull()) {
            this.completeConnect();
        } else {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("XCY00.S"), "databaseName", this.databaseName_));
        }
        this.netAgent_.setTimeout(0);
    }

    private void resetNetConnection(LogWriter logWriter) throws SqlException {
        super.resetConnection(logWriter);
        this.targetSrvclsnm_ = null;
        this.targetSrvrlslv_ = null;
        this.publicKey_ = null;
        this.targetPublicKey_ = null;
        this.sourceSeed_ = null;
        this.targetSeed_ = null;
        this.targetSecmec_ = 0;
        this.resetConnectionAtFirstSql_ = false;
        boolean isDeferredReset = this.flowReconnect(this.getDeferredResetPassword(), this.securityMechanism_);
        this.completeReset(isDeferredReset);
        this.netAgent_.setTimeout(0);
    }

    @Override
    protected void reset_(LogWriter logWriter) throws SqlException {
        if (this.inUnitOfWork_) {
            throw new SqlException(logWriter, new ClientMessageId("XN001.S"), new Object[0]);
        }
        this.resetNetConnection(logWriter);
    }

    private void completeReset(boolean isDeferredReset) throws SqlException {
        super.completeReset(isDeferredReset, this.closeStatementsOnClose, this.xares_);
    }

    private void flowConnect(String password, int securityMechanism) throws SqlException {
        this.netAgent_ = (NetAgent)this.agent_;
        this.constructExtnam();
        this.constructPrddta();
        this.netAgent_.typdef_ = new Typdef(this.netAgent_, 1208, "QTDSQLASC", 1200, 1208);
        this.netAgent_.originalTargetTypdef_ = this.netAgent_.targetTypdef_ = new Typdef(this.netAgent_);
        this.setDeferredResetPassword(password);
        try {
            switch (securityMechanism) {
                case 3: {
                    this.checkUserPassword(this.user_, password);
                    this.flowUSRIDPWDconnect(password);
                    break;
                }
                case 4: {
                    this.checkUser(this.user_);
                    this.flowUSRIDONLconnect();
                    break;
                }
                case 7: {
                    this.checkUserPassword(this.user_, password);
                    this.flowUSRENCPWDconnect(password);
                    break;
                }
                case 9: {
                    this.checkUserPassword(this.user_, password);
                    this.flowEUSRIDPWDconnect(password);
                    break;
                }
                case 12: {
                    this.checkUserPassword(this.user_, password);
                    this.flowEUSRIDDTAconnect();
                    break;
                }
                case 13: {
                    this.checkUserPassword(this.user_, password);
                    this.flowEUSRPWDDTAconnect(password);
                    break;
                }
                case 8: {
                    this.checkUserPassword(this.user_, password);
                    this.flowUSRSSBPWDconnect(password);
                    break;
                }
                default: {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.5"), securityMechanism);
                }
            }
        }
        catch (Throwable e) {
            this.open_ = false;
            this.handleLoginTimeout(e);
            SqlException exceptionToBeThrown = e instanceof SqlException ? (SqlException)e : new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), e, e.getClass().getName(), e.getMessage());
            try {
                if (this.agent_ != null) {
                    this.agent_.close();
                }
            }
            catch (SqlException sqlException) {
                // empty catch block
            }
            throw exceptionToBeThrown;
        }
    }

    private void flowSimpleConnect() throws SqlException {
        this.netAgent_ = (NetAgent)this.agent_;
        this.constructExtnam();
        this.constructPrddta();
        this.netAgent_.typdef_ = new Typdef(this.netAgent_, 1208, "QTDSQLASC", 1200, 1208);
        this.netAgent_.originalTargetTypdef_ = this.netAgent_.targetTypdef_ = new Typdef(this.netAgent_);
        try {
            this.flowServerAttributes();
        }
        catch (Throwable e) {
            this.open_ = false;
            this.handleLoginTimeout(e);
            SqlException exceptionToBeThrown = e instanceof SqlException ? (SqlException)e : new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), e, e.getClass().getName(), e.getMessage());
            try {
                if (this.agent_ != null) {
                    this.agent_.close();
                }
            }
            catch (SqlException sqlException) {
                // empty catch block
            }
            throw exceptionToBeThrown;
        }
    }

    private void handleLoginTimeout(Throwable original) throws SqlException {
        for (Throwable cause = original; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof SocketTimeoutException)) continue;
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XBDA0.C.1"), original, new Object[0]);
        }
    }

    private boolean flowReconnect(String password, int securityMechanism) throws SqlException {
        this.constructExtnam();
        this.constructPrddta();
        this.checkSecmgrForSecmecSupport(securityMechanism);
        try {
            switch (securityMechanism) {
                case 3: {
                    this.checkUserPassword(this.user_, password);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(password);
                    return true;
                }
                case 4: {
                    this.checkUser(this.user_);
                    this.resetConnectionAtFirstSql_ = true;
                    return true;
                }
                case 7: {
                    this.checkUserPassword(this.user_, password);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(password);
                    return true;
                }
                case 9: {
                    this.checkUserPassword(this.user_, password);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(password);
                    return true;
                }
                case 12: {
                    this.checkUserPassword(this.user_, password);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(password);
                    return true;
                }
                case 13: {
                    this.checkUserPassword(this.user_, password);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(password);
                    return true;
                }
                case 8: {
                    this.checkUserPassword(this.user_, password);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(password);
                    return true;
                }
            }
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.5"), securityMechanism);
        }
        catch (SqlException sqle) {
            this.open_ = false;
            try {
                if (this.agent_ != null) {
                    this.agent_.close();
                }
            }
            catch (SqlException sqlException) {
                // empty catch block
            }
            throw sqle;
        }
    }

    private void flowUSRIDPWDconnect(String password) throws SqlException {
        this.flowServerAttributesAndKeyExchange(3, null);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, password, null, null);
    }

    private void flowUSRIDONLconnect() throws SqlException {
        this.flowServerAttributesAndKeyExchange(4, null);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, null, null, null);
    }

    private void flowUSRENCPWDconnect(String password) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(7);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(7, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, null, null, this.encryptedPasswordForUSRENCPWD(password));
    }

    private void flowEUSRIDPWDconnect(String password) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(9);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(9, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, null, null, this.encryptedUseridForEUSRIDPWD(), this.encryptedPasswordForEUSRIDPWD(password));
    }

    private void flowEUSRIDDTAconnect() throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(9);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(12, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, null, null, this.encryptedUseridForEUSRIDPWD(), null);
    }

    private void flowEUSRPWDDTAconnect(String password) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(13);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(13, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, null, null, this.encryptedUseridForEUSRIDPWD(), this.encryptedPasswordForEUSRIDPWD(password));
    }

    private void flowUSRSSBPWDconnect(String password) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(8);
        this.initializeClientSeed();
        this.flowSeedExchange(8, this.sourceSeed_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, null, null, this.passwordSubstituteForUSRSSBPWD(password));
    }

    private void flowServerAttributes() throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.netAgent_.netConnectionRequest_.writeExchangeServerAttributes(this.extnam_, this.targetAgent_, this.netAgent_.targetSqlam_, this.targetRdb_, this.targetSecmgr_, this.targetCmntcpip_, this.targetCmnappc_, this.targetXamgr_, this.targetSyncptmgr_, this.targetRsyncmgr_, this.targetUnicodemgr_);
        this.agent_.flowOutsideUOW();
        this.netAgent_.netConnectionReply_.readExchangeServerAttributes(this);
        this.agent_.endReadChain();
    }

    private void flowKeyExchange(int securityMechanism, byte[] publicKey) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.netAgent_.netConnectionRequest_.writeAccessSecurity(securityMechanism, this.databaseName_, publicKey);
        this.agent_.flowOutsideUOW();
        this.netAgent_.netConnectionReply_.readAccessSecurity(this, securityMechanism);
        this.agent_.endReadChain();
    }

    private void flowSeedExchange(int securityMechanism, byte[] sourceSeed) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.netAgent_.netConnectionRequest_.writeAccessSecurity(securityMechanism, this.databaseName_, sourceSeed);
        this.agent_.flowOutsideUOW();
        this.netAgent_.netConnectionReply_.readAccessSecurity(this, securityMechanism);
        this.agent_.endReadChain();
    }

    private void flowServerAttributesAndKeyExchange(int securityMechanism, byte[] publicKey) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.writeServerAttributesAndKeyExchange(securityMechanism, publicKey);
        this.agent_.flowOutsideUOW();
        this.readServerAttributesAndKeyExchange(securityMechanism);
        this.agent_.endReadChain();
    }

    private void flowSecurityCheckAndAccessRdb(int securityMechanism, String user, String password, byte[] encryptedUserid, byte[] encryptedPassword) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.writeSecurityCheckAndAccessRdb(securityMechanism, user, password, encryptedUserid, encryptedPassword);
        this.agent_.flowOutsideUOW();
        this.readSecurityCheckAndAccessRdb();
        this.agent_.endReadChain();
    }

    private void writeAllConnectCommandsChained(int securityMechanism, String user, String password) throws SqlException {
        this.writeServerAttributesAndKeyExchange(securityMechanism, null);
        this.writeSecurityCheckAndAccessRdb(securityMechanism, user, password, null, null);
    }

    private void readAllConnectCommandsChained(int securityMechanism) throws SqlException {
        this.readServerAttributesAndKeyExchange(securityMechanism);
        this.readSecurityCheckAndAccessRdb();
    }

    private void writeServerAttributesAndKeyExchange(int securityMechanism, byte[] publicKey) throws SqlException {
        this.netAgent_.netConnectionRequest_.writeExchangeServerAttributes(this.extnam_, this.targetAgent_, this.netAgent_.targetSqlam_, this.targetRdb_, this.targetSecmgr_, this.targetCmntcpip_, this.targetCmnappc_, this.targetXamgr_, this.targetSyncptmgr_, this.targetRsyncmgr_, this.targetUnicodemgr_);
        this.netAgent_.netConnectionRequest_.writeAccessSecurity(securityMechanism, this.databaseName_, publicKey);
    }

    private void readServerAttributesAndKeyExchange(int securityMechanism) throws SqlException {
        this.netAgent_.netConnectionReply_.readExchangeServerAttributes(this);
        this.netAgent_.netConnectionReply_.readAccessSecurity(this, securityMechanism);
    }

    private void writeSecurityCheckAndAccessRdb(int securityMechanism, String user, String password, byte[] encryptedUserid, byte[] encryptedPassword) throws SqlException {
        this.netAgent_.netConnectionRequest_.writeSecurityCheck(securityMechanism, this.databaseName_, user, password, encryptedUserid, encryptedPassword);
        this.netAgent_.netConnectionRequest_.writeAccessDatabase(this.databaseName_, false, this.crrtkn_, this.prddta_.array(), this.netAgent_.typdef_);
    }

    private void readSecurityCheckAndAccessRdb() throws SqlException {
        this.netAgent_.netConnectionReply_.readSecurityCheck(this);
        this.netAgent_.netConnectionReply_.readAccessDatabase(this);
    }

    void writeDeferredReset() throws SqlException {
        if (this.securityMechanism_ == 3) {
            this.writeAllConnectCommandsChained(3, this.user_, this.getDeferredResetPassword());
        } else if (this.securityMechanism_ == 4) {
            this.writeAllConnectCommandsChained(4, this.user_, null);
        } else {
            if (this.securityMechanism_ == 8) {
                this.initializeClientSeed();
            } else {
                this.initializePublicKeyForEncryption();
            }
            this.resetConnectionAtFirstSql_ = false;
            if (this.securityMechanism_ == 8) {
                this.flowSeedExchange(this.securityMechanism_, this.sourceSeed_);
            } else {
                this.flowServerAttributesAndKeyExchange(this.securityMechanism_, this.publicKey_);
            }
            this.agent_.beginWriteChainOutsideUOW();
            this.resetConnectionAtFirstSql_ = true;
            if (this.securityMechanism_ == 7) {
                this.writeSecurityCheckAndAccessRdb(7, this.user_, null, null, this.encryptedPasswordForUSRENCPWD(this.getDeferredResetPassword()));
            } else if (this.securityMechanism_ == 8) {
                this.writeSecurityCheckAndAccessRdb(8, this.user_, null, null, this.passwordSubstituteForUSRSSBPWD(this.getDeferredResetPassword()));
            } else {
                this.writeSecurityCheckAndAccessRdb(9, null, null, this.encryptedUseridForEUSRIDPWD(), this.encryptedPasswordForEUSRIDPWD(this.getDeferredResetPassword()));
            }
        }
    }

    void readDeferredReset() throws SqlException {
        this.resetConnectionAtFirstSql_ = false;
        if (this.securityMechanism_ == 3 || this.securityMechanism_ == 4) {
            this.readAllConnectCommandsChained(this.securityMechanism_);
        } else {
            this.readSecurityCheckAndAccessRdb();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceConnectResetExit(this);
        }
    }

    void setServerAttributeData(String srvclsnm, String srvrlslv) {
        this.targetSrvclsnm_ = srvclsnm;
        this.targetSrvrlslv_ = srvrlslv;
    }

    void setAccessSecurityData(int secchkcd, int desiredSecmec, int[] secmecList, boolean sectknReceived, byte[] sectkn) throws DisconnectException {
        if (secchkcd != 0) {
            this.netAgent_.setSvrcod(CodePoint.SVRCOD_ERROR);
            this.agent_.accumulateReadException(this.mapSecchkcd(secchkcd));
        } else if (secmecList.length == 1 && secmecList[0] == desiredSecmec) {
            this.targetSecmec_ = secmecList[0];
            if (this.targetSecmec_ == 7 || this.targetSecmec_ == 9 || this.targetSecmec_ == 8 || this.targetSecmec_ == 12 || this.targetSecmec_ == 13) {
                if (!sectknReceived) {
                    this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.19"), new Object[0]));
                } else {
                    if (this.targetSecmec_ == 8) {
                        this.targetSeed_ = sectkn;
                    } else {
                        this.targetPublicKey_ = sectkn;
                    }
                    if (this.encryptionManager_ != null) {
                        this.encryptionManager_.resetSecurityKeys();
                    }
                }
            }
        } else {
            this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, new ClientMessageId("XN002.U"), new Object[0]));
        }
    }

    void securityCheckComplete(int svrcod, int secchkcd) {
        this.netAgent_.setSvrcod(svrcod);
        if (secchkcd == 0) {
            return;
        }
        this.agent_.accumulateReadException(this.mapSecchkcd(secchkcd));
    }

    void rdbAccessed(int svrcod, String prdid, boolean crrtknReceived, byte[] crrtkn) {
        if (crrtknReceived) {
            this.crrtkn_ = crrtkn;
        }
        this.netAgent_.setSvrcod(svrcod);
        this.productID_ = prdid;
    }

    @Override
    protected Agent newAgent_(LogWriter logWriter, int loginTimeout, String serverName, int portNumber, int clientSSLMode) throws SqlException {
        return new NetAgent(this, logWriter, loginTimeout, serverName, portNumber, clientSSLMode);
    }

    @Override
    protected ClientStatement newStatement_(int type, int concurrency, int holdability) throws SqlException {
        return new NetStatement((NetAgent)this.netAgent_, (NetConnection)this, (int)type, (int)concurrency, (int)holdability).statement_;
    }

    @Override
    protected void resetStatement_(ClientStatement statement, int type, int concurrency, int holdability) throws SqlException {
        ((NetStatement)statement.getMaterialStatement()).resetNetStatement(this.netAgent_, this, type, concurrency, holdability);
    }

    @Override
    protected ClientPreparedStatement newPositionedUpdatePreparedStatement_(String sql, Section section) throws SqlException {
        return new NetPreparedStatement((NetAgent)this.netAgent_, (NetConnection)this, (String)sql, (Section)section, (ClientPooledConnection)this.pooledConnection_).preparedStatement_;
    }

    @Override
    protected ClientPreparedStatement newPreparedStatement_(String sql, int type, int concurrency, int holdability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes) throws SqlException {
        return new NetPreparedStatement((NetAgent)this.netAgent_, (NetConnection)this, (String)sql, (int)type, (int)concurrency, (int)holdability, (int)autoGeneratedKeys, (String[])columnNames, (int[])columnIndexes, (ClientPooledConnection)this.pooledConnection_).preparedStatement_;
    }

    @Override
    protected void resetPreparedStatement_(ClientPreparedStatement ps, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes) throws SqlException {
        ((NetPreparedStatement)ps.materialPreparedStatement_).resetNetPreparedStatement(this.netAgent_, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, autoGeneratedKeys, columnNames, columnIndexes);
    }

    @Override
    protected ClientCallableStatement newCallableStatement_(String sql, int type, int concurrency, int holdability) throws SqlException {
        return new NetCallableStatement((NetAgent)this.netAgent_, (NetConnection)this, (String)sql, (int)type, (int)concurrency, (int)holdability, (ClientPooledConnection)this.pooledConnection_).callableStatement_;
    }

    @Override
    protected void resetCallableStatement_(ClientCallableStatement cs, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SqlException {
        ((NetCallableStatement)cs.materialCallableStatement_).resetNetCallableStatement(this.netAgent_, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    protected ClientDatabaseMetaData newDatabaseMetaData_() {
        return ClientAutoloadedDriver.getFactory().newNetDatabaseMetaData(this.netAgent_, this);
    }

    private void checkDatabaseName() throws SqlException {
        if (this.databaseName_ == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08001.C.1"), "databaseName");
        }
    }

    private void checkUserLength(String user) throws SqlException {
        int usridLength = user.length();
        if (usridLength == 0 || usridLength > 255) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.5"), usridLength, 255);
        }
    }

    private void checkPasswordLength(String password) throws SqlException {
        int passwordLength = password.length();
        if (passwordLength == 0 || passwordLength > 255) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.6"), passwordLength, 255);
        }
    }

    private void checkUser(String user) throws SqlException {
        if (user == null) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.7"), new Object[0]);
        }
        this.checkUserLength(user);
    }

    private void checkUserPassword(String user, String password) throws SqlException {
        this.checkUser(user);
        if (password == null) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.8"), new Object[0]);
        }
        this.checkPasswordLength(password);
    }

    private void checkSecmgrForSecmecSupport(int securityMechanism) throws SqlException {
        boolean secmecSupported = false;
        int[] supportedSecmecs = NetConfiguration.SECMGR_SECMECS;
        for (int i = 0; i < supportedSecmecs.length && !secmecSupported; ++i) {
            if (supportedSecmecs[i] != securityMechanism) continue;
            secmecSupported = true;
        }
        if (!secmecSupported) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.5"), securityMechanism);
        }
    }

    private SqlException mapSecchkcd(int secchkcd) {
        if (secchkcd == 0) {
            return null;
        }
        switch (secchkcd) {
            case 1: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J110", new Object[0]));
            }
            case 16: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J111", new Object[0]));
            }
            case 18: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J112", new Object[0]));
            }
            case 19: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J113", new Object[0]));
            }
            case 20: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J114", new Object[0]));
            }
            case 21: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J115", new Object[0]));
            }
            case 10: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J116", new Object[0]));
            }
            case 11: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J117", new Object[0]));
            }
            case 14: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J118", new Object[0]));
            }
            case 15: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J113", new Object[0]));
            }
        }
        return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J120", new Object[0]));
    }

    protected void constructCrrtkn() throws SqlException {
        if (this.crrtkn_ == null) {
            this.crrtkn_ = new byte[19];
        } else {
            Arrays.fill(this.crrtkn_, (byte)0);
        }
        byte[] localAddressBytes = this.netAgent_.socket_.getLocalAddress().getAddress();
        int i = 0;
        int j = 0;
        while (i < 4) {
            int num = localAddressBytes[i] < 0 ? localAddressBytes[i] + 256 : localAddressBytes[i];
            int halfByte = num >> 4 & 0xF;
            this.crrtkn_[j] = i == 0 ? this.netAgent_.getCurrentCcsidManager().numToSnaRequiredCrrtknChar_[halfByte] : this.netAgent_.getCurrentCcsidManager().numToCharRepresentation_[halfByte];
            halfByte = num & 0xF;
            this.crrtkn_[j + 1] = this.netAgent_.getCurrentCcsidManager().numToCharRepresentation_[halfByte];
            ++i;
            j += 2;
        }
        this.crrtkn_[8] = this.netAgent_.getCurrentCcsidManager().dot_;
        int num = this.netAgent_.socket_.getLocalPort();
        int halfByte = num >> 12 & 0xF;
        this.crrtkn_[9] = this.netAgent_.getCurrentCcsidManager().numToSnaRequiredCrrtknChar_[halfByte];
        halfByte = num >> 8 & 0xF;
        this.crrtkn_[10] = this.netAgent_.getCurrentCcsidManager().numToCharRepresentation_[halfByte];
        halfByte = num >> 4 & 0xF;
        this.crrtkn_[11] = this.netAgent_.getCurrentCcsidManager().numToCharRepresentation_[halfByte];
        halfByte = num & 0xF;
        this.crrtkn_[12] = this.netAgent_.getCurrentCcsidManager().numToCharRepresentation_[halfByte];
        long time = System.currentTimeMillis();
        for (int i2 = 0; i2 < 6; ++i2) {
            this.crrtkn_[i2 + 13] = (byte)(time >>> 40 - i2 * 8);
        }
    }

    private void constructExtnam() throws SqlException {
        char[] chars = Thread.currentThread().getName().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] <= '\u00ff') continue;
            chars[i] = 63;
        }
        this.extnam_ = "derbydnc" + new String(chars);
    }

    private void constructPrddta() throws SqlException {
        if (this.prddta_ == null) {
            this.prddta_ = ByteBuffer.allocate(255);
        } else {
            this.prddta_.clear();
            Arrays.fill(this.prddta_.array(), (byte)0);
        }
        CcsidManager ccsidMgr = this.netAgent_.getCurrentCcsidManager();
        for (int i = 0; i < 55; ++i) {
            this.prddta_.put(i, ccsidMgr.space_);
        }
        this.prddta_.position(1);
        boolean success = true;
        ccsidMgr.startEncoding();
        success &= ccsidMgr.encode(CharBuffer.wrap(NetConfiguration.PRDID), this.prddta_, this.agent_);
        ccsidMgr.startEncoding();
        success &= ccsidMgr.encode(CharBuffer.wrap("JVM               "), this.prddta_, this.agent_);
        int prddtaLen = this.prddta_.position();
        int extnamTruncateLength = Math.min(this.extnam_.length(), 20);
        ccsidMgr.startEncoding();
        SanityManager.ASSERT((boolean)(success &= ccsidMgr.encode(CharBuffer.wrap(this.extnam_, 0, extnamTruncateLength), this.prddta_, this.agent_)), (String)"PRDID, PRDDTA_PLATFORM_ID and EXTNAM exceeded PRDDTA_MAXSIZE");
        prddtaLen += 20;
        prddtaLen += 8;
        this.prddta_.put(55, (byte)0);
        this.prddta_.put(0, (byte)(++prddtaLen - 1));
    }

    private void initializePublicKeyForEncryption() throws SqlException {
        if (this.encryptionManager_ == null) {
            this.encryptionManager_ = new EncryptionManager(this.agent_);
        }
        this.publicKey_ = this.encryptionManager_.obtainPublicKey();
    }

    private void initializeClientSeed() throws SqlException {
        if (this.encryptionManager_ == null) {
            this.encryptionManager_ = new EncryptionManager(this.agent_, "SHA-1");
        }
        this.sourceSeed_ = this.encryptionManager_.generateSeed();
    }

    private byte[] encryptedPasswordForUSRENCPWD(String password) throws SqlException {
        return this.encryptionManager_.encryptData(this.netAgent_.getCurrentCcsidManager().convertFromJavaString(password, this.netAgent_), 7, this.netAgent_.getCurrentCcsidManager().convertFromJavaString(this.user_, this.netAgent_), this.targetPublicKey_);
    }

    private byte[] encryptedUseridForEUSRIDPWD() throws SqlException {
        return this.encryptionManager_.encryptData(this.netAgent_.getCurrentCcsidManager().convertFromJavaString(this.user_, this.netAgent_), 9, this.targetPublicKey_, this.targetPublicKey_);
    }

    private byte[] encryptedPasswordForEUSRIDPWD(String password) throws SqlException {
        return this.encryptionManager_.encryptData(this.netAgent_.getCurrentCcsidManager().convertFromJavaString(password, this.netAgent_), 9, this.targetPublicKey_, this.targetPublicKey_);
    }

    private byte[] passwordSubstituteForUSRSSBPWD(String password) throws SqlException {
        String dataSourceUserName;
        String userName = this.user_;
        if (this.dataSource_ != null && !(dataSourceUserName = this.dataSource_.getUser()).equals("") && userName.equalsIgnoreCase("APP") && !dataSourceUserName.equalsIgnoreCase("APP")) {
            userName = dataSourceUserName;
        }
        return this.encryptionManager_.substitutePassword(userName, password, this.sourceSeed_, this.targetSeed_);
    }

    public int getSQLAM() {
        return this.netAgent_.targetSqlam_;
    }

    public int getAGENT() {
        return this.targetAgent_;
    }

    public int getCMNTCPIP() {
        return this.targetCmntcpip_;
    }

    public int getRDB() {
        return this.targetRdb_;
    }

    public int getSECMGR() {
        return this.targetSecmgr_;
    }

    public int getXAMGR() {
        return this.targetXamgr_;
    }

    public int getSYNCPTMGR() {
        return this.targetSyncptmgr_;
    }

    public int getRSYNCMGR() {
        return this.targetRsyncmgr_;
    }

    private char[] flipBits(char[] array) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = (char)(array[n] ^ 0xFF);
        }
        return array;
    }

    @Override
    public void writeCommitSubstitute_() throws SqlException {
        this.netAgent_.connectionRequest_.writeCommitSubstitute(this);
    }

    @Override
    public void readCommitSubstitute_() throws SqlException {
        this.netAgent_.connectionReply_.readCommitSubstitute(this);
    }

    @Override
    public void writeLocalXAStart_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalXAStart(this);
    }

    @Override
    public void readLocalXAStart_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalXAStart(this);
    }

    @Override
    public void writeLocalXACommit_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalXACommit(this);
    }

    @Override
    public void readLocalXACommit_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalXACommit(this);
    }

    @Override
    public void writeLocalXARollback_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalXARollback(this);
    }

    @Override
    public void readLocalXARollback_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalXARollback(this);
    }

    @Override
    public void writeLocalCommit_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalCommit(this);
    }

    @Override
    public void readLocalCommit_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalCommit(this);
    }

    @Override
    public void writeLocalRollback_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalRollback(this);
    }

    @Override
    public void readLocalRollback_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalRollback(this);
    }

    @Override
    protected void markClosed_() {
    }

    @Override
    protected boolean isGlobalPending_() {
        return false;
    }

    @Override
    protected boolean doCloseStatementsOnClose_() {
        return this.closeStatementsOnClose;
    }

    @Override
    protected boolean allowCloseInUOW_() {
        return this.autoCommit_ || !this.allowLocalCommitRollback_();
    }

    @Override
    protected boolean allowLocalCommitRollback_() {
        return this.getXAState() == 0;
    }

    public void setInputStream(InputStream inputStream) {
        this.netAgent_.setInputStream(inputStream);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.netAgent_.setOutputStream(outputStream);
    }

    public InputStream getInputStream() {
        return this.netAgent_.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.netAgent_.getOutputStream();
    }

    @Override
    public void writeTransactionStart(ClientStatement statement) throws SqlException {
    }

    @Override
    public void readTransactionStart() throws SqlException {
        super.readTransactionStart();
    }

    public void setIndoubtTransactions(List<Xid> indoubtTransactions) {
        if (this.isXAConnection_) {
            if (this.indoubtTransactions_ != null) {
                this.indoubtTransactions_.clear();
            }
            this.indoubtTransactions_ = indoubtTransactions;
        }
    }

    Xid[] getIndoubtTransactionIds() {
        Xid[] result = new Xid[]{};
        return this.indoubtTransactions_.toArray(result);
    }

    @Override
    public SectionManager newSectionManager(Agent agent) {
        return new SectionManager(agent);
    }

    @Override
    public boolean willAutoCommitGenerateFlow() {
        if (!this.autoCommit_) {
            return false;
        }
        if (!this.isXAConnection_) {
            return true;
        }
        boolean doCommit = false;
        int xaState = this.getXAState();
        if (xaState == 0) {
            doCommit = true;
        }
        return doCommit;
    }

    public int getSecurityMechanism() {
        return this.securityMechanism_;
    }

    public EncryptionManager getEncryptionManager() {
        return this.encryptionManager_;
    }

    public byte[] getTargetPublicKey() {
        return this.targetPublicKey_ != null ? (byte[])this.targetPublicKey_.clone() : null;
    }

    public String getProductID() {
        return this.targetSrvclsnm_;
    }

    public final boolean isConnectionNull() {
        return this.connectionNull;
    }

    public void setConnectionNull(boolean connectionNull) {
        this.connectionNull = connectionNull;
    }

    final boolean serverSupportsQryclsimp() {
        NetDatabaseMetaData metadata = (NetDatabaseMetaData)this.databaseMetaData_;
        return metadata.serverSupportsQryclsimp();
    }

    public final boolean serverSupportsLayerBStreaming() {
        NetDatabaseMetaData metadata = (NetDatabaseMetaData)this.databaseMetaData_;
        return metadata.serverSupportsLayerBStreaming();
    }

    public final boolean serverSupportLongRDBNAM() {
        NetDatabaseMetaData metadata = (NetDatabaseMetaData)this.databaseMetaData_;
        return metadata.serverSupportLongRDBNAM();
    }

    @Override
    protected final boolean supportsSessionDataCaching() {
        NetDatabaseMetaData metadata = (NetDatabaseMetaData)this.databaseMetaData_;
        return metadata.serverSupportsSessionDataCaching();
    }

    protected final boolean serverSupportsUtf8Ccsid() {
        return this.targetUnicodemgr_ == 1208;
    }

    protected final boolean serverSupportsUDTs() {
        NetDatabaseMetaData metadata = (NetDatabaseMetaData)this.databaseMetaData_;
        return metadata.serverSupportsUDTs();
    }

    protected final boolean serverSupportsEXTDTAAbort() {
        NetDatabaseMetaData metadata = (NetDatabaseMetaData)this.databaseMetaData_;
        return metadata.serverSupportsEXTDTAAbort();
    }

    @Override
    protected final boolean serverSupportsLocators() {
        return this.serverSupportsLayerBStreaming();
    }

    @Override
    protected final boolean serverSupportsTimestampNanoseconds() {
        NetDatabaseMetaData metadata = (NetDatabaseMetaData)this.databaseMetaData_;
        return metadata.serverSupportsTimestampNanoseconds();
    }

    public boolean isOpen() {
        return this.open_;
    }

    @Override
    protected void writeXACommit_() throws SqlException {
        this.xares_.netXAConn_.writeCommit();
    }

    @Override
    protected void readXACommit_() throws SqlException {
        this.xares_.netXAConn_.readCommit();
    }

    @Override
    protected void writeXARollback_() throws SqlException {
        this.xares_.netXAConn_.writeRollback();
    }

    @Override
    protected void readXARollback_() throws SqlException {
        this.xares_.netXAConn_.readRollback();
    }

    @Override
    protected void writeXATransactionStart(ClientStatement statement) throws SqlException {
        this.xares_.netXAConn_.writeTransactionStart(statement);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw SQLExceptionFactory.notImplemented("createArrayOf(String,Object[])");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw SQLExceptionFactory.notImplemented("createNClob ()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw SQLExceptionFactory.notImplemented("createSQLXML ()");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw SQLExceptionFactory.notImplemented("createStruct(String,Object[])");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), timeout, "timeout", "java.sql.Connection.isValid").getSQLException();
        }
        if (this.isClosed()) {
            return false;
        }
        NetConnection netConnection = this;
        synchronized (netConnection) {
            try {
                int oldTimeout = this.netAgent_.getTimeout();
                this.netAgent_.setTimeout(timeout);
                if (this.isValidStmt == null) {
                    this.isValidStmt = this.prepareStatement("VALUES (1)");
                }
                this.isValidStmt.setQueryTimeout(timeout);
                ResultSet rs = this.isValidStmt.executeQuery();
                rs.close();
                this.netAgent_.setTimeout(oldTimeout);
            }
            catch (SQLException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isValidStmt != null) {
            this.isValidStmt.close();
            this.isValidStmt = null;
        }
        super.close();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Properties p = FailedProperties40.makeProperties(name, value);
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException se) {
            throw new SQLClientInfoException(se.getMessage(), se.getSQLState(), se.getErrorCode(), new FailedProperties40(p).getProperties());
        }
        if (name == null && value == null) {
            return;
        }
        this.setClientInfo(p);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        FailedProperties40 fp = new FailedProperties40(properties);
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException se) {
            throw new SQLClientInfoException(se.getMessage(), se.getSQLState(), se.getErrorCode(), fp.getProperties());
        }
        if (properties == null || properties.isEmpty()) {
            return;
        }
        SqlException se = new SqlException(this.agent_.logWriter_, new ClientMessageId("XCY02.S"), fp.getFirstKey(), fp.getFirstValue());
        throw new SQLClientInfoException(se.getMessage(), se.getSQLState(), se.getErrorCode(), fp.getProperties());
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            this.checkForClosedConnection();
            return null;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            this.checkForClosedConnection();
            return new Properties();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        return interfaces.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        try {
            this.checkForClosedConnection();
            return interfaces.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), interfaces).getSQLException();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }
}

