/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Random;

public class CharList {
    private static final int DEFAULT = 1024;
    private static final double RESIZE = 1.8;
    private char[] underlyingArray;
    private int pos;

    public CharList() {
        this.clear();
    }

    public CharList(int n) {
        this.underlyingArray = new char[n];
    }

    public CharList(char[] cArray) {
        this.underlyingArray = cArray;
        this.pos = cArray.length;
    }

    public boolean add(char c) {
        this.ensureCapacity(1);
        this.underlyingArray[this.pos++] = c;
        return true;
    }

    public void add(int n, char c) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean addAll(CharList charList) {
        this.ensureCapacity(charList.size());
        System.arraycopy(charList.underlyingArray, 0, this.underlyingArray, this.size(), charList.size());
        this.pos += charList.size();
        return true;
    }

    public boolean addAll(char[] cArray) {
        return this.addAll(cArray, 0, cArray.length);
    }

    public boolean addAll(char[] cArray, int n, int n2) {
        this.ensureCapacity(n2);
        System.arraycopy(cArray, n, this.underlyingArray, this.size(), n2);
        this.pos += cArray.length;
        return true;
    }

    public boolean addAll(int n, CharList charList) {
        throw new UnsupportedOperationException("TBD");
    }

    public void clear() {
        if (null == this.underlyingArray || 1024 != this.underlyingArray.length) {
            this.underlyingArray = new char[1024];
        }
        this.pos = 0;
    }

    public boolean contains(char c) {
        return this.indexOf(c) != -1;
    }

    public boolean containsAll(CharList charList) {
        throw new UnsupportedOperationException("TBD");
    }

    public char get(int n) {
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.underlyingArray[n];
    }

    public int indexOf(char c) {
        for (int i = 0; i != this.size(); ++i) {
            if (c != this.underlyingArray[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        for (int i = this.size() - 1; i != -1; --i) {
            if (c != this.underlyingArray[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public Iterator iterator(int n) {
        return new Iterator(this, n);
    }

    public boolean remove(char c) {
        throw new UnsupportedOperationException("TBD");
    }

    public char removeIdx(int n) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean removeAll(CharList charList) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean retainAll(CharList charList) {
        throw new UnsupportedOperationException("TBD");
    }

    public char set(int n, char c) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        char c2 = this.get(n);
        this.underlyingArray[n] = c;
        return c2;
    }

    public int size() {
        return this.pos;
    }

    public CharList subList(int n, int n2) {
        if (n < 0 || n2 > this.size() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        char[] cArray = new char[n3];
        System.arraycopy(this.underlyingArray, n, cArray, 0, n3);
        return new CharList(cArray);
    }

    public char[] toArray() {
        char[] cArray = new char[this.pos];
        System.arraycopy(this.underlyingArray, 0, cArray, 0, this.pos);
        return cArray;
    }

    private void ensureCapacity(int n) {
        int n2 = this.underlyingArray.length - this.pos;
        if (n2 < n) {
            this.resize(this.underlyingArray.length + n);
        }
    }

    private void resize(int n) {
        int n2 = this.max(n, (int)((double)this.underlyingArray.length * 1.8));
        char[] cArray = new char[n2];
        System.arraycopy(this.underlyingArray, 0, cArray, 0, this.pos);
        this.underlyingArray = cArray;
    }

    private int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        CharList charList = new CharList();
        Random random = new Random(0L);
        byte[] byArray = new byte[1];
        for (int i = 0; i != 250000; ++i) {
            char c = (char)random.nextInt();
            charList.add(c);
        }
        char[] cArray = charList.toArray();
        charList.addAll(cArray);
        CharList.p("ok...: " + charList.size() + " in: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i != 250000; ++i) {
            int n = random.nextInt();
            arrayList.add(new Integer(n));
        }
        arrayList.addAll(arrayList);
        CharList.p("ok...: " + arrayList.size() + " in: " + (System.currentTimeMillis() - l));
    }

    class Iterator {
        private CharList list;
        private int pos;

        public Iterator(CharList charList2) {
            this.list = charList2;
        }

        public Iterator(CharList charList2, int n) {
            if (n < 0 || n > charList2.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.list = charList2;
            this.pos = n;
        }

        boolean hasNext() {
            return this.pos < this.list.size();
        }

        char next() {
            if (this.pos >= this.list.size() || this.pos < 0) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.pos++);
        }

        void remove() {
            throw new UnsupportedOperationException("TBD");
        }
    }
}

