/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import com.headius.backport9.buffer.Buffers;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubySymbol;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.AliasInstr;
import org.jruby.ir.instructions.ArrayDerefInstr;
import org.jruby.ir.instructions.AsStringInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BFalseInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BNilInstr;
import org.jruby.ir.instructions.BSwitchInstr;
import org.jruby.ir.instructions.BTrueInstr;
import org.jruby.ir.instructions.BUndefInstr;
import org.jruby.ir.instructions.BlockGivenInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.BuildBackrefInstr;
import org.jruby.ir.instructions.BuildCompoundArrayInstr;
import org.jruby.ir.instructions.BuildCompoundStringInstr;
import org.jruby.ir.instructions.BuildDynRegExpInstr;
import org.jruby.ir.instructions.BuildLambdaInstr;
import org.jruby.ir.instructions.BuildRangeInstr;
import org.jruby.ir.instructions.BuildSplatInstr;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CheckArgsArrayArityInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.CheckForLJEInstr;
import org.jruby.ir.instructions.ClassSuperInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.DefineClassInstr;
import org.jruby.ir.instructions.DefineClassMethodInstr;
import org.jruby.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.ir.instructions.DefineMetaClassInstr;
import org.jruby.ir.instructions.DefineModuleInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.GVarAliasInstr;
import org.jruby.ir.instructions.GetClassVarContainerModuleInstr;
import org.jruby.ir.instructions.GetClassVariableInstr;
import org.jruby.ir.instructions.GetEncodingInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.GetGlobalVariableInstr;
import org.jruby.ir.instructions.InheritanceSearchConstInstr;
import org.jruby.ir.instructions.InstanceSuperInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LexicalSearchConstInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.LoadBlockImplicitClosureInstr;
import org.jruby.ir.instructions.LoadFrameClosureInstr;
import org.jruby.ir.instructions.LoadImplicitClosureInstr;
import org.jruby.ir.instructions.LoadLocalVarInstr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.NoResultCallInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.instructions.OptArgMultipleAsgnInstr;
import org.jruby.ir.instructions.PopBindingInstr;
import org.jruby.ir.instructions.PopMethodFrameInstr;
import org.jruby.ir.instructions.ProcessModuleBodyInstr;
import org.jruby.ir.instructions.PushMethodBindingInstr;
import org.jruby.ir.instructions.PushMethodFrameInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutConstInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.RaiseArgumentErrorInstr;
import org.jruby.ir.instructions.RaiseRequiredKeywordArgumentError;
import org.jruby.ir.instructions.ReceiveJRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordRestArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordsInstr;
import org.jruby.ir.instructions.ReceiveOptArgInstr;
import org.jruby.ir.instructions.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.ReceiveRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.ReifyClosureInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RescueEQQInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.ReturnOrRethrowSavedExcInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.SearchModuleForConstInstr;
import org.jruby.ir.instructions.SetCapturedVarInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.ToggleBacktraceInstr;
import org.jruby.ir.instructions.TraceInstr;
import org.jruby.ir.instructions.UndefMethodInstr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.ZSuperInstr;
import org.jruby.ir.instructions.defined.GetErrorInfoInstr;
import org.jruby.ir.instructions.defined.RestoreErrorInfoInstr;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.BuiltinClass;
import org.jruby.ir.operands.Complex;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.DynamicSymbol;
import org.jruby.ir.operands.Filename;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.GlobalVariable;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.MutableString;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Range;
import org.jruby.ir.operands.Rational;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.SValue;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.StandardError;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.SymbolProc;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariableType;
import org.jruby.ir.operands.UnboxedBoolean;
import org.jruby.ir.operands.UnboxedFixnum;
import org.jruby.ir.operands.UnboxedFloat;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.UnexecutableNil;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.persistence.IRPersistenceValues;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.Signature;
import org.jruby.util.ByteList;

public class IRReaderStream
implements IRReaderDecoder,
IRPersistenceValues {
    private final ByteBuffer buf;
    private final IRManager manager;
    private final List<IRScope> scopes;
    private IRScope currentScope;
    private final String filename;
    private RubySymbol[] constantPool;
    private Map<String, Operand> vars = null;

    public IRReaderStream(IRManager manager, byte[] bytes2, String filename2) {
        this(ByteBuffer.wrap(bytes2), manager, new ArrayList<IRScope>(), null, filename2, null);
    }

    public IRReaderStream(IRManager manager, File file2, String filename2) {
        this(IRReaderStream.readingIntoBuffer(file2), manager, new ArrayList<IRScope>(), null, filename2, null);
    }

    private IRReaderStream(ByteBuffer buf, IRManager manager, List<IRScope> scopes, IRScope currentScope, String filename2, RubySymbol[] constantPool) {
        this.buf = buf;
        this.manager = manager;
        this.scopes = scopes;
        this.currentScope = currentScope;
        this.filename = filename2;
        this.constantPool = constantPool;
    }

    @Override
    public IRReaderDecoder dup() {
        return new IRReaderStream(this.buf.duplicate(), this.manager, new ArrayList<IRScope>(this.scopes), this.currentScope, this.filename, this.constantPool);
    }

    private static ByteBuffer readingIntoBuffer(File file2) {
        try {
            return ByteBuffer.wrap(Files.readAllBytes(file2.toPath()));
        }
        catch (IOException e) {
            Logger.getLogger(IRReaderStream.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public ByteList decodeByteList() {
        return new ByteList(this.decodeByteArray(), this.decodeEncoding());
    }

    @Override
    public byte[] decodeByteArray() {
        int size2 = this.decodeInt();
        byte[] bytes2 = new byte[size2];
        this.buf.get(bytes2);
        return bytes2;
    }

    @Override
    public Encoding decodeEncoding() {
        int size2 = this.decodeInt();
        if (size2 == -1) {
            return USASCIIEncoding.INSTANCE;
        }
        if (size2 == -2) {
            return UTF8Encoding.INSTANCE;
        }
        byte[] encodingName = new byte[size2];
        this.buf.get(encodingName);
        return EncodingDB.getEncodings().get(encodingName).getEncoding();
    }

    @Override
    public Label decodeLabel() {
        return (Label)this.decodeOperand();
    }

    @Override
    public Label[] decodeLabelArray() {
        int size2 = this.decodeInt();
        Label[] labels = new Label[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            labels[i2] = this.decodeLabel();
        }
        return labels;
    }

    @Override
    public RubyEvent decodeRubyEvent() {
        return RubyEvent.fromOrdinal(this.decodeInt());
    }

    private RubySymbol decodeSymbolFromConstantPool() {
        int strLength = this.decodeInt();
        if (strLength == -1) {
            return null;
        }
        byte[] bytes2 = new byte[strLength];
        this.buf.get(bytes2);
        Encoding encoding2 = this.decodeEncoding();
        return this.manager.getRuntime().newSymbol(new ByteList(bytes2, encoding2, false));
    }

    @Override
    public RubySymbol decodeSymbol() {
        int poolIndex = this.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("INDEX: " + poolIndex);
        }
        return this.constantPool[poolIndex];
    }

    @Override
    public String decodeString() {
        int strLength = this.decodeInt();
        if (strLength == -1) {
            return null;
        }
        byte[] bytes2 = new byte[strLength];
        this.buf.get(bytes2);
        String newString = new String(bytes2).intern();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("STR<" + newString + ">");
        }
        return newString;
    }

    @Override
    public void addScope(IRScope scope) {
        this.scopes.add(scope);
        this.currentScope = scope;
    }

    @Override
    public IRScope getCurrentScope() {
        return this.currentScope;
    }

    @Override
    public String[] decodeStringArray() {
        int arrayLength = this.decodeInt();
        String[] array2 = new String[arrayLength];
        for (int i2 = 0; i2 < arrayLength; ++i2) {
            array2[i2] = this.decodeString();
        }
        return array2;
    }

    @Override
    public int[] decodeIntArray() {
        int size2 = this.decodeInt();
        int[] ints = new int[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            ints[i2] = this.decodeInt();
        }
        return ints;
    }

    @Override
    public Map<String, Operand> getVars() {
        return this.vars;
    }

    private void decodeConstantPool(int offset2) {
        Buffers.positionBuffer(this.buf, offset2);
        int size2 = this.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("DECODING " + size2 + " symbols");
        }
        this.constantPool = new RubySymbol[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            this.constantPool[i2] = this.decodeSymbolFromConstantPool();
            if (!RubyInstanceConfig.IR_READING_DEBUG) continue;
            System.out.println("SYM: " + this.constantPool[i2]);
        }
    }

    @Override
    public List<Instr> decodeInstructionsAt(IRScope scope, int poolOffset, int offset2) {
        this.decodeConstantPool(poolOffset);
        this.currentScope = scope;
        this.vars = new HashMap<String, Operand>();
        Buffers.positionBuffer(this.buf, offset2);
        int numberOfInstructions = this.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("Number of Instructions: " + numberOfInstructions);
        }
        ArrayList<Instr> instrs = new ArrayList<Instr>(numberOfInstructions);
        for (int i2 = 0; i2 < numberOfInstructions; ++i2) {
            Instr decodedInstr = this.decodeInstr();
            if (RubyInstanceConfig.IR_READING_DEBUG) {
                System.out.println(">INSTR = " + decodedInstr);
            }
            instrs.add(decodedInstr);
        }
        return instrs;
    }

    @Override
    public Instr decodeInstr() {
        Operation operation = this.decodeOperation();
        switch (operation) {
            case ALIAS: {
                return AliasInstr.decode(this);
            }
            case ARRAY_DEREF: {
                return ArrayDerefInstr.decode(this);
            }
            case ATTR_ASSIGN: {
                return AttrAssignInstr.decode(this);
            }
            case AS_STRING: {
                return AsStringInstr.decode(this);
            }
            case B_FALSE: {
                return BFalseInstr.decode(this);
            }
            case B_NIL: {
                return BNilInstr.decode(this);
            }
            case B_SWITCH: {
                return BSwitchInstr.decode(this);
            }
            case B_TRUE: {
                return BTrueInstr.decode(this);
            }
            case B_UNDEF: {
                return BUndefInstr.decode(this);
            }
            case BINDING_LOAD: {
                return LoadLocalVarInstr.decode(this);
            }
            case BINDING_STORE: {
                return StoreLocalVarInstr.decode(this);
            }
            case BLOCK_GIVEN: {
                return BlockGivenInstr.decode(this);
            }
            case BNE: {
                return BNEInstr.decode(this);
            }
            case BREAK: {
                return BreakInstr.decode(this);
            }
            case BUILD_BACKREF: {
                return BuildBackrefInstr.decode(this);
            }
            case BUILD_COMPOUND_ARRAY: {
                return BuildCompoundArrayInstr.decode(this);
            }
            case BUILD_COMPOUND_STRING: {
                return BuildCompoundStringInstr.decode(this);
            }
            case BUILD_DREGEXP: {
                return BuildDynRegExpInstr.decode(this);
            }
            case BUILD_RANGE: {
                return BuildRangeInstr.decode(this);
            }
            case BUILD_SPLAT: {
                return BuildSplatInstr.decode(this);
            }
            case CALL_1F: 
            case CALL_1D: 
            case CALL_1O: 
            case CALL_2O: 
            case CALL_1OB: 
            case CALL_0O: 
            case CALL: {
                return CallInstr.decode(this);
            }
            case CHECK_ARGS_ARRAY_ARITY: {
                return CheckArgsArrayArityInstr.decode(this);
            }
            case CHECK_ARITY: {
                return CheckArityInstr.decode(this);
            }
            case CHECK_FOR_LJE: {
                return CheckForLJEInstr.decode(this);
            }
            case CLASS_SUPER: {
                return ClassSuperInstr.decode(this);
            }
            case CLASS_VAR_MODULE: {
                return GetClassVarContainerModuleInstr.decode(this);
            }
            case COPY: {
                return CopyInstr.decode(this);
            }
            case DEF_CLASS: {
                return DefineClassInstr.decode(this);
            }
            case DEF_CLASS_METH: {
                return DefineClassMethodInstr.decode(this);
            }
            case DEF_INST_METH: {
                return DefineInstanceMethodInstr.decode(this);
            }
            case DEF_META_CLASS: {
                return DefineMetaClassInstr.decode(this);
            }
            case DEF_MODULE: {
                return DefineModuleInstr.decode(this);
            }
            case EQQ: {
                return EQQInstr.decode(this);
            }
            case EXC_REGION_END: {
                return new ExceptionRegionEndMarkerInstr();
            }
            case EXC_REGION_START: {
                return ExceptionRegionStartMarkerInstr.decode(this);
            }
            case GET_CVAR: {
                return GetClassVariableInstr.decode(this);
            }
            case GET_ENCODING: {
                return GetEncodingInstr.decode(this);
            }
            case GET_ERROR_INFO: {
                return GetErrorInfoInstr.decode(this);
            }
            case GET_FIELD: {
                return GetFieldInstr.decode(this);
            }
            case GET_GLOBAL_VAR: {
                return GetGlobalVariableInstr.decode(this);
            }
            case GVAR_ALIAS: {
                return GVarAliasInstr.decode(this);
            }
            case INHERITANCE_SEARCH_CONST: {
                return InheritanceSearchConstInstr.decode(this);
            }
            case INSTANCE_SUPER: {
                return InstanceSuperInstr.decode(this);
            }
            case JUMP: {
                return JumpInstr.decode(this);
            }
            case LABEL: {
                return LabelInstr.decode(this);
            }
            case LAMBDA: {
                return BuildLambdaInstr.decode(this);
            }
            case LEXICAL_SEARCH_CONST: {
                return LexicalSearchConstInstr.decode(this);
            }
            case LOAD_FRAME_CLOSURE: {
                return LoadFrameClosureInstr.decode(this);
            }
            case LOAD_BLOCK_IMPLICIT_CLOSURE: {
                return LoadBlockImplicitClosureInstr.decode(this);
            }
            case LOAD_IMPLICIT_CLOSURE: {
                return LoadImplicitClosureInstr.decode(this);
            }
            case LINE_NUM: {
                return LineNumberInstr.decode(this);
            }
            case MASGN_OPT: {
                return OptArgMultipleAsgnInstr.decode(this);
            }
            case MASGN_REQD: {
                return ReqdArgMultipleAsgnInstr.decode(this);
            }
            case MASGN_REST: {
                return RestArgMultipleAsgnInstr.decode(this);
            }
            case MATCH: {
                return MatchInstr.decode(this);
            }
            case NONLOCAL_RETURN: {
                return NonlocalReturnInstr.decode(this);
            }
            case NOP: {
                return NopInstr.NOP;
            }
            case NORESULT_CALL: 
            case NORESULT_CALL_1O: {
                return NoResultCallInstr.decode(this);
            }
            case POP_BINDING: {
                return PopBindingInstr.decode(this);
            }
            case POP_METHOD_FRAME: {
                return PopMethodFrameInstr.decode(this);
            }
            case PROCESS_MODULE_BODY: {
                return ProcessModuleBodyInstr.decode(this);
            }
            case PUSH_METHOD_BINDING: {
                return PushMethodBindingInstr.decode(this);
            }
            case PUSH_METHOD_FRAME: {
                return PushMethodFrameInstr.decode(this);
            }
            case PUT_CONST: {
                return PutConstInstr.decode(this);
            }
            case PUT_CVAR: {
                return PutClassVariableInstr.decode(this);
            }
            case PUT_FIELD: {
                return PutFieldInstr.decode(this);
            }
            case PUT_GLOBAL_VAR: {
                return PutGlobalVarInstr.decode(this);
            }
            case RAISE_ARGUMENT_ERROR: {
                return RaiseArgumentErrorInstr.decode(this);
            }
            case RAISE_REQUIRED_KEYWORD_ARGUMENT_ERROR: {
                return RaiseRequiredKeywordArgumentError.decode(this);
            }
            case RECORD_END_BLOCK: {
                return RecordEndBlockInstr.decode(this);
            }
            case REIFY_CLOSURE: {
                return ReifyClosureInstr.decode(this);
            }
            case RECV_RUBY_EXC: {
                return ReceiveRubyExceptionInstr.decode(this);
            }
            case RECV_JRUBY_EXC: {
                return ReceiveJRubyExceptionInstr.decode(this);
            }
            case RECV_KW: {
                return ReceiveKeywordsInstr.decode(this);
            }
            case RECV_KW_ARG: {
                return ReceiveKeywordArgInstr.decode(this);
            }
            case RECV_KW_REST_ARG: {
                return ReceiveKeywordRestArgInstr.decode(this);
            }
            case RECV_OPT_ARG: {
                return ReceiveOptArgInstr.decode(this);
            }
            case RECV_POST_REQD_ARG: {
                return ReceivePostReqdArgInstr.decode(this);
            }
            case RECV_PRE_REQD_ARG: {
                return ReceivePreReqdArgInstr.decode(this);
            }
            case RECV_REST_ARG: {
                return ReceiveRestArgInstr.decode(this);
            }
            case RECV_SELF: {
                return ReceiveSelfInstr.decode(this);
            }
            case RESCUE_EQQ: {
                return RescueEQQInstr.decode(this);
            }
            case RESTORE_ERROR_INFO: {
                return RestoreErrorInfoInstr.decode(this);
            }
            case RETURN: {
                return ReturnInstr.decode(this);
            }
            case RETURN_OR_RETHROW_SAVED_EXC: {
                return ReturnOrRethrowSavedExcInstr.decode(this);
            }
            case RUNTIME_HELPER: {
                return RuntimeHelperCall.decode(this);
            }
            case SEARCH_CONST: {
                return SearchConstInstr.decode(this);
            }
            case SEARCH_MODULE_FOR_CONST: {
                return SearchModuleForConstInstr.decode(this);
            }
            case SET_CAPTURED_VAR: {
                return SetCapturedVarInstr.decode(this);
            }
            case TRACE: {
                return TraceInstr.decode(this);
            }
            case THREAD_POLL: {
                return ThreadPollInstr.decode(this);
            }
            case THROW: {
                return ThrowExceptionInstr.decode(this);
            }
            case TO_ARY: {
                return ToAryInstr.decode(this);
            }
            case TOGGLE_BACKTRACE: {
                return ToggleBacktraceInstr.decode(this);
            }
            case UNDEF_METHOD: {
                return UndefMethodInstr.decode(this);
            }
            case UNRESOLVED_SUPER: {
                return UnresolvedSuperInstr.decode(this);
            }
            case YIELD: {
                return YieldInstr.decode(this);
            }
            case ZSUPER: {
                return ZSuperInstr.decode(this);
            }
        }
        this.illegalArgument("Unhandled operation: " + (Object)((Object)operation));
        return null;
    }

    @Override
    public IRScopeType decodeIRScopeType() {
        return IRScopeType.fromOrdinal(this.decodeInt());
    }

    @Override
    public TemporaryVariableType decodeTemporaryVariableType() {
        return TemporaryVariableType.fromOrdinal(this.decodeInt());
    }

    @Override
    public StaticScope.Type decodeStaticScopeType() {
        return StaticScope.Type.fromOrdinal(this.decodeInt());
    }

    @Override
    public Operation decodeOperation() {
        Operation operation = Operation.fromOrdinal(this.decodeInt());
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("INSTR<" + (Object)((Object)operation));
        }
        return operation;
    }

    @Override
    public Operand decodeOperand() {
        OperandType operandType = this.decodeOperandType();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("OP<" + (Object)((Object)operandType));
        }
        Operand decodedOperand = this.decode(operandType);
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println(">OP = " + decodedOperand);
        }
        return decodedOperand;
    }

    @Override
    public Variable decodeVariable() {
        return (Variable)this.decodeOperand();
    }

    @Override
    public Operand[] decodeOperandArray() {
        int size2 = this.decodeInt();
        Operand[] list2 = new Operand[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            list2[i2] = this.decodeOperand();
        }
        return list2;
    }

    @Override
    public List<Operand> decodeOperandList() {
        int size2 = this.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("OPERAND LIST of size: " + size2);
        }
        ArrayList<Operand> list2 = new ArrayList<Operand>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            if (RubyInstanceConfig.IR_READING_DEBUG) {
                System.out.println("OPERAND #" + i2);
            }
            list2.add(this.decodeOperand());
        }
        return list2;
    }

    @Override
    public OperandType decodeOperandType() {
        return OperandType.fromCoded(this.decodeByte());
    }

    @Override
    public boolean decodeBoolean() {
        byte value2 = this.buf.get();
        if (value2 == 116) {
            return true;
        }
        if (value2 == 102) {
            return false;
        }
        this.illegalArgument("Value (" + value2 + ", " + (char)value2 + ") is not a boolean. " + this.getFilename() + ", " + this.getCurrentScope());
        return false;
    }

    @Override
    public byte decodeByte() {
        return this.buf.get();
    }

    @Override
    public char decodeChar() {
        return this.buf.getChar();
    }

    @Override
    public int decodeInt() {
        int b2 = this.buf.get();
        return b2 == -1 ? this.buf.getInt() : b2;
    }

    @Override
    public int decodeIntRaw() {
        return this.buf.getInt();
    }

    @Override
    public long decodeLong() {
        byte b2 = this.buf.get();
        return b2 == -1 ? this.buf.getLong() : (long)b2;
    }

    @Override
    public double decodeDouble() {
        return this.buf.getDouble();
    }

    @Override
    public float decodeFloat() {
        return this.buf.getFloat();
    }

    @Override
    public IRScope decodeScope() {
        return this.scopes.get(this.decodeInt());
    }

    @Override
    public Signature decodeSignature() {
        return Signature.decode(this.decodeLong());
    }

    @Override
    public EnumSet<IRFlags> decodeIRFlags() {
        EnumSet<IRFlags> flags2 = EnumSet.noneOf(IRFlags.class);
        IRFlags[] values2 = IRFlags.values();
        for (int value2 = this.decodeInt(); value2 != 0; value2 ^= Integer.lowestOneBit(value2)) {
            int index2 = Integer.numberOfTrailingZeros(value2);
            flags2.add(values2[index2]);
        }
        return flags2;
    }

    @Override
    public void seek(int headersOffset) {
        Buffers.positionBuffer(this.buf, headersOffset);
    }

    public Operand decode(OperandType type2) {
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("Decoding operand " + (Object)((Object)type2));
        }
        switch (type2) {
            case ARRAY: {
                return Array.decode(this);
            }
            case BIGNUM: {
                return Bignum.decode(this);
            }
            case BOOLEAN: {
                return Boolean.decode(this);
            }
            case BUILTIN_CLASS: {
                return BuiltinClass.decode(this);
            }
            case COMPLEX: {
                return Complex.decode(this);
            }
            case CURRENT_SCOPE: {
                return CurrentScope.decode(this);
            }
            case DYNAMIC_SYMBOL: {
                return DynamicSymbol.decode(this);
            }
            case FILENAME: {
                return Filename.decode(this);
            }
            case FIXNUM: {
                return Fixnum.decode(this);
            }
            case FLOAT: {
                return Float.decode(this);
            }
            case FROZEN_STRING: {
                return FrozenString.decode(this);
            }
            case GLOBAL_VARIABLE: {
                return GlobalVariable.decode(this);
            }
            case HASH: {
                return Hash.decode(this);
            }
            case IR_EXCEPTION: {
                return IRException.decode(this);
            }
            case LABEL: {
                return Label.decode(this);
            }
            case LOCAL_VARIABLE: {
                return LocalVariable.decode(this);
            }
            case NIL: {
                return this.manager.getNil();
            }
            case NTH_REF: {
                return NthRef.decode(this);
            }
            case NULL_BLOCK: {
                return NullBlock.decode(this);
            }
            case RANGE: {
                return Range.decode(this);
            }
            case RATIONAL: {
                return Rational.decode(this);
            }
            case REGEXP: {
                return Regexp.decode(this);
            }
            case SCOPE_MODULE: {
                return ScopeModule.decode(this);
            }
            case SELF: {
                return Self.SELF;
            }
            case SPLAT: {
                return Splat.decode(this);
            }
            case STANDARD_ERROR: {
                return new StandardError();
            }
            case STRING_LITERAL: {
                return MutableString.decode(this);
            }
            case SVALUE: {
                return SValue.decode(this);
            }
            case SYMBOL: {
                return Symbol.decode(this);
            }
            case SYMBOL_PROC: {
                return SymbolProc.decode(this);
            }
            case TEMPORARY_VARIABLE: {
                return TemporaryLocalVariable.decode(this);
            }
            case UNBOXED_BOOLEAN: {
                return new UnboxedBoolean(this.decodeBoolean());
            }
            case UNBOXED_FIXNUM: {
                return new UnboxedFixnum(this.decodeLong());
            }
            case UNBOXED_FLOAT: {
                return new UnboxedFloat(this.decodeDouble());
            }
            case UNDEFINED_VALUE: {
                return UndefinedValue.UNDEFINED;
            }
            case UNEXECUTABLE_NIL: {
                return UnexecutableNil.U_NIL;
            }
            case WRAPPED_IR_CLOSURE: {
                return WrappedIRClosure.decode(this);
            }
        }
        throw new RuntimeException("failed to deserialize operand of type: " + (Object)((Object)type2));
    }

    private void illegalArgument(String message2) {
        throw new IllegalArgumentException(message2 + "\nfile: " + this.getFilename() + "\nscope: " + this.getCurrentScope());
    }
}

