/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyModule;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class DefineModuleInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr {
    private final IRModuleBody body;

    public DefineModuleInstr(Variable result2, Operand container, IRModuleBody body) {
        super(Operation.DEF_MODULE, result2, container);
        assert (result2 != null) : "DefineModuleInstr result is null";
        this.body = body;
    }

    public IRModuleBody getNewIRModuleBody() {
        return this.body;
    }

    public Operand getContainer() {
        return this.getOperand1();
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.body.getId()};
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new DefineModuleInstr(ii.getRenamedVariable(this.result), this.getContainer().cloneForInlining(ii), this.body);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getNewIRModuleBody());
    }

    public static DefineModuleInstr decode(IRReaderDecoder d) {
        return new DefineModuleInstr(d.decodeVariable(), d.decodeOperand(), (IRModuleBody)d.decodeScope());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Object container = this.getContainer().retrieve(context, self2, currScope, currDynScope, temp);
        RubyModule clazz = IRRuntimeHelpers.newRubyModuleFromIR(context, this.body.getId(), this.body.getStaticScope(), container, this.body.maybeUsingRefinements());
        return this.INTERPRET_MODULE(context, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_MODULE(ThreadContext context, RubyModule clazz) {
        InterpreterContext ic = this.body.getInterpreterContext();
        String id2 = this.body.getId();
        boolean hasExplicitCallProtocol = ic.hasExplicitCallProtocol();
        if (!hasExplicitCallProtocol) {
            this.pre(ic, context, clazz, null, clazz);
        }
        try {
            ThreadContext.pushBacktrace(context, id2, ic.getFileName(), ic.getLine());
            IRubyObject iRubyObject = ic.getEngine().interpret(context, null, clazz, ic, clazz.getMethodLocation(), id2, Block.NULL_BLOCK);
            return iRubyObject;
        }
        finally {
            this.body.cleanupAfterExecution();
            if (!hasExplicitCallProtocol) {
                this.post(ic, context);
            }
            ThreadContext.popBacktrace(context);
        }
    }

    private void post(InterpreterContext ic, ThreadContext context) {
        context.popFrame();
        if (ic.popDynScope()) {
            context.popScope();
        }
    }

    private void pre(InterpreterContext ic, ThreadContext context, IRubyObject self2, String name2, RubyModule implClass) {
        context.preMethodFrameOnly(implClass, name2, self2);
        if (ic.pushNewDynScope()) {
            context.pushScope(DynamicScope.newDynamicScope(ic.getStaticScope()));
        }
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DefineModuleInstr(this);
    }
}

